/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class WriteProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = -8069702863937020350L;
    private boolean _forHTML;
    private boolean _forHyperText;
    private ProcessorProperty _value;
    private ProcessorProperty _default;
    private ProcessorProperty _escapeXml;
    private ProcessorProperty _escapeWhitespace;
    private ProcessorProperty _escapeEol;

    public void initialize() {
        QName originalQName = this.getOriginalNode().getQName();
        this._forHTML = this.isHTML(originalQName);
        this._forHyperText = this._forHTML || this.isXHTML(originalQName);
    }

    public void setValue(ProcessorProperty value) {
        this._value = value;
    }

    public void setDefault(ProcessorProperty defaultValue) {
        this._default = defaultValue;
    }

    public void setEscapeXml(ProcessorProperty escapeXml) {
        this._escapeXml = escapeXml;
    }

    public void setEscapeWhitespace(ProcessorProperty escapeWhitespace) {
        this._escapeWhitespace = escapeWhitespace;
    }

    public void setEscapeEol(ProcessorProperty escapeEol) {
        this._escapeEol = escapeEol;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._value != null) {
            Object result = this._value.getValue().execute(null);
            String ret = null;
            boolean empty = StringUtil.isEmpty(result);
            if (empty && this._default != null) {
                result = this._default.getValue().execute(null);
                if (result != null) {
                    ret = result.toString();
                }
            } else if (!empty) {
                ret = String.valueOf(result);
                if (this.toBoolean(this._escapeXml)) {
                    ret = StringUtil.escapeXml(ret);
                }
                if (this._forHyperText && this.toBoolean(this._escapeEol)) {
                    ret = StringUtil.escapeEol(ret, this._forHTML);
                }
                if (this.toBoolean(this._escapeWhitespace)) {
                    ret = StringUtil.escapeWhitespace(ret);
                }
            }
            if (ret != null) {
                ServiceCycle cycle = CycleUtil.getServiceCycle();
                cycle.getResponse().write(ret);
            }
        }
        return ProcessStatus.SKIP_BODY;
    }

    private boolean toBoolean(ProcessorProperty property) {
        return property != null && ObjectUtil.booleanValue(property.getValue().execute(null), false);
    }

    public void kill() {
        this._value = null;
        this._default = null;
        this._escapeXml = null;
        this._escapeWhitespace = null;
        this._escapeEol = null;
        super.kill();
    }
}

