/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.AbstractSoftReferencePool;

public class FormatNumberProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = 7899970766673369995L;
    private static Map _formatPools = new HashMap();
    private ProcessorProperty _value;
    private ProcessorProperty _default;
    private String _pattern;

    public void initialize() {
        if (this._pattern == null) {
            this._pattern = new DecimalFormat().toPattern();
        }
    }

    public void setValue(ProcessorProperty value) {
        this._value = value;
    }

    public void setDefault(ProcessorProperty defaultValue) {
        this._default = defaultValue;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._value != null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            cycle.getResponse().write(this.format(this._value));
        }
        return ProcessStatus.SKIP_BODY;
    }

    private String format(ProcessorProperty property) {
        Object result = property.getValue().execute(null);
        if (StringUtil.hasValue(result)) {
            if (result instanceof Number || result instanceof String) {
                NumberFormatPool pool = this.getFormatPool();
                NumberFormat formatter = pool.borrowFormat();
                String formattedValue = formatter.format(ObjectUtil.numberValue(result, null));
                pool.returnFormat(formatter);
                return formattedValue;
            }
            throw new IllegalArgumentException("argument type mismatch: " + result.getClass().getName());
        }
        if (this._default != null) {
            return (String)this._default.getValue().execute(null);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NumberFormatPool getFormatPool() {
        Map map = _formatPools;
        synchronized (map) {
            NumberFormatPool pool = (NumberFormatPool)_formatPools.get(this._pattern);
            if (pool == null) {
                pool = new NumberFormatPool(this._pattern);
                _formatPools.put(this._pattern, pool);
            }
            return pool;
        }
    }

    public void kill() {
        this._value = null;
        this._default = null;
        super.kill();
    }

    protected static class NumberFormatPool
    extends AbstractSoftReferencePool {
        private static final long serialVersionUID = -4295432835558317767L;
        private String _formatPattern;

        public NumberFormatPool(String formatPattern) {
            if (formatPattern == null) {
                throw new IllegalArgumentException();
            }
            this._formatPattern = formatPattern;
        }

        protected Object createObject() {
            return new DecimalFormat(this._formatPattern);
        }

        protected boolean validateObject(Object object) {
            return object instanceof NumberFormat;
        }

        public NumberFormat borrowFormat() {
            return (NumberFormat)this.borrowObject();
        }

        public void returnFormat(NumberFormat format) {
            if (format != null) {
                this.returnObject(format);
            }
        }
    }
}

