/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class ExecProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = -1413583265341468324L;
    private ProcessorProperty _script;
    private ProcessorProperty _src;
    private ProcessorProperty _encoding;

    public void setSrc(ProcessorProperty src) {
        this._src = src;
    }

    public void setEncoding(ProcessorProperty encoding) {
        this._encoding = encoding;
    }

    public void setScript(ProcessorProperty script) {
        this._script = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._src != null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            String srcValue = StringUtil.valueOf(this._src.getValue().execute(null));
            String encValue = StringUtil.valueOf(this._encoding.getValue().execute(null));
            if (StringUtil.isRelativePath(srcValue)) {
                String sourcePath = EngineUtil.getSourcePath(this.getParentProcessor());
                srcValue = StringUtil.adjustRelativePath(sourcePath, srcValue);
            }
            cycle.load(srcValue, encValue);
        }
        if (this._script != null) {
            SpecificationUtil.endScope();
            try {
                this._script.getValue().execute(null);
            }
            finally {
                SpecificationUtil.startScope(this.getVariables());
            }
        }
        return ProcessStatus.EVAL_BODY_INCLUDE;
    }

    public void kill() {
        this._script = null;
        this._src = null;
        this._encoding = null;
        super.kill();
    }
}

