/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;

public class CDATAProcessor
extends TemplateProcessorSupport
implements CONST_IMPL {
    private static final long serialVersionUID = -4267623139201513906L;
    private static final String CDATAIN = "<![CDATA[";
    private static final String CDATAOUT = "]]>";

    public ProcessStatus doStartProcess(Page topLevelPage) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(CDATAIN);
        return ProcessStatus.EVAL_BODY_INCLUDE;
    }

    public ProcessStatus doEndProcess() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(CDATAOUT);
        return ProcessStatus.EVAL_PAGE;
    }

    public ProcessorTreeWalker[] divide(SequenceIDGenerator sequenceIDGenerator) {
        if (!this.getOriginalNode().getQName().equals(CONST_IMPL.QM_CDATA)) {
            return new ProcessorTreeWalker[]{this};
        }
        ProcessorTreeWalker[] results = new ProcessorTreeWalker[2 + this.getChildProcessorSize()];
        LiteralCharactersProcessor literalProcessor = new LiteralCharactersProcessor(CDATAIN);
        BuilderUtil.characterProcessorCopy(this, literalProcessor, sequenceIDGenerator);
        results[0] = literalProcessor;
        for (int i = 0; i < this.getChildProcessorSize(); ++i) {
            results[i + 1] = this.getChildProcessor(i);
            results[i + 1].setParentProcessor(this.getParentProcessor());
        }
        literalProcessor = new LiteralCharactersProcessor(CDATAOUT);
        BuilderUtil.characterProcessorCopy(this, literalProcessor, sequenceIDGenerator);
        results[results.length - 1] = literalProcessor;
        this.getParentProcessor().removeProcessor(this);
        return results;
    }
}

