/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.error;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.error.ErrorHandler;
import org.seasar.mayaa.impl.IllegalParameterValueException;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.PageNotFoundException;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class TemplateErrorHandler
extends ParameterAwareImpl
implements ErrorHandler {
    private static final long serialVersionUID = -6643723526947091557L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler == null ? (class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler = TemplateErrorHandler.class$("org.seasar.mayaa.impl.engine.error.TemplateErrorHandler")) : class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler));
    private String _folder = "/";
    private String _extension = "html";
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler;

    protected String getFolder() {
        return this._folder;
    }

    protected String getExtension() {
        return this._extension;
    }

    protected String getPageName(Class throwableClass) {
        if (throwableClass == null) {
            throw new IllegalArgumentException();
        }
        String name = throwableClass.getName();
        return StringUtil.preparePath(this.getFolder()) + StringUtil.preparePath(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doErrorHandle(Throwable t, boolean pageFlush) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        boolean isPageNotFound = t instanceof PageNotFoundException;
        if (isPageNotFound && LOG.isInfoEnabled()) {
            LOG.info((Object)t.getMessage());
        }
        for (Class<?> throwableClass = t.getClass(); throwableClass != null; throwableClass = throwableClass.getSuperclass()) {
            String pageName = this.getPageName(throwableClass);
            try {
                Engine engine = ProviderUtil.getEngine();
                Page page = engine.getPage(pageName);
                SpecificationUtil.startScope(null);
                try {
                    page.doPageRender("", this.getExtension());
                }
                finally {
                    SpecificationUtil.endScope();
                }
                if (!isPageNotFound && LOG.isErrorEnabled()) {
                    String msg = StringUtil.getMessage(class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler == null ? (class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler = TemplateErrorHandler.class$("org.seasar.mayaa.impl.engine.error.TemplateErrorHandler")) : class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler, 1, t.getMessage());
                    LOG.error((Object)msg, t);
                }
                if (!pageFlush) break;
                Response response = CycleUtil.getResponse();
                response.flush();
                break;
            }
            catch (PageNotFoundException ignore) {
                if (!LOG.isInfoEnabled()) continue;
                String msg = StringUtil.getMessage(class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler == null ? TemplateErrorHandler.class$("org.seasar.mayaa.impl.engine.error.TemplateErrorHandler") : class$org$seasar$mayaa$impl$engine$error$TemplateErrorHandler, 2, pageName);
                LOG.info((Object)msg);
                continue;
            }
        }
    }

    public void setParameter(String name, String value) {
        if ("folder".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._folder = value;
        } else if ("extension".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._extension = value;
        }
        super.setParameter(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

