/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.impl.util.ReferenceCache;

public class SpecificationCache {
    protected int _surviveLimit;
    protected Map _specifications = new HashMap();
    protected ReferenceCache _gcChecker;
    protected static TimeredSweepThread _cleanUpSpecification = new TimeredSweepThread();
    protected SoftReference _gabage;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$SpecificationCache;

    public SpecificationCache(int surviveLimit) {
        this._surviveLimit = surviveLimit;
        if (surviveLimit > 0) {
            this._gcChecker = new ReferenceCache(class$java$lang$Object == null ? (class$java$lang$Object = SpecificationCache.class$("java.lang.Object")) : class$java$lang$Object, 0, new GCReceiver());
            this.postNewGabage();
        }
    }

    protected void postNewGabage() {
        Object gabage = new Object();
        this._gabage = new SoftReference<Object>(gabage);
        this._gcChecker.add(gabage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String systemID) {
        SpecificationCache specificationCache = this;
        synchronized (specificationCache) {
            return this._specifications.containsKey(systemID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Specification get(String systemID) {
        ReferSpecification refer;
        if (systemID == null) {
            throw new IllegalArgumentException();
        }
        SpecificationCache specificationCache = this;
        synchronized (specificationCache) {
            refer = (ReferSpecification)this._specifications.get(systemID);
        }
        if (refer == null) {
            return null;
        }
        Specification result = refer.getSpecification();
        if (refer.isDeprecated()) {
            _cleanUpSpecification.post(result);
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Specification specification) {
        if (specification == null) {
            throw new IllegalArgumentException();
        }
        SpecificationCache specificationCache = this;
        synchronized (specificationCache) {
            Specification old = this.get(specification.getSystemID());
            if (old != null) {
                if (old == specification) {
                    return;
                }
                _cleanUpSpecification.post(old);
            }
            ReferSpecification refer = new ReferSpecification(specification);
            this._specifications.put(specification.getSystemID(), refer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SpecificationCache specificationCache = this;
        synchronized (specificationCache) {
            this._specifications = null;
            _cleanUpSpecification = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GCReceiver
    implements ReferenceCache.SweepListener {
        private final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$SpecificationCache == null ? (class$org$seasar$mayaa$impl$engine$SpecificationCache = SpecificationCache.class$("org.seasar.mayaa.impl.engine.SpecificationCache")) : class$org$seasar$mayaa$impl$engine$SpecificationCache));
        private volatile int _receiveCount = 0;

        protected GCReceiver() {
        }

        public Object labeling(Object referent) {
            return new Integer(++this._receiveCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sweepFinish(ReferenceCache monitor, Object label) {
            SpecificationCache specificationCache = SpecificationCache.this;
            synchronized (specificationCache) {
                ReferSpecification refer;
                if (SpecificationCache.this._specifications == null || _cleanUpSpecification == null) {
                    return;
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("remove " + label + "th time." + " free:" + Runtime.getRuntime().freeMemory() + " / total:" + Runtime.getRuntime().totalMemory()));
                }
                ArrayList<ReferSpecification> releaseItems = null;
                Iterator<Object> it = SpecificationCache.this._specifications.values().iterator();
                while (it.hasNext()) {
                    refer = (ReferSpecification)it.next();
                    if (!refer.requestRelease()) continue;
                    if (releaseItems == null) {
                        releaseItems = new ArrayList<ReferSpecification>();
                    }
                    releaseItems.add(refer);
                }
                if (releaseItems != null) {
                    it = releaseItems.iterator();
                    while (it.hasNext()) {
                        refer = (ReferSpecification)it.next();
                        Specification spec = refer.getSpecification();
                        _cleanUpSpecification.add(spec);
                        SpecificationCache.this._specifications.remove(spec.getSystemID());
                        if (!this.LOG.isDebugEnabled()) continue;
                        this.LOG.debug((Object)("remove " + label + "th time. " + spec.getSystemID() + " remove from cache"));
                    }
                }
                SpecificationCache.this.postNewGabage();
            }
        }
    }

    private static class TimeredSweepThread
    extends Thread {
        private Map _repeaseSpecs = new LinkedHashMap();

        public TimeredSweepThread() {
            this.setName("TimeredSweepThread");
            this.start();
        }

        public void post(Specification releaseSpec) {
            new Thread(new Runnable(this, releaseSpec){
                private final /* synthetic */ Specification val$releaseSpec;
                private final /* synthetic */ TimeredSweepThread this$0;
                {
                    this.this$0 = this$0;
                    this.val$releaseSpec = val$releaseSpec;
                }

                public void run() {
                    this.this$0.add(this.val$releaseSpec);
                }
            }).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(Specification releaseSpec) {
            long timing = System.currentTimeMillis() + 30000L;
            Map map = this._repeaseSpecs;
            synchronized (map) {
                this._repeaseSpecs.put(releaseSpec, new Long(timing));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (_cleanUpSpecification != null) {
                try {
                    Thread.sleep(1000L);
                    Map map = this._repeaseSpecs;
                    synchronized (map) {
                        Iterator it = this._repeaseSpecs.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            long timeup = (Long)entry.getValue();
                            if (System.currentTimeMillis() <= timeup) continue;
                            Specification spec = (Specification)entry.getKey();
                            spec.kill();
                            it.remove();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class ReferSpecification {
        private Specification _specification;
        private int _survivingCount;
        boolean _deprecated;

        public ReferSpecification(Specification specification) {
            if (specification == null) {
                throw new IllegalArgumentException();
            }
            this._specification = specification;
        }

        public Specification getSpecification() {
            this._survivingCount = 0;
            return this._specification;
        }

        public boolean isDeprecated() {
            if (!this._deprecated && this._specification.isDeprecated()) {
                this._deprecated = true;
            }
            return this._deprecated;
        }

        public boolean requestRelease() {
            ++this._survivingCount;
            if (this._survivingCount > SpecificationCache.this._surviveLimit) {
                this._survivingCount = 0;
                this._deprecated = true;
                return true;
            }
            return false;
        }
    }
}

