/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import java.util.LinkedList;
import java.util.Map;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.TemplateRenderer;
import org.seasar.mayaa.engine.processor.ChildEvaluationProcessor;
import org.seasar.mayaa.engine.processor.IterationProcessor;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.processor.TryCatchFinallyProcessor;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.PageNotFoundException;
import org.seasar.mayaa.impl.engine.processor.ElementProcessor;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class RenderUtil
implements CONST_IMPL {
    private static final ProcessStatus SKIP_BODY = ProcessStatus.SKIP_BODY;
    private static final ProcessStatus EVAL_BODY_INCLUDE = ProcessStatus.EVAL_BODY_INCLUDE;
    private static final ProcessStatus SKIP_PAGE = ProcessStatus.SKIP_PAGE;
    private static final ProcessStatus EVAL_PAGE = ProcessStatus.EVAL_PAGE;
    private static final ProcessStatus EVAL_BODY_AGAIN = ProcessStatus.EVAL_BODY_AGAIN;
    private static final ProcessStatus EVAL_BODY_BUFFERED = ProcessStatus.EVAL_BODY_BUFFERED;
    private static final String CURRENT_PROCESSOR_KEY = "__currentProcessor__";

    private RenderUtil() {
    }

    public static boolean isEvaluation(TemplateProcessor current) {
        return current instanceof ChildEvaluationProcessor && ((ChildEvaluationProcessor)current).isChildEvaluation();
    }

    public static ChildEvaluationProcessor getEvaluation(TemplateProcessor current) {
        return (ChildEvaluationProcessor)current;
    }

    public static boolean isIteration(TemplateProcessor current) {
        return current instanceof IterationProcessor && ((IterationProcessor)current).isIteration();
    }

    public static IterationProcessor getIteration(TemplateProcessor current) {
        return (IterationProcessor)current;
    }

    public static boolean isDuplicated(TemplateProcessor current) {
        return current instanceof ElementProcessor && ((ElementProcessor)current).isDuplicated();
    }

    public static boolean isTryCatchFinally(TemplateProcessor current) {
        if (current instanceof TryCatchFinallyProcessor) {
            TryCatchFinallyProcessor tryCatchFinallyProcessor = (TryCatchFinallyProcessor)current;
            return tryCatchFinallyProcessor.canCatch();
        }
        return false;
    }

    public static TryCatchFinallyProcessor getTryCatchFinally(TemplateProcessor current) {
        return (TryCatchFinallyProcessor)current;
    }

    public static void saveToCycle(ProcessorTreeWalker current) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setProcessor(current);
        if (current instanceof TemplateProcessor) {
            TemplateProcessor proc = (TemplateProcessor)current;
            cycle.setOriginalNode(proc.getOriginalNode());
            cycle.setInjectedNode(proc.getInjectedNode());
        } else if (current instanceof Template) {
            Template temp = (Template)current;
            cycle.setOriginalNode(temp);
            cycle.setInjectedNode(temp);
        }
    }

    private static void pushWriter(TemplateProcessor current, ServiceCycle cycle) {
        ChildEvaluationProcessor processor = RenderUtil.getEvaluation(current);
        processor.setBodyContent(cycle.getResponse().pushWriter());
        processor.doInitChildProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProcessStatus renderTemplateProcessor(Page topLevelPage, TemplateProcessor current) {
        boolean buffered;
        ProcessStatus ret;
        ServiceCycle cycle;
        block23: {
            block22: {
                ProcessStatus processStatus;
                block21: {
                    ProcessStatus processStatus2;
                    block20: {
                        if (current == null) {
                            throw new IllegalArgumentException();
                        }
                        RenderUtil.saveToCycle(current);
                        cycle = CycleUtil.getServiceCycle();
                        ret = EVAL_PAGE;
                        buffered = false;
                        RenderUtil.setCurrentProcessor(current);
                        SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_BEFORE_RENDER_PROCESSOR);
                        try {
                            try {
                                SpecificationUtil.startScope(current.getVariables());
                                ProcessStatus startRet = EVAL_BODY_INCLUDE;
                                startRet = current.doStartProcess(topLevelPage);
                                if (startRet == SKIP_PAGE) {
                                    processStatus2 = SKIP_PAGE;
                                    Object var13_9 = null;
                                    break block20;
                                }
                                if (startRet == EVAL_BODY_BUFFERED && RenderUtil.isEvaluation(current)) {
                                    buffered = true;
                                    RenderUtil.pushWriter(current, cycle);
                                }
                                if (startRet == EVAL_BODY_INCLUDE || startRet == EVAL_BODY_BUFFERED) {
                                    ProcessStatus afterRet;
                                    do {
                                        for (int i = 0; i < current.getChildProcessorSize(); ++i) {
                                            ProcessorTreeWalker child = current.getChildProcessor(i);
                                            if (!(child instanceof TemplateProcessor)) {
                                                throw new IllegalStateException("child processor type error");
                                            }
                                            TemplateProcessor childProc = (TemplateProcessor)child;
                                            ProcessStatus childRet = RenderUtil.renderTemplateProcessor(topLevelPage, childProc);
                                            if (childRet != SKIP_PAGE) continue;
                                            processStatus = SKIP_PAGE;
                                            break block21;
                                        }
                                        afterRet = SKIP_BODY;
                                        RenderUtil.saveToCycle(current);
                                        if (!RenderUtil.isIteration(current)) continue;
                                        if (buffered) {
                                            buffered = false;
                                            cycle.getResponse().popWriter();
                                        }
                                        afterRet = RenderUtil.getIteration(current).doAfterChildProcess();
                                        ProcessorTreeWalker parent = current.getParentProcessor();
                                        if (!(parent instanceof TemplateProcessor)) continue;
                                        TemplateProcessor parentProc = (TemplateProcessor)parent;
                                        if (afterRet != EVAL_BODY_AGAIN || !RenderUtil.isDuplicated(parentProc)) continue;
                                        RenderUtil.saveToCycle(parentProc);
                                        parentProc.doEndProcess();
                                        parentProc.doStartProcess(null);
                                        if (startRet != EVAL_BODY_BUFFERED || !RenderUtil.isEvaluation(current)) continue;
                                        buffered = true;
                                        RenderUtil.pushWriter(current, cycle);
                                    } while (afterRet == EVAL_BODY_AGAIN);
                                }
                                RenderUtil.saveToCycle(current);
                                if (buffered) {
                                    cycle.getResponse().popWriter();
                                    RenderUtil.getIteration(current).doAfterChildProcess();
                                }
                                ret = current.doEndProcess();
                                break block22;
                            }
                            catch (RuntimeException e) {
                                if (!RenderUtil.isTryCatchFinally(current)) {
                                    throw e;
                                }
                                RenderUtil.getTryCatchFinally(current).doCatchProcess(e);
                                Object var13_12 = null;
                                SpecificationUtil.endScope();
                                if (RenderUtil.isTryCatchFinally(current)) {
                                    RenderUtil.getTryCatchFinally(current).doFinallyProcess();
                                }
                                RenderUtil.setCurrentProcessor(current);
                                SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PROCESSOR);
                                RenderUtil.setCurrentProcessor(null);
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_13 = null;
                            SpecificationUtil.endScope();
                            if (RenderUtil.isTryCatchFinally(current)) {
                                RenderUtil.getTryCatchFinally(current).doFinallyProcess();
                            }
                            RenderUtil.setCurrentProcessor(current);
                            SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PROCESSOR);
                            RenderUtil.setCurrentProcessor(null);
                            throw throwable;
                        }
                    }
                    SpecificationUtil.endScope();
                    if (RenderUtil.isTryCatchFinally(current)) {
                        RenderUtil.getTryCatchFinally(current).doFinallyProcess();
                    }
                    RenderUtil.setCurrentProcessor(current);
                    SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PROCESSOR);
                    RenderUtil.setCurrentProcessor(null);
                    return processStatus2;
                }
                Object var13_10 = null;
                SpecificationUtil.endScope();
                if (RenderUtil.isTryCatchFinally(current)) {
                    RenderUtil.getTryCatchFinally(current).doFinallyProcess();
                }
                RenderUtil.setCurrentProcessor(current);
                SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PROCESSOR);
                RenderUtil.setCurrentProcessor(null);
                return processStatus;
            }
            Object var13_11 = null;
            SpecificationUtil.endScope();
            if (RenderUtil.isTryCatchFinally(current)) {
                RenderUtil.getTryCatchFinally(current).doFinallyProcess();
            }
            RenderUtil.setCurrentProcessor(current);
            SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PROCESSOR);
            RenderUtil.setCurrentProcessor(null);
        }
        if (buffered) {
            RenderUtil.getEvaluation(current).setBodyContent(cycle.getResponse().getWriter());
        }
        return ret;
    }

    protected static TemplateProcessor getCurrentProcessor() {
        return (TemplateProcessor)CycleUtil.getRequestScope().getAttribute(CURRENT_PROCESSOR_KEY);
    }

    protected static void setCurrentProcessor(TemplateProcessor processor) {
        CycleUtil.getRequestScope().setAttribute(CURRENT_PROCESSOR_KEY, processor);
    }

    public static ProcessStatus renderProcessorTree(Page topLevelPage, ProcessorTreeWalker root) {
        for (int i = 0; i < root.getChildProcessorSize(); ++i) {
            ProcessorTreeWalker child = root.getChildProcessor(i);
            if (child instanceof TemplateProcessor) {
                TemplateProcessor childProc = (TemplateProcessor)child;
                ProcessStatus childRet = RenderUtil.renderTemplateProcessor(topLevelPage, childProc);
                if (childRet != SKIP_PAGE) continue;
                return SKIP_PAGE;
            }
            throw new IllegalStateException("child processor is not a templateProcessor");
        }
        return EVAL_PAGE;
    }

    public static void saveToCycle(Page page) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(page);
        cycle.setInjectedNode(page);
    }

    protected static Template getTemplate(String requestedSuffix, Page page, String suffix, String extension) {
        if (CONST_IMPL.QM_MAYAA.getLocalName().equals(extension)) {
            SourceDescriptor source = page.getSource();
            if (!source.exists()) {
                String pageName = page.getPageName();
                throw new PageNotFoundException(pageName, extension);
            }
        } else {
            if (StringUtil.isEmpty(suffix)) {
                if (StringUtil.isEmpty(requestedSuffix)) {
                    CompiledScript script = page.getSuffixScript();
                    suffix = (String)script.execute(null);
                } else {
                    suffix = requestedSuffix;
                }
            }
            return page.getTemplate(suffix, extension);
        }
        return null;
    }

    public static ProcessStatus renderPage(boolean fireEvent, TemplateRenderer renderer, Map variables, Page topLevelPage, String requestedSuffix, String extension) {
        if (renderer == null || topLevelPage == null) {
            throw new IllegalArgumentException();
        }
        Page page = topLevelPage;
        String suffix = null;
        RenderUtil.saveToCycle(page);
        LinkedList<Page> pageStack = fireEvent ? new LinkedList<Page>() : null;
        LinkedList<Template> templateStack = new LinkedList<Template>();
        do {
            Template template;
            if (fireEvent) {
                pageStack.add(0, page);
                SpecificationUtil.startScope(variables);
                SpecificationUtil.execEvent(page, CONST_IMPL.QM_BEFORE_RENDER);
            }
            if ((template = RenderUtil.getTemplate(requestedSuffix, page, suffix, extension)) != null) {
                templateStack.add(0, template);
            }
            suffix = page.getSuperSuffix();
            extension = page.getSuperExtension();
            page = page.getSuperPage();
            variables = null;
        } while (page != null);
        ProcessStatus ret = null;
        int templateSize = templateStack.size();
        if (templateSize > 0) {
            Template[] templates = templateStack.toArray(new Template[templateSize]);
            ret = renderer.renderTemplate(topLevelPage, templates);
            RenderUtil.saveToCycle(page);
        }
        if (fireEvent) {
            for (int i = 0; i < pageStack.size(); ++i) {
                page = (Page)pageStack.get(i);
                RenderUtil.saveToCycle(page);
                SpecificationUtil.execEvent(page, CONST_IMPL.QM_AFTER_RENDER);
                SpecificationUtil.endScope();
            }
        }
        return ret;
    }
}

