/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import java.io.PrintStream;
import java.util.Iterator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.ElementProcessor;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.util.StringUtil;

public class ProcessorDump
extends ElementProcessor {
    private static final long serialVersionUID = 8044884422670533823L;
    private static final PrintStream DEFAULT_OUT = System.out;
    private PrintStream _out = DEFAULT_OUT;
    private String _headerLine = "DUMPSTART =======================================";
    private String _footerLine = "DUMPEND =========================================";
    private String _indentChar = "    ";
    private boolean _printContents = false;

    public void setOut(PrintStream out) {
        this._out = out;
    }

    public void setIndentChar(String indentChar) {
        if (indentChar == null) {
            throw new IllegalStateException("indentChar is null");
        }
        this._indentChar = indentChar;
    }

    public void setPrintContents(boolean printContents) {
        this._printContents = printContents;
    }

    public void printSource(Page topLevelPage) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        RequestScope request = cycle.getRequestScope();
        String requestedSuffix = request.getRequestedSuffix();
        String extension = request.getExtension();
        Template template = topLevelPage.getTemplate(requestedSuffix, extension);
        this.print(this._headerLine);
        this.print(template.getSystemID());
        this.printTree(0, template);
        this.print(this._footerLine);
    }

    protected void printTree(int indentCount, ProcessorTreeWalker walker) {
        int childSize = walker.getChildProcessorSize();
        if (walker instanceof TemplateProcessor) {
            this.printTag(indentCount, (TemplateProcessor)walker, "<", childSize > 0 ? ">" : " />", true);
        }
        if (childSize > 0) {
            for (int i = 0; i < childSize; ++i) {
                this.printTree(indentCount + 1, walker.getChildProcessor(i));
            }
            if (walker instanceof TemplateProcessor) {
                this.printTag(indentCount, (TemplateProcessor)walker, "</", ">", false);
            }
        }
    }

    protected void printTag(int indentCount, TemplateProcessor processor, String start, String end, boolean printAttributes) {
        if (this._printContents && processor instanceof LiteralCharactersProcessor) {
            this.print(((LiteralCharactersProcessor)processor).getText());
        } else {
            StringBuffer sb = new StringBuffer(128);
            for (int i = 0; i < indentCount; ++i) {
                sb.append(this._indentChar);
            }
            sb.append(start);
            SpecificationNode node = this.getNode(processor);
            String prefix = "";
            PrefixMapping mapping = node.getMappingFromURI(node.getQName().getNamespaceURI(), true);
            if (mapping != null && StringUtil.hasValue(mapping.getPrefix())) {
                prefix = mapping.getPrefix() + ":";
            }
            sb.append(prefix);
            sb.append(node.getQName().getLocalName());
            if (printAttributes) {
                this.writeAttributes(sb, processor);
            }
            sb.append(end);
            this.print(sb.toString());
        }
    }

    protected SpecificationNode getNode(TemplateProcessor processor) {
        ElementProcessor ep;
        if (processor instanceof ElementProcessor && (ep = (ElementProcessor)processor).isDuplicated()) {
            return processor.getOriginalNode();
        }
        return processor.getInjectedNode();
    }

    protected void writeAttributes(StringBuffer sb, TemplateProcessor processor) {
        if (processor instanceof ElementProcessor) {
            this.writeElementAttributes(sb, (ElementProcessor)processor);
        } else {
            SpecificationNode node = processor.getInjectedNode();
            URI namespace = node.getQName().getNamespaceURI();
            Iterator it = processor.getInjectedNode().iterateAttribute();
            while (it.hasNext()) {
                PrefixMapping mapping;
                NodeAttribute prop = (NodeAttribute)it.next();
                QName propName = prop.getQName();
                String prefix = "";
                if (!namespace.equals(propName.getNamespaceURI()) && (mapping = node.getMappingFromURI(propName.getNamespaceURI(), true)) != null && StringUtil.hasValue(mapping.getPrefix())) {
                    prefix = mapping.getPrefix() + ":";
                }
                this.writeProcessorAttributeString(sb, prefix, propName.getLocalName(), prop.getValue());
            }
        }
    }

    protected void writeElementAttributes(StringBuffer sb, ElementProcessor processor) {
        ProcessorProperty prop;
        Iterator it = processor.iterateProcesstimeProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            this.appendAttributeString(sb, prop.getName(), prop.getValue());
        }
        it = processor.iterateInformalProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            if (this.hasProcesstimeProperty(prop) || prop.getValue().isLiteral()) continue;
            this.appendAttributeString(sb, prop.getName(), prop.getValue());
        }
        it = processor.iterateInformalProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            if (this.hasProcesstimeProperty(prop) || !prop.getValue().isLiteral()) continue;
            this.appendAttributeString(sb, prop.getName(), prop.getValue());
        }
    }

    protected void appendAttributeString(StringBuffer buffer, PrefixAwareName propName, Object value) {
        QName qName = propName.getQName();
        if (CONST_IMPL.URI_MAYAA.equals(qName.getNamespaceURI())) {
            return;
        }
        String attrPrefix = propName.getPrefix();
        if (StringUtil.hasValue(attrPrefix) && StringUtil.hasValue(attrPrefix)) {
            attrPrefix = attrPrefix + ":";
        }
        StringBuffer temp = new StringBuffer();
        temp.append(" ");
        temp.append(attrPrefix);
        temp.append(qName.getLocalName());
        temp.append("=\"");
        if (value instanceof CompiledScript) {
            CompiledScript script = (CompiledScript)value;
            if (CycleUtil.isDraftWriting()) {
                temp.append(script.getScriptText());
            } else {
                Object result = script.execute(null);
                if (StringUtil.isEmpty(result)) {
                    return;
                }
                temp.append(result);
            }
        } else {
            temp.append(value.toString());
        }
        temp.append("\"");
        buffer.append(temp.toString());
    }

    protected void writeProcessorAttributeString(StringBuffer sb, String prefix, String localName, Object value) {
        sb.append(" ");
        sb.append(prefix);
        sb.append(localName);
        sb.append("=\"");
        if (value instanceof CompiledScript) {
            CompiledScript script = (CompiledScript)value;
            sb.append(script.getScriptText());
        } else {
            sb.append(value.toString());
        }
        sb.append("\"");
    }

    protected void print(String value) {
        this._out.println(value);
    }
}

