/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.mayaa.cycle.scope.SessionScope;
import org.seasar.mayaa.cycle.script.ScriptEnvironment;
import org.seasar.mayaa.impl.cycle.scope.AbstractWritableAttributeScope;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.IteratorUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.EnumerationIterator;

public class SessionScopeImpl
extends AbstractWritableAttributeScope
implements SessionScope {
    private static final long serialVersionUID = -3211729351966533995L;
    private HttpServletRequest _httpRequest;
    private HttpSession _httpSession;

    protected void check(boolean create) {
        if (this._httpRequest == null) {
            throw new IllegalStateException();
        }
        if (this._httpSession != null) {
            try {
                this._httpSession.getId();
            }
            catch (IllegalArgumentException e) {
                this._httpSession = null;
            }
        }
        if (this._httpSession == null) {
            this._httpSession = this._httpRequest.getSession(create);
        }
    }

    public String getSessionID() {
        this.check(false);
        if (this._httpSession == null) {
            return null;
        }
        return this._httpSession.getId();
    }

    public String getScopeName() {
        return "session";
    }

    public Iterator iterateAttributeNames() {
        this.check(false);
        if (this._httpSession == null) {
            return IteratorUtil.NULL_ITERATOR;
        }
        return EnumerationIterator.getInstance(this._httpSession.getAttributeNames());
    }

    public boolean hasAttribute(String name) {
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        this.check(false);
        if (this._httpSession == null) {
            return false;
        }
        Enumeration e = this._httpSession.getAttributeNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        this.check(false);
        if (this._httpSession == null) {
            return null;
        }
        ScriptEnvironment env = ProviderUtil.getScriptEnvironment();
        return env.convertFromScriptObject(this._httpSession.getAttribute(name));
    }

    public void setAttribute(String name, Object attribute) {
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this.check(true);
        this._httpSession.setAttribute(name, attribute);
    }

    public void removeAttribute(String name) {
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this.check(false);
        if (this._httpSession != null) {
            this._httpSession.removeAttribute(name);
        }
    }

    public void setUnderlyingContext(Object context) {
        if (context == null || !(context instanceof HttpServletRequest)) {
            throw new IllegalArgumentException();
        }
        this._httpRequest = (HttpServletRequest)context;
        this._httpSession = null;
    }

    public Object getUnderlyingContext() {
        this.check(false);
        return this._httpSession;
    }
}

