/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.seasar.mayaa.impl.cycle.AbstractResponse;
import org.seasar.mayaa.impl.cycle.web.ResponseHeaderCache;
import org.seasar.mayaa.impl.util.StringUtil;

public class ResponseImpl
extends AbstractResponse {
    private static final long serialVersionUID = -4653384671998376182L;
    private HttpServletResponse _httpServletResponse;
    private ResponseHeaderCache _headers = new ResponseHeaderCache();
    private int _status;

    protected void check() {
        if (this._httpServletResponse == null) {
            throw new IllegalStateException();
        }
    }

    public void redirect(String url) {
        if (!this.isFlushed()) {
            this.check();
            try {
                this._httpServletResponse.sendRedirect(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void error(int errorCode, String message) {
        if (!this.isFlushed()) {
            this.check();
            try {
                this._httpServletResponse.sendError(errorCode, message);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void setContentTypeToUnderlyingObject(String contentType) {
        this.check();
        if (StringUtil.isEmpty(contentType)) {
            throw new IllegalArgumentException();
        }
        this._httpServletResponse.setContentType(contentType);
    }

    public void addHeader(String name, String value) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._httpServletResponse.addHeader(name, value);
        this._headers.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._httpServletResponse.setHeader(name, value);
        this._headers.setHeader(name, value);
    }

    public void setStatus(int code) {
        this.check();
        this._httpServletResponse.setStatus(code);
        this._status = code;
    }

    public OutputStream getOutputStream() {
        this.check();
        try {
            return this._httpServletResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String encodeURL(String url) {
        this.check();
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException();
        }
        return this._httpServletResponse.encodeURL(url);
    }

    public void setUnderlyingContext(Object context) {
        if (context == null || !(context instanceof HttpServletResponse)) {
            throw new IllegalArgumentException();
        }
        this._httpServletResponse = (HttpServletResponse)context;
        this.clearBuffer();
    }

    public Object getUnderlyingContext() {
        this.check();
        return this._httpServletResponse;
    }

    public List getHeaders(String name) {
        return this._headers.getHeaders(name);
    }

    public boolean containsHeader(String name) {
        return this._headers.containsHeader(name);
    }

    public Set getHeaderNames() {
        return this._headers.getHeaderNames();
    }

    public int getStatus() {
        return this._status;
    }

    public String getCharacterEncoding() {
        return this._httpServletResponse.getCharacterEncoding();
    }
}

