/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.seasar.mayaa.impl.cycle.scope.AbstractReadOnlyAttributeScope;
import org.seasar.mayaa.impl.util.collection.EnumerationIterator;

public class ParamValuesScope
extends AbstractReadOnlyAttributeScope {
    private static final long serialVersionUID = -1118348498272772955L;
    private transient HttpServletRequest _request;

    public ParamValuesScope(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        this._request = request;
    }

    public String getScopeName() {
        return "paramValues";
    }

    public Iterator iterateAttributeNames() {
        return EnumerationIterator.getInstance(this._request.getParameterNames());
    }

    public boolean hasAttribute(String name) {
        Iterator it = this.iterateAttributeNames();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            if (!paramName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        if (this.hasAttribute(name)) {
            return this._request.getParameterValues(name);
        }
        return null;
    }
}

