/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.mayaa.impl.cycle.web.MockHttpSession;
import org.seasar.mayaa.impl.cycle.web.MockServletRequest;
import org.seasar.mayaa.impl.util.StringUtil;

public class MockHttpServletRequest
extends MockServletRequest
implements HttpServletRequest {
    private ServletContext _servletContext;
    private String _path;
    private String _contextPath;
    private HttpSession _session;

    public MockHttpServletRequest(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException();
        }
        this._servletContext = servletContext;
        this._contextPath = this._servletContext.getServletContextName();
    }

    public HttpSession getSession(boolean create) {
        if (this._session == null && create) {
            this._session = new MockHttpSession(this._servletContext);
        }
        return this._session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getServletPath() {
        return "";
    }

    public void setPathInfo(String path) {
        this._path = StringUtil.preparePath(path);
    }

    public String getPathInfo() {
        return this._path;
    }

    public String getPathTranslated() {
        return this.getPathInfo();
    }

    public String getRequestURI() {
        return this.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getPathInfo());
    }

    public String getQueryString() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public String getMethod() {
        return "GET";
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public String getHeader(String name) {
        return null;
    }

    public Enumeration getHeaders(String name) {
        return null;
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public int getIntHeader(String name) {
        return 0;
    }

    public String getAuthType() {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String user) {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }
}

