/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.cycle.CycleFactory;
import org.seasar.mayaa.cycle.CycleLocalVariables;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.cycle.script.ScriptEnvironment;
import org.seasar.mayaa.impl.CycleLocalVariablesImpl;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.cycle.CycleThreadLocalFactory;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.StandardScope;
import org.seasar.mayaa.impl.cycle.scope.ScopeNotFoundException;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class CycleFactoryImpl
extends ParameterAwareImpl
implements CycleFactory {
    private static final long serialVersionUID = 6930908159752133949L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$cycle$CycleFactoryImpl == null ? (class$org$seasar$mayaa$impl$cycle$CycleFactoryImpl = CycleFactoryImpl.class$("org.seasar.mayaa.impl.cycle.CycleFactoryImpl")) : class$org$seasar$mayaa$impl$cycle$CycleFactoryImpl));
    private static ThreadLocal _currentCycle = new ThreadLocal();
    protected StandardScope _standardScope = new StandardScope();
    private Object _context;
    private Class _serviceClass;
    private CycleLocalVariables _localVariables = new CycleLocalVariablesImpl();
    static /* synthetic */ Class class$org$seasar$mayaa$impl$cycle$CycleFactoryImpl;

    public void setServiceClass(Class serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException();
        }
        this._serviceClass = serviceClass;
    }

    public Class getServiceClass() {
        if (this._serviceClass == null) {
            throw new IllegalArgumentException();
        }
        return this._serviceClass;
    }

    public void initialize(Object requestContext, Object responseContext) {
        if (requestContext == null || responseContext == null) {
            throw new IllegalArgumentException();
        }
        ServiceCycle cycle = this.defaultServiceCycle();
        _currentCycle.set(cycle);
        RequestScope request = cycle.getRequestScope();
        request.setUnderlyingContext(requestContext);
        Response response = cycle.getResponse();
        response.setUnderlyingContext(responseContext);
        CycleThreadLocalFactory.cycleLocalInitialize();
    }

    public void cycleFinalize() {
        CycleThreadLocalFactory.cycleLocalFinalize();
        _currentCycle.set(null);
    }

    public CycleLocalVariables getLocalVariables() {
        return this._localVariables;
    }

    protected ServiceCycle defaultServiceCycle() {
        Class serviceCycleClass = this.getServiceClass();
        if (serviceCycleClass == null) {
            throw new IllegalStateException();
        }
        ServiceCycle cycle = (ServiceCycle)ObjectUtil.newInstance(serviceCycleClass);
        Iterator it = this.iterateParameterNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = this.getParameter(key);
            cycle.setParameter(key, value);
        }
        return cycle;
    }

    public ServiceCycle getServiceCycle() {
        ServiceCycle cycle = (ServiceCycle)_currentCycle.get();
        if (cycle == null) {
            cycle = this.defaultServiceCycle();
            _currentCycle.set(cycle);
            LOG.info((Object)"serviceCycle created out of request cycle.");
        }
        return cycle;
    }

    public StandardScope getStandardScope() {
        return this._standardScope;
    }

    public void setUnderlyingContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
    }

    public Object getUnderlyingContext() {
        if (this._context == null) {
            throw new IllegalStateException();
        }
        return this._context;
    }

    private boolean isValidScopeName(String scopeName) {
        if (StringUtil.hasValue(scopeName)) {
            ScriptEnvironment scriptEnvironment = ProviderUtil.getScriptEnvironment();
            Iterator it = scriptEnvironment.iterateAttributeScope();
            while (it.hasNext()) {
                AttributeScope scope = (AttributeScope)it.next();
                if (!scopeName.equals(scope.getScopeName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setParameter(String name, String value) {
        if ("addedStandardScope".equals(name)) {
            if (!this.isValidScopeName(value)) {
                throw new ScopeNotFoundException(value);
            }
            CycleUtil.addStandardScope(value);
        }
        super.setParameter(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

