/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.scanner;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.impl.IllegalParameterValueException;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.source.ApplicationSourceDescriptor;
import org.seasar.mayaa.impl.source.FileSourceDescriptor;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class FolderSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private static final long serialVersionUID = 2888604805693825909L;
    private FileSourceDescriptor _source;
    private String _folder;
    private boolean _recursive = false;
    private boolean _absolute = false;
    private Set _extensions = new HashSet();
    private Set _unmodifiableExtensions = Collections.unmodifiableSet(this._extensions);

    public String getFolder() {
        if (StringUtil.isEmpty(this._folder)) {
            throw new IllegalStateException();
        }
        return this._folder;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public Set getExtensions() {
        return this._unmodifiableExtensions;
    }

    protected String[] getExtensionArray() {
        return this._extensions.toArray(new String[this._extensions.size()]);
    }

    public Iterator scan() {
        ApplicationScope appScope = null;
        if (this._source == null) {
            if (this._absolute) {
                this._source = new FileSourceDescriptor();
            } else {
                ApplicationSourceDescriptor appSource = new ApplicationSourceDescriptor();
                appScope = appSource.getApplicationScope();
                appSource.setDenyWebInf(false);
                this._source = appSource;
            }
            this._source.setRoot(this.getFolder());
        }
        if (this._source.exists() && this._source.getFile().isDirectory()) {
            return new FileToSourceIterator(appScope, this._source.getRoot(), this.iterateFiles(this._source.getFile()));
        }
        return NullIterator.getInstance();
    }

    protected Iterator iterateFiles(File dir) {
        if (dir.exists()) {
            File[] files = dir.isDirectory() ? this.listFiles(dir) : new File[]{dir};
            return new FileArrayIterator(files);
        }
        return NullIterator.getInstance();
    }

    protected FileFilter createExtensionFilter() {
        return new FileFilter(){
            private final String[] _acceptableExtensions;
            {
                this._acceptableExtensions = FolderSourceScanner.this.getExtensionArray();
            }

            public boolean accept(File pathName) {
                if (pathName.isDirectory()) {
                    return true;
                }
                if (this._acceptableExtensions.length == 0) {
                    return true;
                }
                for (int i = 0; i < this._acceptableExtensions.length; ++i) {
                    if (!pathName.getName().endsWith(this._acceptableExtensions[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected File[] listFiles(File dir) {
        ArrayList sources = new ArrayList();
        FileFilter filter = this.createExtensionFilter();
        if (this._recursive) {
            this.listFilesRecursive(sources, dir, filter);
        } else {
            this.listFilesNonRecursive(sources, dir, filter);
        }
        return sources.toArray(new File[sources.size()]);
    }

    protected void listFilesNonRecursive(List list, File dir, FileFilter filter) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                list.add(files[i]);
            }
        }
    }

    protected void listFilesRecursive(List list, File dir, FileFilter filter) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.listFilesRecursive(list, files[i], filter);
                    continue;
                }
                list.add(files[i]);
            }
        }
    }

    public void setParameter(String name, String value) {
        if ("folder".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._folder = value;
        } else if ("recursive".equals(name)) {
            this._recursive = Boolean.valueOf(value);
        } else if ("absolute".equals(name)) {
            this._absolute = Boolean.valueOf(value);
        } else if ("extension".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            if (value.charAt(0) != '.') {
                this._extensions.add('.' + value);
            } else {
                this._extensions.add(value);
            }
        }
        super.setParameter(name, value);
    }

    protected class FileToSourceIterator
    implements Iterator {
        private ApplicationScope _applicationScope;
        private String _root;
        private Iterator _iterator;

        public FileToSourceIterator(ApplicationScope applicationScope, String root, Iterator iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException();
            }
            this._applicationScope = applicationScope;
            this._root = root;
            this._iterator = iterator;
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        private String getSystemID(File file) {
            String sourceRoot = this._root;
            if (StringUtil.isEmpty(sourceRoot)) {
                sourceRoot = "/";
            }
            String root = this._applicationScope != null ? this._applicationScope.getRealPath(sourceRoot) : "";
            String absolutePath = file.getAbsolutePath();
            String path = absolutePath.substring(root.length());
            return StringUtil.preparePath(path);
        }

        public Object next() {
            Object ret = this._iterator.next();
            if (ret instanceof File) {
                File file = (File)ret;
                String systemID = this.getSystemID(file);
                ApplicationSourceDescriptor source = new ApplicationSourceDescriptor();
                source.setDenyWebInf(false);
                source.setRoot(this._root);
                source.setSystemID(systemID);
                source.setFile(file);
                return source;
            }
            throw new IllegalStateException();
        }

        public void remove() {
            this._iterator.remove();
        }
    }

    protected static class FileArrayIterator
    implements Iterator {
        private File[] _files;
        private int _index;

        public FileArrayIterator(File[] files) {
            if (files == null) {
                throw new IllegalArgumentException();
            }
            this._files = files;
        }

        public boolean hasNext() {
            return this._index < this._files.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._files[this._index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

