/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.builder.library.TemplateAttributeReader;
import org.seasar.mayaa.builder.library.converter.PropertyConverter;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.builder.library.NoRequiredPropertyException;
import org.seasar.mayaa.impl.builder.library.PropertyDefinitionImpl;
import org.seasar.mayaa.impl.engine.processor.ProcessorPropertyLiteral;
import org.seasar.mayaa.impl.engine.specification.NodeAttributeImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class TLDPropertyDefinition
extends PropertyDefinitionImpl {
    private static final long serialVersionUID = -2999228650173085084L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition == null ? (class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition = TLDPropertyDefinition.class$("org.seasar.mayaa.impl.builder.library.TLDPropertyDefinition")) : class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition));
    private boolean _rtexprvalue;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$processor$ProcessorProperty;

    protected PropertyConverter getConverterForProcessorProperty() {
        LibraryDefinition library = this.getPropertySet().getLibraryDefinition();
        PropertyConverter converter = library.getPropertyConverter(class$org$seasar$mayaa$engine$processor$ProcessorProperty == null ? (class$org$seasar$mayaa$engine$processor$ProcessorProperty = TLDPropertyDefinition.class$("org.seasar.mayaa.engine.processor.ProcessorProperty")) : class$org$seasar$mayaa$engine$processor$ProcessorProperty);
        if (converter == null) {
            throw new IllegalStateException();
        }
        return converter;
    }

    protected NodeAttribute getTemplateAttribute(SpecificationNode original, SpecificationNode injected) {
        TemplateAttributeReader reader = ProviderUtil.getTemplateAttributeReader();
        String value = reader.getValue(injected.getQName(), this.getName(), original);
        if (value != null) {
            return new NodeAttributeImpl(this.getQName(injected), value);
        }
        return null;
    }

    public Object createProcessorProperty(ProcessorDefinition processorDef, SpecificationNode original, SpecificationNode injected) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        Class propertyClass = this.getPropertyClass(processorDef);
        if (propertyClass == null) {
            String processorName = processorDef.getName();
            if (LOG.isWarnEnabled()) {
                String msg = StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition == null ? (class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition = TLDPropertyDefinition.class$("org.seasar.mayaa.impl.builder.library.TLDPropertyDefinition")) : class$org$seasar$mayaa$impl$builder$library$TLDPropertyDefinition, 0, processorName, this.getName());
                LOG.warn((Object)msg);
            }
            return null;
        }
        QName qName = this.getQName(injected);
        NodeAttribute attribute = injected.getAttribute(qName);
        if (attribute == null) {
            attribute = this.getTemplateAttribute(original, injected);
        }
        if (attribute != null) {
            if (this.isRtexprvalue()) {
                PropertyConverter converter = this.getConverterForProcessorProperty();
                return converter.convert(attribute, attribute.getValue(), propertyClass);
            }
            PrefixAwareName prefixAwareName = SpecificationUtil.createPrefixAwareName(attribute.getQName(), attribute.getPrefix());
            return new ProcessorPropertyLiteral(prefixAwareName, attribute.getValue());
        }
        if (this.isRequired()) {
            String processorName = processorDef.getName();
            throw new NoRequiredPropertyException(processorName, qName);
        }
        return null;
    }

    public boolean isRtexprvalue() {
        return this._rtexprvalue;
    }

    public void setRtexprvalue(boolean rtexprvalue) {
        this._rtexprvalue = rtexprvalue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

