/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.library.DefinitionBuilder;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.scanner.SourceAlias;
import org.seasar.mayaa.impl.builder.library.scanner.WebXMLTaglibSourceScanner;
import org.seasar.mayaa.impl.builder.library.tld.TLDLibraryDefinitionHandler;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.XMLUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class TLDDefinitionBuilder
extends ParameterAwareImpl
implements DefinitionBuilder {
    private static final long serialVersionUID = 8241504208792699894L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$TLDDefinitionBuilder == null ? (class$org$seasar$mayaa$impl$builder$library$TLDDefinitionBuilder = TLDDefinitionBuilder.class$("org.seasar.mayaa.impl.builder.library.TLDDefinitionBuilder")) : class$org$seasar$mayaa$impl$builder$library$TLDDefinitionBuilder));
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$TLDDefinitionBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryDefinition build(SourceDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        String systemID = source.getSystemID();
        if (source.exists() && systemID.toLowerCase().endsWith(".tld")) {
            InputStream stream = source.getInputStream();
            TLDLibraryDefinitionHandler handler = new TLDLibraryDefinitionHandler();
            try {
                XMLUtil.parse(handler, stream, "tld", systemID, true, true, true);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("TLD parse error on " + systemID), t);
                }
                LibraryDefinition libraryDefinition = null;
                return libraryDefinition;
            }
            finally {
                IOUtil.close(stream);
            }
            LibraryDefinition library = handler.getLibraryDefinition();
            boolean assigned = ObjectUtil.booleanValue(source.getParameter(WebXMLTaglibSourceScanner.ASSIGNED), false);
            if (assigned || "/META-INF/taglib.tld".equals(systemID)) {
                URI assignedURI = SpecificationUtil.createURI(source.getParameter(SourceAlias.ALIAS));
                library.addAssignedURI(assignedURI);
            }
            return library;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

