/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.library.DefinitionBuilder;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.mld.LibraryDefinitionHandler;
import org.seasar.mayaa.impl.builder.library.scanner.SourceAlias;
import org.seasar.mayaa.impl.builder.library.scanner.WebXMLTaglibSourceScanner;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.XMLUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class MLDDefinitionBuilder
extends ParameterAwareImpl
implements DefinitionBuilder,
CONST_IMPL {
    private static final long serialVersionUID = -2992197676369912663L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$MLDDefinitionBuilder == null ? (class$org$seasar$mayaa$impl$builder$library$MLDDefinitionBuilder = MLDDefinitionBuilder.class$("org.seasar.mayaa.impl.builder.library.MLDDefinitionBuilder")) : class$org$seasar$mayaa$impl$builder$library$MLDDefinitionBuilder));
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$MLDDefinitionBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryDefinition build(SourceDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        String systemID = source.getSystemID();
        if (source.exists() && systemID.toLowerCase().endsWith(".mld")) {
            LibraryDefinitionHandler handler = new LibraryDefinitionHandler();
            InputStream stream = source.getInputStream();
            try {
                XMLUtil.parse(handler, stream, "-//The Seasar Foundation//DTD Mayaa Library Definition 1.0//EN", systemID, true, true, false);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("MLD parse error on " + systemID), t);
                }
                LibraryDefinition libraryDefinition = null;
                return libraryDefinition;
            }
            finally {
                IOUtil.close(stream);
            }
            LibraryDefinition library = handler.getLibraryDefinition();
            boolean assigned = ObjectUtil.booleanValue(source.getParameter(WebXMLTaglibSourceScanner.ASSIGNED), false);
            if (assigned) {
                URI assignedURI = SpecificationUtil.createURI(source.getParameter(SourceAlias.ALIAS));
                library.addAssignedURI(assignedURI);
            }
            return library;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

