/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.injection;

import org.seasar.mayaa.builder.injection.InjectionChain;
import org.seasar.mayaa.builder.injection.InjectionResolver;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;

public class RenderedSetter
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    private static final long serialVersionUID = 1350199548908128291L;
    protected static final QName QM_NULL = SpecificationUtil.createQName("null");
    protected static final QName QM_RENDERED = SpecificationUtil.createQName("rendered");

    protected boolean isRendered(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        NodeAttribute attr = node.getAttribute(QM_RENDERED);
        if (attr != null) {
            return ObjectUtil.booleanValue(attr.getValue(), true);
        }
        return true;
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        SpecificationNode injected = chain.getNode(original);
        if (injected == null) {
            return null;
        }
        if (!this.isRendered(original) || !this.isRendered(injected)) {
            return BuilderUtil.createInjectedNode(QM_NULL, null, original, false);
        }
        return injected;
    }
}

