/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.injection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.injection.InjectionChain;
import org.seasar.mayaa.builder.injection.InjectionResolver;
import org.seasar.mayaa.engine.specification.CopyToFilter;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.NodeObject;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class EqualsIDInjectionResolver
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    private static final long serialVersionUID = 3248707016394881768L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver == null ? (class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver = EqualsIDInjectionResolver.class$("org.seasar.mayaa.impl.builder.injection.EqualsIDInjectionResolver")) : class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver));
    private CopyToFilter _idFilter = new CheckIDCopyToFilter();
    private List _additionalIds = new ArrayList();
    private boolean _reportResolvedID = true;
    private boolean _reportDuplicatedID = true;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver;

    public EqualsIDInjectionResolver() {
        this._additionalIds.add(CONST_IMPL.QM_ID);
    }

    protected CopyToFilter getCopyToFilter() {
        return this._idFilter;
    }

    protected boolean isReportResolvedID() {
        return this._reportResolvedID;
    }

    protected boolean isReportDuplicatedID() {
        return this._reportDuplicatedID;
    }

    protected NodeAttribute getAttribute(SpecificationNode node) {
        Iterator it = this._additionalIds.iterator();
        while (it.hasNext()) {
            NodeAttribute attr = node.getAttribute((QName)it.next());
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    protected String getID(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        NodeAttribute attr = this.getAttribute(node);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    protected void getEqualsIDNodes(SpecificationNode node, String id, List specificationNodes) {
        if (node == null || StringUtil.isEmpty(id)) {
            throw new IllegalArgumentException();
        }
        Iterator it = node.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode child = (SpecificationNode)it.next();
            if (id.equals(SpecificationUtil.getAttributeValue(child, CONST_IMPL.QM_ID))) {
                specificationNodes.add(child);
            }
            this.getEqualsIDNodes(child, id, specificationNodes);
        }
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        String id = this.getID(original);
        if (StringUtil.hasValue(id)) {
            Specification spec = SpecificationUtil.findSpecification(original);
            PrefixAwareName injected = null;
            while (spec != null) {
                SpecificationNode mayaa = SpecificationUtil.getMayaaNode(spec);
                if (mayaa != null) {
                    ArrayList injectNodes = new ArrayList();
                    this.getEqualsIDNodes(mayaa, id, injectNodes);
                    if (injectNodes.size() > 0) {
                        injected = (SpecificationNode)injectNodes.get(0);
                        if (!this.isReportDuplicatedID() || injectNodes.size() <= 1) break;
                        this.logWarnning(id, original, 2);
                        break;
                    }
                }
                spec = EngineUtil.getParentSpecification(spec);
            }
            if (injected != null) {
                if (CONST_IMPL.QM_IGNORE.equals(injected.getQName())) {
                    return chain.getNode(original);
                }
                return injected.copyTo(this.getCopyToFilter());
            }
            if (this.isReportResolvedID()) {
                this.logWarnning(id, original, 1);
            }
        }
        return chain.getNode(original);
    }

    protected void logWarnning(String id, SpecificationNode node, int number) {
        if (LOG.isWarnEnabled()) {
            String systemID = node.getSystemID();
            String lineNumber = Integer.toString(node.getLineNumber());
            String msg = StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver == null ? (class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver = EqualsIDInjectionResolver.class$("org.seasar.mayaa.impl.builder.injection.EqualsIDInjectionResolver")) : class$org$seasar$mayaa$impl$builder$injection$EqualsIDInjectionResolver, number, id, systemID, lineNumber);
            LOG.warn((Object)msg);
        }
    }

    public void setParameter(String name, String value) {
        if ("reportUnresolvedID".equals(name)) {
            this._reportResolvedID = ObjectUtil.booleanValue(value, true);
        }
        if ("reportDuplicatedID".equals(name)) {
            this._reportDuplicatedID = ObjectUtil.booleanValue(value, true);
        }
        if ("addAttribute".equals(name)) {
            this._additionalIds.add(SpecificationUtil.parseQName(value));
        }
        super.setParameter(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CheckIDCopyToFilter
    implements CopyToFilter {
        protected CheckIDCopyToFilter() {
        }

        public boolean accept(NodeObject test) {
            if (test instanceof NodeAttribute) {
                NodeAttribute attr = (NodeAttribute)test;
                return !attr.getQName().equals(CONST_IMPL.QM_ID);
            }
            return true;
        }
    }
}

