/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.seasar.mayaa.PositionAware;
import org.seasar.mayaa.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.mayaa.impl.source.URLSourceDescriptor;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.LIFOIterator;
import org.seasar.mayaa.source.SourceDescriptor;

public class MarshallUtil {
    private MarshallUtil() {
    }

    protected static void setPosition(Object obj, String systemID, int lineNumber) {
        if (obj == null || StringUtil.isEmpty(systemID) || lineNumber < 0) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof PositionAware) {
            PositionAware positionAware = (PositionAware)obj;
            positionAware.setSystemID(systemID);
            positionAware.setLineNumber(lineNumber);
        }
    }

    public static Object marshall(Class instanceClass, Class interfaceClass, Object beforeObject, String systemID, int lineNumber) {
        Constructor constructor;
        if (instanceClass == null) {
            if (beforeObject == null) {
                throw new IllegalArgumentException();
            }
            return beforeObject;
        }
        if (beforeObject != null && (constructor = ObjectUtil.getConstructor(instanceClass, new Class[]{interfaceClass})) != null) {
            Object obj = ObjectUtil.newInstance(constructor, new Object[]{beforeObject});
            MarshallUtil.setPosition(obj, systemID, lineNumber);
            return obj;
        }
        Object obj = ObjectUtil.newInstance(instanceClass);
        MarshallUtil.setPosition(obj, systemID, lineNumber);
        return obj;
    }

    public static SourceDescriptor getDefaultSource(String systemID, Class neighborClass) {
        if (StringUtil.isEmpty(systemID) || neighborClass == null) {
            throw new IllegalArgumentException();
        }
        ClassLoaderSourceDescriptor defaultSource = new ClassLoaderSourceDescriptor();
        defaultSource.setSystemID(systemID);
        defaultSource.setNeighborClass(neighborClass);
        return defaultSource;
    }

    public static Iterator iterateMetaInfSources(String systemID) {
        if (StringUtil.isEmpty(systemID)) {
            throw new IllegalArgumentException();
        }
        if (!systemID.startsWith("META-INF/")) {
            systemID = "META-INF" + StringUtil.preparePath(systemID);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = loader.getResources(systemID);
            return new URLSourceIterator(new LIFOIterator(resources), systemID);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class URLSourceIterator
    implements Iterator {
        private Iterator _it;
        private String _systemID;

        public URLSourceIterator(Iterator it, String systemID) {
            if (it == null || StringUtil.isEmpty(systemID)) {
                throw new IllegalArgumentException();
            }
            LinkedHashSet<URL> urlSet = new LinkedHashSet<URL>();
            while (it.hasNext()) {
                URL next = (URL)it.next();
                urlSet.add(next);
            }
            this._it = urlSet.iterator();
            this._systemID = systemID;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            URL url = (URL)this._it.next();
            URLSourceDescriptor urlSource = new URLSourceDescriptor();
            urlSource.setURL(url);
            urlSource.setSystemID(this._systemID);
            return urlSource;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

