# todo.pl
# todo.n2command, done.n2command 共通ライブラリ

package todolib;

my $js = <<"END";
Ho.n2.todo = function() {
    var errmsg = "更新が衝突しました。リロードしてください。";
    var errmsg2 = "このページは凍結されています。";
    var setFormData = function() {
        if ((httpObj.readyState == 4) && (httpObj.status == 200)) {
            var lawdat = httpObj.responseText;
            var p = lawdat.split(",",2);
            if(p[0]) {
                Ho.n2.resetAllModDateElem(p[0],p[1]);
            }
            else {
                if(p[1]) {
                    alert(errmsg2);
                }
                else {
                    alert(errmsg);
                }
            }
        }
        document.body.style.cursor = "default";
    };
    return {
        check: function(n,m) {
            httpObj = Ho.js.createXMLHttpRequest(setFormData);
            var todoform = document.forms['todoform'+n];
            if(httpObj) {
                var modob = todoform.getElementsByTagName("span")[0];
                var postData = "plugin=todo&todo=" + m;
                var moddt = modob.getAttribute("value");
                var url = todoform.action;
                postData = postData + "&moddate=" + moddt;
                postData = postData + "&js=1";
                httpObj.open("POST",url,true);
                httpObj.setRequestHeader(
                    "content-type", "application/x-www-form-urlencoded"
                );
                httpObj.send(postData);
                document.body.style.cursor = "wait";
            }
            else {
                todoform.submit();
            }
        }
    };
}();
END
sub command_todo {
    my $s = shift;
    my $plugin = shift;
    my @args = $plugin->args(
        ['view','p','opt','prm','page','data','q','str','depth','vdpth' ],
        @_
    );
    my ($view,$p,$opt,$prm,$page,$db,$q,$str,$d,$v) = @args;
    my $bn = $db->basename($page);
    my $ud = $db->curr_userdir($page);
    my $url = $view->page_uri($page);
    my $data = $plugin->get_state('todo_command');
    my $anm = 1;
    my $rnm = 1;
    my $hlevel = 4;
    my $checkbox;
    my $botfn = $view->{botfnameref};
    my $botfv = $view->{botfvalueref};
    if($p) {
        if($data) {
            if($data->[2] eq $page) {
                $anm = $data->[0]+1;
                $rnm = $data->[1]+1;
            }
            else {
                $anm = $data->[0]+1;
                $rnm = 1;
            }
        }
        else {
            $p->($q->embeded_jslib());
            $p->($view->loadjslib());
            $p->($q->embed_javascript($js));
        }
        if($s) {
            $checkbox = $q->empty('input',
                                  onClick => "Ho.n2.todo.check($anm,$rnm)",
                                  type => 'checkbox', class => 'todo',
                                  checked => 'checked');
        }
        else {
            $checkbox = $q->empty('input', 
                                  onClick => "Ho.n2.todo.check($anm,$rnm)",
                                  type => 'checkbox', class => 'todo');
        }
        $plugin->set_state('todo_command',[$anm,$rnm,$page]);
        if($opt =~ /h([1-6])/) { $hlevel = $1; }
        $p->(
            $q->tag('form',
            $q->tag('span','',
                name => 'moddate', value => $db->editdate($page),
                href => $view->page_uri($page)).
            $q->empty('input',type=>'hidden',value=>'todo',name=>'plugin').
            $q->empty('input',type=>'hidden',value=>"$rnm",name=>'todo').
            $q->empty('input',
                type=>'hidden',value => $botfv, name => $botfn
            ).
            $q->empty('input',
                type=>'hidden',value => '1', name => 'botcheck'
            ).
            $q->tag('h'.$hlevel,
                $checkbox.
                $view->make_link(
                    $q->escape($prm),$db,$page,$v,$bn,$ud,$url
                )
            ),
            name => "todoform$anm", action => $url, method => 'POST')."\n"
        );
        return 1;
    }
    else {
        if($ENV{REQUEST_METHOD} ne 'POST') { return 1; }
        my @dt = split(/\n/,$db->get($page));
        my $fm = $q->param_post('todo');
        my $mod = $q->param_post('moddate');
        my $js = $q->param_post('js');
        my $i = 0;
        my @td = map { [$_, $i++] } @dt;
        @td = grep { $_->[0] =~ /^#\?(todo|done)/ } @td;
        my $line = $td[$fm-1]->[0];
        my $n = $td[$fm-1]->[1];
        if($line eq '') { return 1; }
        if($line =~ /^#\?todo/) {
            $dt[$n] =~ s/^#\?todo/#\?done/;
        }
        elsif($line =~ /^#\?done/) {
            $dt[$n] =~ s/^#\?done/#\?todo/;
        }
        my $touch = $db->is_frozen($page) ? 1 : 0 ;
        if($touch) {
            if($js) {
                print $q->nocache_header();
                print ",f";
                return 1;
            }
            else {
                $view->redirect_to($page);
                return 1;
            }
        }
        if(my $err = $db->set($page,join("\n",@dt),$mod)) {
            if($js) {
                print $q->nocache_header();
                print ",";
            }
            else {
                $view->dberror($err);
            }
        }
        else {
            if($js) {
                print $q->nocache_header();
                print $db->editdate($page).','.$view->page_uri($page);
            }
            else {
                $view->redirect_to($page);
            }
        }
        return 1;
    }
}

1;