# N2::View
# 2008/4/10 v0.1.2
# H.OHARA

package N2::View;
use strict;
use warnings;
use File::Basename;
use Ho::A;
use N2::Plugin;
use N2::Prefs;
use N2::Alias;
use N2::Theme;
use Carp;

my $use_encode = 0;
my $use_jcode = 0;

if($] >= 5.008001) {
    eval {require Encode;};
    $use_encode = 1 unless $@;
}
else {
    eval {require Jcode;};
    $use_jcode = 1 unless $@;
}

# View class
# constructor
sub new {
    my $class = shift;
    my $self = {
        path => '', # string
        scriptpath => '',
        title => '',
        query => undef, # Ho
        version => 'N2Wiki 0.2.2 (c) 2008 by Hiroyuki OHARA (No22)',
        tinyurl => 'http://tinyurl.com/create.php?url=',
        css => 'diki_style',
        sharedcss => 'n2base.css',
        usercss => 'n2user.css',
        theme => 'theme',
        themepage => '_theme',
        editmsg => 'Editing :: ',
        previewmsg => 'Preview :: ',
        edit => 0,
        maxdepth => 32,
        termmsg => '<p>[Termination :: Too deeply nested]</p>',
        aliasdepth => 32,
        inlinealiasdepth => 32,
        plugin => undef, # N2::Plugin
        alias => undef, # N2::Alias
        prefs => undef, # N2::Prefs
        themes => undef, # N2::Theme
        inlinealias => undef, # N2::Alias
        prefname => '_preferences',
        rssplugin => 'rss',
        rssfile => 'rss.rdf',
        rssdesclen => 100,
        rssitemlim => 15,
        spamplugin => 'spam',
        timezone => '+09:00',
        sandbox => '/SandBox',
        keyword => '/Keyword',
        delayedindexing => 10,
        delayedexlink => 48,
        touchmsg => 'タイムスタンプを更新しない',
        aanchor => '☆',
        uanchor => '↑',
        entryclose => '〆',
        entryup => '∧',
        entrydown => '∨',
        cookie => 0,
        cookieuser => '',
        delcookie => 0,
        botfname => 'す',
        botfvalue => 'パ',
        botfnameref => '&#12377;',
        botfvalueref => '&#12497;',
        botprob => 0,
        passcode => 0,
        passcodemsg => '壱壱弐参を半角数字で',
        passcode0 => '1123',
        passcode1 => '42',
        passcode2 => '4649',
        passcode3 => '4081',
        newreflog => 'newreferrer.bak',
        newrefrdf => 'referrer.rdf',
        user => '',
        errpage => {
            name   => '/_error/page_name_too_long',
            char   => '/_error/invalid_char',
            cnfl   => '/_error/conflict',
            plugin => '/_error/plugin_not_found'
        },
        mtbl => [
            [0, '/_pwdchange'],
            [1, '/_editpage'],
            [1, '/_pwdcheck'],
            [0, '/_pwdcheck'],
            [0, '/_usercheck'],
            [1, '/_pwdcheck'],
            [1, '/_usercheck'],
            [7, '/_diff']
        ],
        autobackup => 1,
        backupdelay => 30,
        firefoxwbr => 1,
        session_expire => 60,
        recent_deleted => '/_RecentDeleted',
        _preview_data => '',
        _dberr => [ '', 'name', 'cnfl' ],
        _dirpath => '',
        _prefkeys => [
            'title','tinyurl','css','editmsg','maxdepth',
            'termmsg','aliasdepth','sharedcss','previewmsg',
            'rssplugin','rssfile','rssdesclen','rssitemlim',
            'timezone','sandbox','delayedindexing','touchmsg',
            'inlinealiasdepth','keyword','delayedexlink',
            'aanchor','uanchor','entryclose','entryup','entrydown',
            'spamplugin','botfname','botfvalue','botfnameref',
            'botfvalueref','newreflog','newrefrdf','autobackup',
            'backupdelay','passcode','passcode0','passcode1',
            'passcode2','passcode3','passcodemsg','firefoxwbr',
            'session_expire','recent_deleted'
        ],
        @_
    };
    if($self->{path}) {
        $self->{_dirpath} = File::Basename::dirname($self->{path});
    }
    return bless $self, $class;
}

sub page_uri {
    my $self = shift;
    my ($page) = @_;
    my $uri = Ho::A->encode_path_infou($page);
    return $self->{path}.$uri;
}

sub body_incl {
    my $self = shift;
    my ($page,$db,$src,$depth,$vdpth,$result) = @_;
    my @lines = split(/\n/,$db->get($src));
    $self->render_lines($page,\@lines,$db,$depth,$vdpth,$result);
}

sub wikilink {
    my $self = shift;
    my ($str,$page,$db,$v) = @_;
    my $q = $self->{query};
    my $bn = File::Basename::basename($page);
    my $ud = $db->curr_userdir($page);
    my $pl = $self->page_uri($page);
    return $self->make_link($q->escape($str),
        $db,$page,$v,$bn,$ud,$pl
    );
}

sub edit_form {
    my $self = shift;
    my ($page,$db,$o,$v) = @_;
    my $q = $self->{query};
    my $mod = $db->editdate($page);
    $mod = $mod ? $mod : 0 ;
    $o = defined($o) ? $o : '' ;
    my $touch = '';
    my $botfn = $self->{botfnameref};
    my $botfv = $self->{botfvalueref};
    my $prvbtn = '';
    
    if($o =~ /t/) {
        my %atrb = (
            type => 'checkbox', name => 'touch', value => '1'
        );
        if($db->is_frozen($page)) {
            $atrb{checked} = 'checked';
        }
        $touch = $q->br().$q->empty('input', %atrb).
            $q->tag('span',$self->{touchmsg}, class => 'edit');
    }
    if($o =~ /p/) {
        $prvbtn = $q->empty('input',type => 'submit',
            name => 'preview', value => 'preview',
            class=>'edit'
        );
    }
    my $token;
    if($db->is_frozen($page)) {
        $token = $q->empty('input',
            type=>'hidden',value => $q->pwdcrypt($self->{passcode2}),
            name => 'botcheck'
        );
    }
    else {
        if($self->{passcode}) {
            my $str = $self->wikilink($self->{passcodemsg},$page,$db,$v);
            $token = $q->br(). $q->tag('span',"$str ", class => 'edit').
                $q->empty('input',
                    type=>'text',value => '', name => 'botcheck'
                );
        }
        else {
            $token = $q->empty('input',
                type=>'hidden',value => $q->pwdcrypt($self->{passcode1}),
                name => 'botcheck'
            );
        }
    }
    return $q->tag('form',
        $q->tag_start('textarea',
            cols=>'80',rows=>'20',name=>'n2e',class=>'edit',wrap=>'virtual'
        ).
        $q->escape(
            $self->{_preview_data} ? $self->{_preview_data} : $db->get($page)
        ).
        $q->tag_end('textarea').$q->br().$prvbtn.
        $q->empty('input',type => 'submit',
            name => 'post', value => 'post',
            class=>'edit'
        ).
        $q->empty('input',
            type=>'hidden',value => $mod, name => 'moddate'
        ).
        $q->empty('input',
            type=>'hidden',value => $botfv, name => $botfn
        ).
        $touch.$token,
        action => $self->page_uri($page).'?e', 
        method => 'POST',
        class => 'edit'
    );
}

sub replace_spvars {
    my $self = shift;
    my ($s,$page,$db,$bn,$ud,$pl) = @_;
    $s =~ s/\$fulltitle/$page/go;
    $s =~ s/\$title/$bn/go;
    $s =~ s/\$user/$ud/go;
    $s =~ s/\$ANC/$self->{aanchor}/ego;
    $s =~ s/\$UPS/$self->{uanchor}/ego;
    $s =~ s/\$CLS/$self->{entryclose}/ego;
    $s =~ s/\$EUP/$self->{entryup}/ego;
    $s =~ s/\$EDW/$self->{entrydown}/ego;
    $s =~ s/\$LTTL/$page/go;
    $s =~ s/\$TITL/$bn/go;
    $s =~ s/\$USER/$ud/go;
    $s =~ s/\$PLNK/$pl/ego;
    return $s;
} 

sub rex {
    my $self = shift;
    my ($r,$o,$page,$db,$bn,$ud,$e) = @_;
    my $rex = $r ? $r : '.*';
    $rex = $self->replace_spvars($rex,$page,$db,$bn,$ud,$e);
    if($o =~ /k/) {
        my @key = split(/ /,$rex);
        @key = grep { $_ ne '' } @key;
        $rex = '';
        if(@key > 1) {
            foreach my $i (@key) {
                $rex .= "(?=.*?$i)";
            }
        }
        else {
            $rex = $key[0];
        }
    }
    return $rex;
}

sub regex {
    my $self = shift;
    my ($r,$o,$page,$db) = @_;
    my $basename = File::Basename::basename($page);
    my $userdir = $db->curr_userdir($page);
    my $plink = $self->page_uri($page);
    return $self->rex($r,$o,$page,$db,$basename,$userdir,$plink);
}

sub insert_wbr {
    my $self = shift;
    my ($s,$q) = @_;
    if($self->{firefoxwbr}) {
        my $wbr = $q->empty('wbr');
        $s =~ s|([/_:;%=?+])|$1$wbr|go;
    }
    return $s;
}

sub eachpage {
    my $self = shift;
    my ($o,$cond,$page,$db,$q,$p,$vdpth,$b,$u,$e) = @_;
    my $isBaseName = 0;
    my $hf = ($o =~ /[hH]/);
    my $htf = ($o =~ /H/);
    my ($hlns) = ($o =~ /[hH](\d*)/);
    $hlns = $hlns ? $hlns : 0 ;
    my ($df) = ($o =~ /M(\d*)/);
    $df = $df ? $df : 0 ;
    my $mf = ($o =~ /m/);
    my $uf = ($o =~ /U/);
    my $of = ($o =~ /O/);
    my $ltag = $of ? 'ol' : 'ul' ;
    my $ox = '';
    my $lox = 0;
    my $curdir = '/';
    my @oxs;
    my $omd = '';
    
    if($o =~ /[de]/) {
        $curdir = $page;
    }
    elsif($o =~ /u/) {
        $curdir = $self->curr_userdir($page);
    }
    $curdir = $db->resname($curdir,'');
    push(@oxs,$curdir);
    
    if($o =~ /b/) {
        if($o =~ /d/) { $isBaseName = 1; }
        else { $isBaseName = 2; }
    }
    my $proc = sub {
        my $x = shift;
        my $y = $x;
        my $mod = '';
        if($mf||$df) {
            $mod = $q->curr_date_str($db->moddate($x)).' ';
            my @datestr = split(/,/,$mod);
            $mod = $df ? $datestr[0] : $mod ;
        }
        if($isBaseName) {
            if($isBaseName == 1) { 
                substr($y,0,length($page)+1) = '';
            }
            else { $y = File::Basename::basename($y); }
        }
        if($of||$uf) {
            if($ox && length($x) > $lox && $ox eq substr($x,0,$lox)) {
                $p->($q->tag_start($ltag));
                $y = substr($x,$lox);
                push(@oxs,$ox);
            }
            else {
                if($ox) {
                    my $od = 0;
                    $p->($q->tag_end('li'));
                    while($ox ne substr($x,0,$lox)) {
                        $ox = pop(@oxs);
                        $lox = length($ox);
                        $od++;
                    }
                    $y = substr($x,$lox);
                    while(--$od) { 
                        $p->($q->tag_end($ltag));
                        $p->($q->tag_end('li'));
                    }
                    push(@oxs,$ox);
                }
            }
            $ox = $db->resname($x,'');
            $lox = length($ox);
        }
        if($df) {
            if($omd ne $mod) {
                if($omd) {
                    $p->($q->tag_end($ltag));
                }
                $p->($q->tag('p',$q->tag('strong',$mod)));
                $p->($q->tag_start($ltag));
                $omd = $mod;
            }
            $mod = '';
        }
        if(($uf||$of)&&($y=~m|^[0-9]{2}_(.*)|)) {
            $y = defined($1) ? $1 : '' ;
        }
        if($hf) {
            my @dat = split(/\n/,$db->get($x));
            @dat = @dat[0..$hlns];
            my $titl = shift(@dat);
            my $head = join("\n",@dat);
            $head =~ s/^#\??(\w+)(\s+(-[\w\d]+))?\s*//mg;
            $titl =~ s/^#\??(\w+)(\s+(-[\w\d]+))?\s*//mg;
            my $bn = $db->basename($x);
            my $ud = $db->curr_userdir($x);
            my $pl = $self->page_uri($x);
            $head = 
                $self->make_link($q->escape($head),$db,$x,$vdpth,$bn,$ud,$pl);
            $head =~ s/\n/$q->br()/mego;
            if($htf) {
                $head = $q->br().$head;
            }
            else {
                $titl = 
                    $self->make_link($q->escape($titl),$db,$x,$vdpth,$bn,$ud,$pl);
                if($head ne '' || $titl ne '') {
                    $head = ' - '.$titl.$q->br().$head;
                }
                else {
                    $head = '';
                }
            }
            if($of||$uf) {
                $p->($q->tag_start('li'));
                $p->($mod.
                    $q->tag('a',
                        ($htf && $titl ne '') 
                        ? $titl : $self->insert_wbr($q->escape($y),$q),
                        href => $self->page_uri($x)
                    ).$head."\n"
                );
            }
            else {
                $p->($q->tag('li',
                        $mod.
                        $q->tag('a',
                            ($htf && $titl ne '') 
                            ? $titl : $self->insert_wbr($q->escape($y),$q),
                            href => $self->page_uri($x)
                        ).$head."\n"
                     )
                );
            }
        }
        else {
            if($of||$uf) {
                $p->($q->tag_start('li'));
                $p->($mod.
                     $q->tag('a',$self->insert_wbr($q->escape($y),$q),
                                 href => $self->page_uri($x))."\n");
            }
            else {
                $p->($q->tag('li',
                     $mod.
                     $q->tag('a',$self->insert_wbr($q->escape($y),$q),
                                 href => $self->page_uri($x)))."\n");
            }
        }
    };
    if(!$df) { $p->($q->tag_start($ltag)); }
    $db->filter_and_each($o,$page,$cond,$proc);
    if($omd) {
        $p->($q->tag_end($ltag));
    }
    if($ox) {
        $p->($q->tag_end('li'));
        $ox = pop(@oxs);
        if($ox eq '/'){
            $p->($q->tag_end($ltag));
            $p->($q->tag_end('li'));
        }
        else {
            while($ox ne $curdir) {
                $ox = pop(@oxs);
                $p->($q->tag_end($ltag));
                $p->($q->tag_end('li'));
            }
        }
    }
    if(!$df) { $p->($q->tag_end($ltag)); }
}

sub render_lines {
    my $self = shift;
    my ($page,$lines,$db,$depth,$vdpth,$result) = @_;
    my $q = $self->{query};
    my $in_pre = 0;
    my $apre = 1;
    my $plugin = $self->{plugin};
    my $alias = $self->{alias};
    my $maxadpth = $self->{aliasdepth};
    my $basename = File::Basename::basename($page);
    my $userdir = $db->curr_userdir($page);
    my $plink = $self->page_uri($page);
    $userdir = $userdir eq '/' ? '' : $userdir ;
    my @stack;
    my $id = 0;
    my $st = 0;
    my @rowspan;
    my @rowstyle;
    my @tablestyle;
    my $tcount;
    
    my $out = sub {
        my $s = shift;
        push(@$result,$s);
    };
    my $pop = sub {
        my $i = pop(@stack);
        while($i--) {
            $out->($q->tag_end(pop(@stack))."\n");
        }
    };
    my $p = sub {
        my $s = shift;
        if($in_pre) {
            if($apre) {
                $out->($q->tag_end('pre'));
            }
            else {
                $out->($q->tag_end('p')."\n");
            }
            $in_pre = 0;
        }
        elsif($id) {
            while(@stack) { $pop->(); }
            $id = 0;
            $st = 0;
        }
        $out->($s);
    };    
    
    if($depth >= $self->{maxdepth}) { 
        $p->($self->{termmsg});
        return; 
    }
    
    my $push = sub {
        my ($t,$at) = @_;
        $p->("\n".$q->tag_start($t,defined($at) ? %$at : ()));
        push(@stack,$t);
        push(@stack,1);
    };

    my $add = sub {
        my ($t,$at) = @_;
        $p->("\n".$q->tag_start($t,defined($at) ? %$at : ()));
        my $n = pop(@stack);
        push(@stack,$t);
        push(@stack,$n+1);
    };

    my $inline = sub {
        my ($t) = @_;
        return $self->make_link($q->escape($t),
            $db,$page,$vdpth,$basename,$userdir,$plink
        );
    };

    my $rex = sub {
        my ($r,$o) = @_;
        return $self->rex($r,$o,$page,$db,$basename,$userdir,$plink);
    };

    my $eachpage = sub {
        my ($o,$cond) = @_;
        $self->eachpage(
            $o,$cond,$page,$db,$q,$p,$vdpth,$basename,$userdir,$plink
        );
    };

    while(@$lines) {
        my $str = shift(@$lines);
        my $adpth = 0;
        my $state;
        my $cm;
        my $m1;
        my $m2;
        my $m3;
        my $m4;
        my $s1;
        my $s2;
        my $s4;
        my $o;
        my $r;
        
        my $prep = sub {
            ($cm,$m1,$m2,$m3,$m4) = 
                $str =~ /^#(\??\w+)(\s+(-[\w\d]+))?(\s+(\S.*))?/;
            $cm = defined($cm) ? $cm : '' ;
            $o = defined($m2) ? $m2 : '' ;
            $m4 = defined($m4) ? $m4 : '' ;
            $s1 = substr($str,0,1);
            $s2 = substr($str,0,2);
            return 0;
        };
        
        my $blc = sub {
            my ($bgn,$end,$idn,$prc) = @_;
            if($str ne $bgn && $id != $idn) { return 0; }
            if($str eq $end) { 
                $p->('');
                return 1; 
            }
            $id = $id == $idn ? 0 : $id ;
            $p->('');
            $prc->();
            $id = $idn;
            return 1;
        };

        my $spre = sub {
            return $blc->('|>','<|',5,sub {
                if($st) {
                    $p->($q->escape($str)."\n");
                }
                else {
                    $push->('pre');
                    $st = 1;
                }
            });
        };

        my $bquo = sub {
            return $blc->('>>','<<',4,sub {
                if($st) {
                    if($str eq '') {
                        $pop->();
                        $push->('p');
                    }
                    else {
                        $p->($inline->($str).$q->br());
                    }
                }
                else {
                    $push->('blockquote');
                    $push->('p');
                    $st = 1;
                }
            });
        };

        my $cmt = sub {
            if($s2 ne '%%') { return 0; }
            return 1;
        };

        my $hr = sub {
            if(substr($str,0,4) ne '----') { return 0; }
            $p->($q->empty('hr'));
            return 1;
        };
        
        my $heading = sub {
            if($str !~ /^(\*{1,6})(.*)/) { return 0; }
            my $len = length($1);
            $p->($q->tag('h'.$len,$inline->($2)));
            return 1;
        };
        
        my $parb = sub {
            if($str ne '|<') { return 0; }
            $p->('');
            $apre = 0;
            return 1;
        };
        
        my $pare = sub {
            if($str ne '>|') { return 0; }
            $p->('');
            $apre = 1;
            return 1;
        };
                
        my $lst = sub {
            if($str !~ /^([-+]{1,3})(.*)/) { return 0; }
            my $tag = $s1 eq '-' ? 'ul' : 'ol' ;
            my $newid = $s1 eq '-' ? 1 : 2 ;
            my $len = length($1);
            $id = ($id == 1 || $id == 2) && ($len != $st || $id == $newid) ? 0 : $id ;
            $p->('');
            if($st) {
                if($len <= $st) {
                    my $c = $len;
                    while($c++ <= $st) { $pop->(); }
                }
                else {
                    $add->($tag);
                    my $c = $len - $st - 1;
                    while($c--) { $push->($tag); }
                }
            }
            else {
                my $c = $len;
                while($c--) { $push->($tag); }
            }
            $push->('li');
            $p->($inline->($2));
            $id = $newid;
            $st = $len;
            return 1;
        };
        
        my $tble = sub {
            if($s1 ne '|' && $cm ne 'table') { return 0; }
            if($id == 3) { $id = 0; } else { $p->(''); }
            my %atrb;
            my $t_init = sub {
                $push->('table',\%atrb);
                @rowspan = ();
                @rowstyle = ();
                @tablestyle = ();
                $tcount = 0;
            };
            if($cm eq 'table') {
                %atrb = $q->str_to_atrb($m4);
                $st = (index($o,'i') != -1) ? 2 : 1 ;
                $t_init->();
                $id = 3;
                return 1;
            }
            elsif($st == 0) {
                $st = 1;
                $t_init->();
            }
            my $slen = length($str);
            my $dlm = $slen > 1 ? substr($s2,1) : undef ;
            my $dat = $slen > 1 ? substr($str,2) : undef ;
            if(!defined($dlm) || !defined($dat)) { return 0; }
            if($dlm eq 't') {
                $dat =~ s/^\s*//;
                $p->($q->tag('caption',$inline->($dat)));
                $id = 3;
                return 1;
            }
            elsif($dlm eq 'g') {
                foreach my $x (split(/\|/,$dat)) {
                    $p->($q->tag('colgroup','',$q->str_to_atrb($x)));
                }
                $id = 3;
                return 1;
            }
            elsif($dlm eq 'r' || $dlm eq 'c') {
                my $tmp;
                if($dlm eq 'r') {
                    @rowstyle = ();
                    $tmp = \@rowstyle;
                } 
                else { 
                    @tablestyle = (); 
                    $tmp = \@tablestyle;
                }
                if($dat) {
                    foreach my $x (split(/\|/,$dat)) {
                        my %at = $q->str_to_atrb($x);
                        push(@$tmp,\%at);
                    }
                }
                if($dlm eq 'r') { $tcount = 0; }
                $id = 3;
                return 1;
            }
            $dat = "$dat$dlm";
            my @value = $dat =~ /((?:[*0-9^<]*)?"[^"]*(?:""[^"]*)*"|[^$dlm]*)\Q$dlm\E/g; #"
            my @ctrl = map { (s/^((<\d+<|<+)?(\^\d+\^|\^+)?\*?)//) ? $1 : '' } @value;
            my @align = map { 
                (s/^\s+//) ? ((s/\s+$//) ? 'center' : 'right') : ((s/\s+$//) ? 'left' : '') 
            } @value;
            @value = map { /^"(.*)"$/ ? scalar($_ = $1, s/""/"/g, $_) : $_ } @value; #"
            my @cols = map { 
                (/<(\d+)</) ? ($1 == 0 ? -1 : $1) : ((/(<+)/) ? length($1) : 0)
            } @ctrl;
            my @rows = map { 
                (/\^(\d+)\^/) ? ($1 == 0 ? -1 : $1) : ((/(\^+)/) ? length($1) : 0)
            } @ctrl;
            $p->("\n".$q->tag_start('tr',
                    $rowstyle[$tcount] ? %{$rowstyle[$tcount]} : ()
                )
            );
            $tcount++;
            if($tcount >= @rowstyle) { $tcount = 0; }
            my $i = 0;
            my $td;
            my $colspan = 0;
            my $max = @value;
            foreach my $x (@value) {
                my %atrb = $tablestyle[$i] ? %{$tablestyle[$i]} : () ;
                if($rowspan[$i]) { 
                    if($rowspan[$i] > 0) { $rowspan[$i]--; }
                    $i++;
                    next;
                }
                $td = index($ctrl[$i],'*') != -1 ? 'th' : 'td';
                if($st == 1 && $align[$i]) { $atrb{align} = $align[$i]; }
                if($rows[$i]) {
                    $rowspan[$i] = $rows[$i];
                    $atrb{rowspan} = $rows[$i]+1;
                }
                if($cols[$i]) {
                    $rowspan[$i] = $rowspan[$i] ? $rowspan[$i] : 0 ;
                    my $lim = $cols[$i] > 0 ? $cols[$i] : $max - $i ;
                    my $col = $rowspan[$i] >= 0 ? $rowspan[$i]+1 : -1 ;
                    for(my $j = 1; $j <= $lim; $j++) {
                        $rowspan[$i+$j] = $col;
                    }
                    $atrb{colspan} = $cols[$i]+1;
                }
                $p->("\n".$q->tag($td,$inline->($x),%atrb));
                $i++;
            }
            $p->("\n".$q->tag_end('tr'));
            $id = 3;
            return 1;
        };

        my $edit = sub {
            if($cm ne 'edit') { return 0; }
            $p->($self->edit_form($page,$db,$o,$vdpth));
            return 1;
        };
        
        my $ls = sub {
            if($cm ne 'ls') { return 0; }
            $r = $rex->($m4,$o);
            my $cond = sub {
                my $x = shift;
                return ($x =~ /$r/);
            };
            $eachpage->($o,$cond);
            return 1;
        };
        
        my $grp = sub {
            if($cm ne 'grep') { return 0; }
            $r = $rex->($m4,$o);
            my $cond = sub {
                my ($x) = @_;
                my $data = $db->get($x);
                return ($data =~ /$r/s);
            };
            $eachpage->($o,$cond);
            return 1;
        };
        
        my $cat = sub {
            if($cm ne 'cat') { return 0; }
            my $isQmode = ($o =~ /q/);
            my $isImode = ($o =~ /i/);
            my $cond;
            my $proc;
            if($vdpth != 0 && $o =~ /v/) { return 1; }
            $r = $rex->($m4,$o);
            if($o =~ /g/) {
                $cond = sub {
                    my ($x) = @_;
                    my $data = $db->get($x);
                    return ($data =~ /$r/s);
                };
            }
            else {
                $cond = sub {
                    my ($x) = @_;
                    return ($x =~ /$r/);
                };
            }
            $proc = sub {
                my $x = shift;
                if(!$isQmode) { $p->(''); }
                if($isImode) {
                    $self->body_incl($page,$db,$x,$depth+1,$vdpth,$result);
                }
                else {
                    $self->body_incl($x,$db,$x,$depth+1,$vdpth+1,$result);
                }
            };
            $db->filter_and_each($o,$page,$cond,$proc);
            return 1;
        };
        
        my $cmd = sub {
            if(substr($cm,0,1) ne '?') { return 0; }
            $plugin = defined($plugin) ? 
                $plugin : ($self->{plugin} = new N2::Plugin);
            my $command = $plugin->command(substr($cm,1));
            if(!$command) { return 0; }
            return $command->($self,$p,$o,$m4,$page,
                $db,$q,\$str,$depth,$vdpth,\$apre,$lines,$result
            );
        };
        
        my $ali = sub {
            if($cm eq '') { return 0; }
            $alias = defined($alias) ? $alias :
                ($self->{alias}=N2::Alias->new(db=>$db,user=>$userdir));
            my $command = $alias->command($cm);
            if(!$command) { return 1; }
            my $prm = $o ? $o.' '.$m4 : $m4 ;
            $command =~ s/\$1/$prm/go;
            $str = $command;
            $adpth++;
            return 2;
        };
        
        my $pre = sub {
            if($apre == 0 && $str eq '') {
                if($in_pre) { $p->(''); }
                return 1;
            }
            if($in_pre == 0) {
                if($apre) {
                    $p->($q->tag_start('pre'));
                }
                else {
                    $p->($q->tag_start('p')."\n");
                }
                $in_pre = 1;
            }
            $str = $inline->($str);
            if($apre) {
                $out->("$str\n");
            }
            else {
                $out->($str.$q->br()."\n");
            }
            return 1;
        };
        
        while(
            ( $state = 
                ( 
                    $prep->() || $spre->() || $cmt->() || $bquo->() ||
                    $heading->() || $hr->() || $parb->() || $pare->() ||
                    $lst->() || $tble->() || $edit->() || $ls->() ||
                    $cat->() || $grp->() || $cmd->() || $ali->() ||
                    $pre->()
                )
            )  == 2 and $adpth < $maxadpth 
        ) { }
        
        if($state == 3) { last; }
        
    }
    
    $p->('');
    
    if($depth == 0 && defined($plugin)){
        my $c = $plugin->get_state('div_command');
        if(defined($c)) {
            while($c > 0) {
                $p->($q->tag_end('div'));
                $c--;
            }
            $plugin->set_state('div_command',0);
        }
    }
    
}

sub make_link {
    my $self = shift;
    my ($s,$d,$p,$v,$b,$u,$e) = @_;
    if($s =~ /(.*?)\[\](.*?)\[\](.*)/) {
        my $left = $1;
        my $middle = $2;
        my $right = $3;
        $middle = $middle ? $middle : '[]';
        return
            $self->make_link($left,$d,$p,$v,$b,$u,$e).
            $middle.
            $self->make_link($right,$d,$p,$v,$b,$u,$e);
    }
    $s = $self->resolve_inlinealias($s,$d,$p,0,$b,$u,$e);
    $s =~ s/\[\[([^\|]*?)(\|(.+?))?\]\]/$self->gen_link($1,$3,$d,$p,$v,$b,$u,$e)/ego;
    $s =~ s/(&amp;(\[.+\])+)/$self->gen_keyword($2,$d,$p,0)/ego;
    $s =~ s/(~(\[.+\])+)/$self->gen_keyword($2,$d,$p,1)/ego;
    $s =~ s/\[#(.+)\]/$self->gen_anchor($1,$d,$p)/ego;
    return $s;
}

sub gen_anchor {
    my $self = shift;
    my ($anc,$db,$pg) = @_;
    my $q = $self->{query};
    return $q->tag('a', '', name => $anc);
}

sub gen_keyword {
    my $self = shift;
    my ($tag,$db,$pg,$f) = @_;
    my $q = $self->{query};
    my @tags = split(/\]/,$tag);
    @tags = map { substr($_,1) } grep { $_ ne '' } @tags;
    my $tags = '';
    my $kwpg = $self->{keyword};
    my $url;
    foreach my $i (@tags) {
        if($f) {
            $url = $self->page_uri($db->pagename("~$kwpg/$i",$pg));
        }
        else {
            $url = $self->page_uri("$kwpg/$i");
        }
        $tags .= $q->tag('a', "[$i]", href => $url, class => 'keyword');
    }
    return $tags;
}

sub resolve_inlinealias {
    my $self = shift;
    my ($s,$d,$p,$i,$b,$u,$e) = @_;
    if($self->{inlinealiasdepth} < $i) {
        return $s;
    }
    $s =~ s/\&#123;\&#123;(\S+?)(\s+(.+?))?\}\}/$self->gen_ialias($1,$3,$d,$p,$i,$b,$u,$e)/ego;
    return $s;
}

sub encode_uri_with_spvars {
    my $self = shift;
    my ($str,$pg,$db,$bn,$ud,$e) = @_;
    return Ho::A->encode_uriu(
        $self->replace_spvars($str,$pg,$db,$bn,$ud,$e)
    );
}

sub encode_to {
    my $self = shift;
    my ($enc,$str,$pg,$db,$bn,$ud,$e) = @_;
    my %et = ( euc => 'euc-jp', sjis => 'shiftjis');
    return $self->encode_uri_with_spvars(
        Encode::encode($et{$enc},Encode::decode('utf-8',$str)),$pg,$db,$bn,$ud,$e
    );
}

sub jcode_to {
    my $self = shift;
    my ($enc,$str,$pg,$db,$bn,$ud,$e) = @_;
    return $self->encode_uri_with_spvars(
        Jcode::convert($str,$enc,'utf8'),$pg,$db,$bn,$ud,$e
    );
}

sub gen_ialias {
    my $self = shift;
    my ($name,$prm,$db,$pg,$i,$bn,$ud,$e) = @_;
    $name = defined($name) ? $name : '';
    $prm  = defined($prm)  ? $prm  : '';
    my $q = $self->{query};
    my $alias = $self->{inlinealias};
    if(!defined($alias)) {
        $alias = N2::Alias->new(
            db => $db, user => $ud,
            page => '_inlinealias'
        );
        $self->{inlinealias} = $alias;
    }
    my $s = $self->{query}->escape($alias->get($name));
    $s =~ s/\butf8\(\$1\)/$self->encode_uri_with_spvars($prm,$pg,$db,$bn,$ud,$e)/ego;
    if($use_encode) {
        $s =~ s/\b(euc|sjis)\(\$1\)/$self->encode_to($1,$prm,$pg,$db,$bn,$ud,$e)/ego;
    }
    elsif($use_jcode) {
        $s =~ s/\b(euc|sjis)\(\$1\)/$self->jcode_to($1,$prm,$pg,$db,$bn,$ud,$e)/ego;
    }
    $s = $self->replace_spvars($s,$pg,$db,$bn,$ud,$e);
    $s =~ s/\$1/$prm/go;
    return $self->resolve_inlinealias($s,$pg,$db,$i+1,$bn,$ud,$e);
}

sub gen_link {
    my $self = shift;
    my ($name,$url,$db,$pg,$vdp,$bn,$ud,$elnk) = @_;
    $name = defined($name) ? $name : '';
    my $oname = $name;
    $url  = defined($url)  ? $url  : '';
    my $q = $self->{query};
    my $plugin = $self->{plugin};
    my $noname = $url ? 0 : 1 ;
    my $inline = '';
    
    if($name =~ /^(.+\.(jpg|jpeg|gif|png))(,([0-9%]*)(,([0-9%]*))?)?$/) {
        my $n = $1;
        my $w = $4;
        my $h = $6;
        if($name !~ /^(http|https|ftp):\/\//) { 
            $n = $db->resuri($self->{_dirpath},$db->pagename($n,$pg));
        }
        $url = $url ? $url : $n;
        my %atrb = ( src => $n, alt => '' );
        if(defined($w)) { $atrb{width}  = $w; }
        if(defined($h)) { $atrb{height} = $h; }
        $name = $q->empty('img', %atrb);
    }
    elsif($name =~ /^img:(.+)$/) {
        my $n = $1;
        if($n !~ /^(http|https|ftp):\/\//) { 
            $n = $db->resuri($self->{_dirpath},$db->pagename($n,$pg));
        }
        $url = $url ? $url : $n;
        my %atrb = ( src => $n, alt => '' );
        $name = $q->empty('img', %atrb);
    }
    else {
        $url = $url ? $url : $name;
    }
    if($noname) {
        $name =~ s|^\.\./([^/])|$1|;
        $name =~ s|^\./([^/])|$1|;
        $name =~ s|^~/([^/])|$1|;
    }
    $name = $self->replace_spvars($name,$pg,$db,$bn,$ud,$elnk);
    $url = $self->replace_spvars($url,$pg,$db,$bn,$ud,$elnk);
        
    my ($cmd,$d0,$id,$cl,$d1,$ttl) = $url =~ /^([^|]*)(\|(id:)?([\w-]*)(\|(.*))?)?$/;
    $id = defined($id) ? $id : '' ;
    $cl = defined($cl) ? $cl : '' ;
    $ttl = defined($ttl) ? $ttl : '' ;
    if($cl or $ttl) {
        my %atrb;
        if($id eq '' && $cl ne '')  { $atrb{class} = $cl;  }
        if($id ne '' && $cl ne '')  { $atrb{id} = $cl;  }
        if($ttl ne '') { $atrb{title} = $ttl; }
        $name = $q->tag('span',$name,%atrb);
    }
    if($cmd eq 'EDIT') {
        return $q->tag('a', $name, 
            href => $elnk.'?e', rel => 'nofollow'
        );
    }
    elsif($cmd eq 'ANCH') {
        return $q->tag('a', $name, href => $self->page_uri($pg));
    }
    elsif($cmd eq 'OPEN') {
        if($vdp == 0) {
            return $q->tag('a', $name, 
                href => $elnk.'?e', rel => 'nofollow'
            );
        }
        else {
            return $q->tag('a', $name, href => $elnk);
        }
    }
    elsif($cmd eq 'UPST') {
        my $dir = File::Basename::dirname($pg);
        return $q->tag('a', $name, href => $self->page_uri($dir));
    }
    elsif($cmd eq 'TITL') {
        if($name eq 'full' || $name eq 'LONG') { return $pg; }
        else {
            return $bn;
        }
    }
    elsif($cmd eq 'TURL') {
        return $q->tag('a', $name, href => $self->{tinyurl}.$elnk);
    }
    elsif($cmd =~ /^((http|https|ftp):\/\/)/) {
        if(!$db->is_frozen($pg) || $cmd =~ /\?plugin=/ || $cmd =~ /\?e$/ ||
            $db->filemod($pg) < $self->{delayedexlink}/24) {
            return $q->tag('a', $name, href => $cmd, rel => 'nofollow');
        }
        else {
            return $q->tag('a', $name, href => $cmd);
        }
    }
    elsif($cmd =~ /^wiki:(.*)/) {
        my ($pgname,$qstr) = $1 =~ /^(.*)([?#].+)$/;
        $pgname = $pgname ? $pgname : $pg ;
        $qstr = $qstr ? $qstr : '' ;
        my $lnk = $self->page_uri($db->pagename($pgname,$pg)).$qstr;
        if(!$db->is_frozen($pg) || $cmd =~ /\?plugin=/ || $cmd =~ /\?e$/ ||
            $db->filemod($pg) < $self->{delayedexlink}/24) {
            return $q->tag('a', $name, href => $lnk, rel => 'nofollow');
        }
        else {
            return $q->tag('a', $name, href => $lnk);
        }
    }
    elsif($cmd =~ /^\?(\w+)(\s+(.*))?$/) {
        $plugin = defined($plugin)?$plugin:($self->{plugin}=new N2::Plugin);
        $inline = $plugin->inline($1);
        my $prm = defined($3) ? $3 : '';
        if($inline) {
            if($noname) { $name = ''; }
            return 
                $inline->($self,$oname,$name,$prm,$pg,$db,$q,$vdp,0,$cl,$ttl);
        }
        else {
            my $errpage = $db->as_pagename($self->{errpage}->{'plugin'});
            my $erruri = $self->page_uri($errpage);
            return $q->tag('a', $name, href => $erruri);
        }
    }
    else {
        my ($pgname,$anc) = $cmd =~ /^(.*)(#.*)$/;
        if($anc) {
            $pgname = $pgname ? $pgname : $pg ;
            $url = $self->page_uri($db->pagename($pgname,$pg)).$anc;
        }
        else {
            $url = $self->page_uri($db->pagename($cmd,$pg));
        }
        return $q->tag('a', $name, href => $url);
    }
}

# public methods
sub read_prefs {
    my $self = shift;
    my ($db) = @_;
    if(!defined($self->{prefs}) && $db->exists_page($self->{prefname})) {
        $self->{prefs} = N2::Prefs->new(
            page => $self->{prefname}, db => $db
        );
        $self->{prefs}->read_settings($self,$self->{_prefkeys});
    }
}

sub read_theme {
    my $self = shift;
    my ($db,$page) = @_;
    if(!defined($self->{themes}) && $db->exists_page($self->{themepage})) {
        $self->{themes} = N2::Theme->new(
            path => $self->{theme},
            page => $self->{themepage},
            db => $db
        );
    }
    return defined($self->{themes}) ? $self->{themes}->theme_path($page): '';
}

sub user_css {
    my $self = shift;
    my ($page) = @_;
    if(defined($self->{themes})) {
        my $path = $self->{themes}->curr_theme($page);
        $path .= "/$self->{usercss}";
        $path = $self->{theme}.'/'.$path;
        if(-f $path) { return $path; }
    }
    return '';
}

sub render {
    my $self = shift;
    my ($page,$db,$edit,$data) = @_;
    
#    my $t_start = (times)[0];
    
    my $q = $self->{query};
    my $body_renderer;  
    my $tpath = '';
    my $css_path = $self->{_dirpath}.'/'.$self->{theme}.'/';
    my $shared_css = $css_path.$self->{sharedcss};
    my $shared_user_css = $self->{theme}.'/'.$self->{usercss};
    my $cookie;
    my @result;
    $edit = defined($edit) ? $edit : 0 ;
    my $title = 
        $page eq '/' ? $self->{title} : $self->{title}.$q->escape($page) ;
    
    if($page =~ /[|]/) {
        $self->error('char');
        return;
    }
    
    if($edit > 1 && $edit < 7 && defined(($cookie = $q->cookie('n2wiki')))) {
        if($db->is_membersid($q->cookie('n2user'),$page,$cookie)) {
            $edit = $edit > 2 ? 0 : 1 ;
        }
    }

    my $rootpwd = $db->get_userpwd('/');
    if(!defined($rootpwd) || $rootpwd eq '') {
        $self->{edit} = $edit;
        $body_renderer = sub {
            $self->body_incl($page,$db,$self->{mtbl}->[0]->[1],0,0,\@result);
            print foreach @result;
        };
    }
    elsif($edit) {
        if($db->longpagename($page)) {
            $self->error('name');
            return;
        }
        if($edit <= 2) {
            $title = $self->{editmsg}.$q->escape($page);
        }
        if($edit == 8) {
            $title = $self->{previewmsg}.$q->escape($page);
            $self->{edit} = 1;
            $body_renderer = sub {
                my @lines = split(/\n/,$data);
                $self->render_lines($page,\@lines,$db,0,0,\@result);
                $self->body_incl($page,$db,'/_editpreview',0,0,\@result);
                print foreach @result;
            };
        }
        else {
            $self->{edit} = $self->{mtbl}->[$edit]->[0];
            $body_renderer = sub { 
                $self->body_incl($page,$db,$self->{mtbl}->[$edit]->[1],0,0,\@result); 
                print foreach @result;
            };
        }
    }
    else {
        $self->{edit} = 0;
        $body_renderer = sub { 
            $self->body_incl($page,$db,$page,0,0,\@result); 
            print foreach @result;
        };
    }
    $title = $title eq '' ? $self->{path} : $title ;
    $q->set(-title => $title);
    $tpath = $self->read_theme($db,$page);
    $css_path .= $tpath ? $tpath : $self->{css}.'/'.$self->{css}.'.css' ;
    my $user_css_path = $self->user_css($page);
    my @n2css = ($shared_css, $css_path);
    if($user_css_path) {
        push(@n2css,$self->{_dirpath}.'/'.$self->{theme}.'/'.$user_css_path);
    }
    if(-f $shared_user_css) { push(@n2css,$self->{_dirpath}.'/'.$shared_user_css); }
    $q->header(-style_type => 'text/css');
    $q->header(-extrn_css => \@n2css); 
    $q->header(-script_type => 'text/javascript');
    $q->header(-generator => $self->{version});
    if($db->res_exists('/favicon.ico')) {
        $q->header(-favicon => $db->resuri($self->{_dirpath},'/favicon.ico'));
    }
    if($edit || $page eq $self->{sandbox} || $page =~ m|^/_| ||
        $db->filemod($page) < $self->{delayedindexing}/24 ) {
        $q->header(-robots => 'NOINDEX, NOFOLLOW');
        $q->header(-googlebot => 'NOINDEX, NOFOLLOW');
    }
    if($self->{cookie}) {
        my $cookie1 = $q->make_cookie(
            -name => 'n2wiki', -value => $self->{cookie},
            -path => $self->{scriptpath}.'/'
        );
        my $cookie2 = $q->make_cookie(
            -name => 'n2user', -value => $self->{cookieuser},
            -path => $self->{scriptpath}.'/'
        );
        
        $q->{-cachereset} = 0;
        $q->cookie_set('n2wiki',$self->{cookie});
        $q->cookie_set('n2user',$self->{cookieuser});
        
        $self->{cookie} = 0;
        $self->{cookieuser} = '';
        $q->set(-cookie => [$cookie1,$cookie2]);
    }
    if($self->{rssplugin}) {
        my $rsspath = $self->page_uri($page);
        if($page eq '/') {
            $rsspath .= $self->{rssfile};
        }
        else {
            $rsspath .= '/'.$self->{rssfile};
        }
        $q->header(-rss => $rsspath);
    }
    $q->print(-body => $body_renderer);
    
#    my $t_end = (times)[0];
#    my $t_intv = $t_end - $t_start;
#    warn "Time: $t_intv\n";
}

sub redirect {
    my $self = shift;
    my ($uri) = @_;
    if($self->{delcookie}) {
        print Ho::A->cookie_header($self->{delcookie});
    }
    print "Status: 303 See Other\n";
    print "Location: $uri\n\n";
}

sub redirect_to {
    my $self = shift;
    my ($page,$anchor) = @_;
    my $uri = $self->page_uri($page).(defined($anchor) ? $anchor : '');
    $self->redirect($uri);
}

sub plugin {
    my $self = shift;
    my ($page,$db,$cmd) = @_;
    my $q = $self->{query};
    my $plugin = defined($self->{plugin}) ? 
        $self->{plugin} : ($self->{plugin} = new N2::Plugin);
    $cmd = Ho::A->check_filename($cmd,'\w+');
    my $inline = $plugin->inline($cmd);
    if($inline) {
        return $inline->($self,'','','',$page,$db,$q,'',1);
    }
    my $command = $plugin->command($cmd);
    if($command) {
        return $command->($self,'','','',$page,$db,$q);
    }
    if($cmd eq $self->{rssplugin}) {
        print "Status: 404 Not Found\n";
        print "Content-Type: text/plain; charset=UTF-8\n\n";
        print "The requested URI not found on this server.\n";
    }
    else {
        $self->error('plugin');
    }
    return;
}

sub spam_check {
    my $self = shift;
    my ($page,$db) = @_;
    if($self->{spamplugin}) {
        return $self->plugin($page,$db,$self->{spamplugin});
    }
}

sub error {
    my $self = shift;
    my ($err) = @_;
    my $errpg  = $self->{errpage}->{$err};
    if($errpg) {
        $self->redirect_to($errpg);
    }
    else {
        $self->redirect_to('/_error');
    }
}

sub dberror {
    my $self = shift;
    my ($err) = @_;
    my $errkey  = $self->{_dberr}->[$err];
    $self->error($errkey);
}

sub setup_js {
    my $self = shift;
    if($self->{_jslib}) { return ''; }
    $self->{_jslib} = 1;
    return $self->{query}->setup_js().qq(Ho.n2 = { version: "0.1.0" };\n);
}

sub loadjslib {
    my $self = shift;
    if($self->{_jsloaded}) { return ''; }
    $self->{_jsloaded} = 1;
    my $js = <<"END";
Ho.n2.resetAllModDateElem = function() {
    return function(newmd,url) {
        var a = document.getElementsByName('moddate');
        var n = a.length;
        if(n == 0) {
            a = document.getElementsByTagName('span');
            n = a.length;
        }
        for (var i = 0; i < n; i++) {
            if(a[i].getAttribute("href") == url) {
                a[i].setAttribute("value", newmd);
            }
        }
    };
}();
END
    return $self->{query}->embed_javascript($self->setup_js().$js);
}

sub check_referer {
    my $self = shift;
    return ($ENV{HTTP_REFERER} =~ m|^\Q$self->{path}\E|);
}

sub check_cookie {
    my $self = shift;
    my ($page,$db) = @_;
    my $q = $self->{query};
    my $sid = $q->cookie('n2wiki');
    my $user = $q->cookie('n2user');
    return defined($sid) && $db->is_membersid($user,$page,$sid);
}

sub spambot {
    my $self = shift;
    print "Status: 404 Not Found\n";
    print "Content-Type: text/plain; charset=UTF-8\n\n";
    print "The requested URI not found on this server.\n";
    return;
}

sub is_spambot {
    my $self = shift;
    my $q = $self->{query};
    my $botf = $q->param_post($self->{botfname});
    $botf = defined($botf) ? $botf : '' ;
    return $botf ne $self->{botfvalue};
}

sub botcheck {
    my $self = shift;
    my ($pg,$db,$e) = @_;
    my $q = $self->{query};
    my $ck = $q->param_post('botcheck');
    $ck = defined($ck) ? $ck : '' ;
    if($db->is_frozen($pg)) {
        return $ck ne crypt($self->{passcode2},$ck);
    }
    else {
        if($e) {
            return $ck ne $self->{passcode0};
        }
        else {
            return $ck ne crypt($self->{passcode1},$ck);
        }
    }
}

sub change_passcode {
    my $self = shift;
    my ($f) = @_;
    my $q = $self->{query};
    $self->{prefs}->set('passcode3',$q->genkey(8));
    if($f) {
        $self->{prefs}->set('passcode2',$q->genkey(8));
    }
    else {
        $self->{prefs}->set('passcode1',$q->genkey(8));
    }
}

1;

