# N2::Theme
# 2008/5/5 v0.1
# H.OHARA

# Theme class
package N2::Theme;
use strict;
use warnings;

# inherites from N2::PathPrefs
use N2::PathPrefs;
use base qw( N2::PathPrefs );
our $VERSION = 0.1;

# constructor
sub new {
    my $class = shift;
    my $self = {
        path => 'theme',
        page => '_theme', # string
        db => undef, # N2::Data
        rex => '^(\/.*)\s+=\s+([\w-]+)\s*$', #'
        proc => undef,
        _prefs => [ ],
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

# public methods
sub theme_setting {
    my $self = shift;
    my ($page) = @_;
    return $self->get_pref($page);
}

sub curr_theme {
    my $self = shift;
    my ($page) = @_;
    return $self->get($page);
}

sub theme_path {
    my $self = shift;
    my ($page) = @_;
    my $n = $self->curr_theme($page);
    if($n) {
        return $n.'/'.$n.'.css';
    }
    return $n;
}

sub each {
    my $self = shift;
    my ($options) = @_;
    my @themes;
    my $dir = $self->{path};
    $options = defined($options) ? $options : "" ;

    opendir(DIR,$dir);
    @themes = grep {-d "$dir/$_"} readdir(DIR);
    closedir(DIR);

    @themes = grep {/^[\w-]+$/} @themes;

    if($options =~ /[MAC]/) {
        if($options =~ /M/) {
            @themes = map  { [$_, -M "$dir/$_"] } @themes;
        }
        elsif($options =~ /A/) {
            @themes = map  { [$_, -A "$dir/$_"] } @themes;
        }
        elsif($options =~ /C/) {
            @themes = map  { [$_, -C "$dir/$_"] } @themes;
        }
        @themes = map  { $_->[0] }
                 sort { $a->[1] <=> $b->[1] } @themes;
    }
    else {
        @themes = sort {$a cmp $b} @themes;
    }
    if($options =~ /r/) {
        @themes = reverse(@themes);
    }
    return @themes;
}

1;
