# N2::Prefs
# 2008/4/13 v0.1
# H.OHARA

# Preference class
package N2::Prefs;
use strict;
use warnings;
use Ho::A;

# constructor
sub new {
    my $class = shift;
    my $self = {
        page => '/_preferences', # string
        db => undef, # N2::Data
        rex => '^([^# ]\S*)\s*=\s*(.*)?\s*$', #'
        proc => undef,
        _prefs => { },
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

# private methods
sub prefs {
    my $self = shift;
    return $self->{_prefs};
}

sub set_prefs {
    my $self = shift;
    my ($new) = @_;
    $self->{_prefs} = $new;
}

sub init {
    my $self = shift;
    if(!$self->{proc}) {
        $self->{proc} = sub {
            my ($a) = @_;
            if($a =~ /$self->{rex}/) {
                $self->{_prefs}->{$1}  = $2;
            }
        };
    }
    my $proc = $self->{proc};
    my @lines = split(/\n/,$self->{db}->get($self->{page}));
    foreach my $a (@lines) { $proc->($a); }
}

# public methods
sub get {
    my $self = shift;
    my ($key,$default) = @_;
    my $value = $self->{_prefs}->{$key};
    return defined($value) ? $value : $default ;
}

sub read_settings {
    my $self = shift;
    my ($obj,$wlst) = @_;
    foreach my $key (@$wlst) {
        my $value = $self->{_prefs}->{$key};
        if($value) {
            $obj->{$key} = $value;
        }
    }
}

sub set {
    my $self = shift;
    my ($key, $value) = @_;
    my @lines = split(/\n/,$self->{db}->get($self->{page}));
    my $md = $self->{db}->editdate($self->{page});
    my $len = @lines;
    my $oldvalue = $self->get($key);
    for(my $i = 0 ; $i < $len ; $i++ ) {
        if($lines[$i] =~ /^\Q$key\E\s*=\s*(.*)?\s*$/) {
            if($oldvalue ne $1) { return 0; }
            $self->{_prefs}->{$key} = $value;
            $lines[$i] = $key.'='.$value;
            return $self->{db}->set($self->{page},join("\n",@lines),$md,1);
        }
    }
    # key not found
    push(@lines, $key.'='.$value);
    return $self->{db}->set($self->{page},join("\n",@lines),$md,1);
}

1;
