# simple Html Object A
# 2008/4/6 v0.2
# H.OHARA

# abstract class 
package Ho::A;
use strict;
use warnings;
use Carp;
our $VERSION = 0.2;

# no constructer

# setter
sub set {
    my $self = shift;
    my %param = @_;
    while(my ($key,$value) = each(%param)) {
        $self->{$key} = $value;
    }
    return $self;
}

sub header {
    my $self = shift;
    my %param = @_;
    while(my ($key,$value) = each(%param)) {
        $self->{-header}->{$key} = $value;
    }
    return $self;
}

# abstract methods
# sub print { }

# public instance methods

sub start_html {
    my $self = shift;
    return (
        $self->cookie_header($self->{-cookie}),
        $self->http_header($self->{-charset}),
        $self->doctype(),
        $self->html_start(),
        $self->prepare_header(),
        $self->body_start()
    );
}

sub end_html {
    my $self = shift;
    return ( 
        $self->body_end(),
        $self->html_end()
    );
}

# private mathods

sub cookie_header {
    my $self = shift;
    my ($cookies) = @_;
    if(!defined($cookies)) { return ''; }
    if(ref($cookies) eq 'ARRAY') {
        return join('',map { "Set-Cookie: $_\n" } @$cookies);
    }
    else {
        return "Set-Cookie: $cookies\n";
    }
}

sub http_header {
    my $self = shift;
    my ($charset) = @_;
    return "Content-type: text/html; charset=$charset\n\n";
}

sub doctype {
    my $self = shift;
    my $id = $self->{-pubid};
    if($self->{-sysid} ne '') {
        $id .= qq("\n ").$self->{-sysid};
    }
    my $doctype = qq(<!DOCTYPE HTML PUBLIC "$id">\n);
    return $doctype;
}

sub html_start {
    my $self = shift;
    my %attr = (
        lang => $self->{-lang},
        @_
    );
    return $self->tag_start('html',%attr)."\n";
}

sub html_end {
    my $self = shift;
    return $self->tag_end('html')."\n";
}

# public utility instance/class methods
sub nocache_header {
    my $self = shift;
    my ($charset) = $self->{-charset};
    return "Content-type: text/html; charset=$charset\n".
           "Pragma: no-cache\n".
           "Cache-Control: no-cache\n".
           "Expires: Thu, 01 Dec 1994 16:00:00 GMT\n\n";
}

sub setup_js {
    my $self = shift;
    if($self->{_jslib}) { return ''; }
    $self->{_jslib} = 1;
    return qq(var Ho = { version: "0.1.0" };\n);
}

sub embeded_jslib {
    my $self = shift;
    if($self->{_jsloaded}) { return ''; }
    $self->{_jsloaded} = 1;
    my $js = <<"END";
Ho.js = function() {
  return {
    version: "0.1.0",
    createXMLHttpRequest: function (cbFunc) {
      var XMLhttpObject = null;
      try {
        XMLhttpObject = new XMLHttpRequest();
      }
      catch(e) {
        try {
          XMLhttpObject = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch(e) {
          try {
            XMLhttpObject = new ActiveXObject("Microsoft.XMLHTTP");
          }
          catch(e) {
            return null;
          }
        }
      }
      if (XMLhttpObject) XMLhttpObject.onreadystatechange = cbFunc;
      return XMLhttpObject;
    }
  };
}();
END
    return $self->embed_javascript($self->setup_js().$js);
}

sub tag_start {
    my $self = shift;
    my ($tagname,%attr) = @_;
    my $output = "<$tagname";
    my $nl = $self->{nl} ? $self->{nl} : '' ;
    while(my ($key,$value) = each(%attr)) {
        $output .= qq( $key="$value") if $key;
    }
    $output .= ">$nl";
    return $output;
}

sub tag_end {
    my $self = shift;
    my ($tagname) = @_;
    my $nl = $self->{nl} ? $self->{nl} : '' ;
    return "</$tagname>$nl";
}

sub tag {
    my $self = shift;
    my ($tagname,$content,%attr) = @_;
    my $output = $self->tag_start($tagname,%attr);
    $output .= $content;
    $output .= $self->tag_end($tagname);
    return $output;
}

sub empty {
    my $self = shift;
    my ($tagname,%attr) = @_;
    my $nl = $self->{nl} ? $self->{nl} : '' ;
    my $output = "<$tagname";
    while(my ($key,$value) = each(%attr)) {
        $output .= qq( $key="$value") if $key;
    }
    $output .= ">$nl";
    return $output;
}

sub body_start {
    my $self = shift;
    my %attr = @_;
    return $self->tag_start('body',%attr)."\n";
}

sub body_end {
    my $self = shift;
    return $self->tag_end('body')."\n";
}

sub head {
    my $self = shift;
    my ($content,%attr) = @_;
    return $self->tag('head',$content,%attr);
}

sub meta {
    my $self = shift;
    my (%attr) = @_;
    return $self->empty('meta',%attr)."\n";
}

sub Link {
    my $self = shift;
    my (%attr) = @_;
    return $self->empty('link',%attr)."\n";
}

sub script {
    my $self = shift;
    my ($content,%attr) = @_;
    return $self->tag('script',$content,%attr);
}

sub style {
    my $self = shift;
    my ($content,%attr) = @_;
    return $self->tag('style',$content,%attr);
}
sub title {
    my $self = shift;
    my ($content,%attr) = @_;
    return $self->tag('title',$content,%attr)."\n";
}

sub extrn_javascript {
    my $self = shift;
    my ($js) = @_;
    return $self->script('',
        language=>'JavaScript',type=>"text/javascript",src=>$js);
}

sub embed_javascript {
    my $self = shift;
    my ($content) = @_;
    $content = "<!--\n".$content."\n// -->\n";
    return $self->script($content,type=>'text/javascript');
}

sub embed_css {
    my $self = shift;
    my ($content) = @_;
    $content = "<!--\n".$content."\n-->\n";
    return $self->style($content,type=>'text/css');
}

sub http_equiv {
    my $self = shift;
    my ($type,$content) = @_;
    return $self->meta('http-equiv' => $type, content => $content);
}

sub rellink {
    my $self = shift;
    my ($rel,$href,$type) = @_;
    return $self->Link(rel => $rel, href => $href, type => $type);
}

sub linkcss {
    my $self = shift;
    my ($href) = @_;
    return $self->rellink('stylesheet',$href,'text/css');
}

sub linkrss {
    my $self = shift;
    my ($href) = @_;
    return $self->Link(
        rel => 'alternate',
        title => 'RSS',
        href => $href, 
        type => 'application/rss+xml'
    );
}

sub br {
    my $self = shift;
    my (%attr) = @_;
    return $self->empty('br',%attr);
}

## form access

sub get_data {
    my $self = shift;
    my $data;
    if($ENV{REQUEST_METHOD} eq 'GET') {
        $data = $ENV{QUERY_STRING};
    }
    return $data || '';
}

sub post_data {
    my $self = shift;
    my $data;
    if($ENV{REQUEST_METHOD} eq 'POST') {
        read(STDIN,$data,$ENV{CONTENT_LENGTH});
    }
    return $data || '';
}

sub form_data {
    my $self = shift;
    my $data;
    if($ENV{REQUEST_METHOD} eq 'GET') {
        $data = $ENV{QUERY_STRING};
    }
    elsif($ENV{REQUEST_METHOD} eq 'POST') {
        read(STDIN,$data,$ENV{CONTENT_LENGTH});
    }
    return $data;
}

sub split_form_data {
    my $self = shift;
    my ($data) = @_;
    my %form;
    foreach my $item (split(/&/,$data)) {
        my ($key,$value) = split(/=/,$item);
        if(!defined($form{"$key"})) {
            $form{"$key"} = $value;
        }
        else {
            my $ary = $form{"$key"};
            if(ref($ary) eq 'ARRAY') {
                push(@$ary,$value);
            }
            else {
                $form{"$key"} = [$ary, $value];
            }
        }
    }
    return %form;
}

sub decode_uri {
    my $self = shift;
    my ($uri) = @_;
    $uri =~ tr/+/ /;
    $uri =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2",$1)/ego;
    return $uri;
}

sub encode_uri {
    my $self = shift;
    my ($uri) = @_;
    $uri =~ s/(\W)/'%' . unpack('H2', $1)/ego;
    return $uri;
}

sub encode_uriu {
    my $self = shift;
    my ($uri) = @_;
    $uri =~ s/(\W)/'%' . uc(unpack('H2', $1))/ego;
    return $uri;
}

sub encode_path_info {
    my $self = shift;
    my ($uri) = @_;
    $uri =~ s/([^0-9A-Za-z_\/])/'%' . unpack('H2', $1)/ego;
    return $uri;
}

sub encode_path_infou {
    my $self = shift;
    my ($uri) = @_;
    $uri =~ s/([^0-9A-Za-z_\/])/'%' . uc(unpack('H2', $1))/ego;
    return $uri;
}

sub decode_form {
    my $self = shift;
    my %form = @_;
    my %decoded_form;
    while(my ($key,$value) = each(%form)) {
        $key = $self->decode_uri($key);
        if(ref($value) eq 'ARRAY') {
            my @newvalue = map { $self->decode_uri($_) } @$value;
            $decoded_form{"$key"} = \@newvalue;
        }
        else {
            $decoded_form{"$key"} = 
                defined($value) ? $self->decode_uri($value) : '' ;
        }
    }
    return %decoded_form;
}

sub encode_form {
    my $self = shift;
    my %form = @_;
    my %encoded_form;
    while(my ($key,$value) = each(%form)) {
        $key = $self->encode_uri($key);
        if(ref($value) eq 'ARRAY') {
            my @newvalue = map { $self->encode_uri($_) } @$value;
            $encoded_form{"$key"} = \@newvalue;
        }
        else {
            $encoded_form{"$key"} = $self->encode_uri($value);
        }
    }
    return %encoded_form;
}

sub decoded_form_data {
    my $self = shift;
    return $self->decode_form($self->split_form_data($self->form_data()));
}

sub decoded_get_data {
    my $self = shift;
    return $self->decode_form($self->split_form_data($self->get_data()));
}

sub decoded_post_data {
    my $self = shift;
    return $self->decode_form($self->split_form_data($self->post_data()));
}

sub param_cache {
    my $self = shift;
    my ($key,$cachekey,$proc) = @_;
    my %form;
    my $form_data;
    
    if(defined($self->{$cachekey})) {
        $form_data = $self->{$cachekey};
        %form = %$form_data;
    }
    else {
        %form = $proc->();
        $self->{$cachekey} = \%form;
    }
    if($key) {
        return $form{$key};
    }
    else {
        return %form;
    }
}

sub param {
    my $self = shift;
    my ($key) = @_;
    return $self->param_cache(
                $key,'_REQUEST',sub{$self->decoded_form_data();});
}

sub param_get {
    my $self = shift;
    my ($key) = @_;
    return $self->param_cache(
                $key,'_GET',sub{$self->decoded_get_data();});
}

sub param_post {
    my $self = shift;
    my ($key) = @_;
    return $self->param_cache(
                $key,'_POST',sub{$self->decoded_post_data();});
}

sub reset_param_cache {
    my $self = shift;
    my ($cachekey) = @_;
    if(defined($cachekey)) {
        $self->{$cachekey} = undef;
    }
    else {
        $self->{_REQUEST} = undef;
        $self->{_GET} = undef;
        $self->{_POST} = undef;
        $self->{_UPLOAD} = undef;
        $self->{_UPLOAD_INFO} = undef;
        $self->{_COOKIE} = undef;
    }
}

sub make_tempdir {
    my $self = shift;
    my $tmpd = './tmp';
    $self->make_dir($tmpd,0777);
    return $tmpd;
}

sub make_tempfname {
    my $self = shift;
    my $fname = $self->pwdcrypt(time());
    $fname =~ tr|/.|-_|;
    return $fname;
}

sub make_upload_temp {
    my $self = shift;
    my $tmpd = $self->make_tempdir();
    my $tmpfn = "$tmpd/up_".$self->make_tempfname().'.bak';
    my $bufsize = $self->{-buffersize};
    my $buffer;
    open(TH," > $tmpfn") || die $!;
    binmode(TH);
    while(read(STDIN,$buffer,$bufsize)) {
        print TH $buffer;
    }
    close(TH);
    return $tmpfn;
}

sub remove_upload_temp {
    my $self = shift;
    my ($ary) = @_;
    if($ary && $ary->[0]) {
        unlink($ary->[0]);
    }
}

sub fileindex {
    my $self = shift;
    my ($fh,$str) = @_;
    my $bufsize = 1024;
    my $buffer;
    my $buf0 = '';
    my $buf1;
    while($bufsize < length($str)) {
        $bufsize += 1024;
    }
    my $tpos = tell($fh);
    my $cpos0 = $tpos;
    my $len = read($fh,$buf0,$bufsize);
    my $cpos1 = tell($fh);
    $len = read($fh,$buf1,$bufsize);
    $buffer = $buf0.$buf1;
    my $ofs;
    while(($ofs = index($buffer,$str)) == -1) {
        $buf0 = $buf1;
        $cpos0 = $cpos1;
        $cpos1 = tell($fh);
        $len = read($fh,$buf1,$bufsize);
        if(!$len) { last; }
        $buffer = $buf0.$buf1;
    }
    seek $fh, $tpos, 0;
    if($len) {
        return $cpos0 - $tpos + $ofs;
    }
    else {
        return -1;
    }
}

sub read_upload_tmp {
    my $self = shift;
    my ($ary,$len) = @_;
    my $data;
    open(FH,$ary->[0]) || die $!;
    binmode(FH);
    seek(FH, $ary->[1], 0);
    read(FH, $data, (defined($len) ? $len : $ary->[2]));
    close(FH);
    return $data;
}

sub extract_upload_file {
    my $self = shift;
    my ($src,$dst) = @_;
    my $data;
    my $bufsize = $self->{-buffersize};
    my $buffer;
    my $size = $src->[2];
    open(DST," > $dst") || die $!;
    binmode(DST);
    open(SRC,$src->[0]) || die $!;
    binmode(SRC);
    seek(SRC, $src->[1], 0);
    while($size > 0) {
        $size -= read(SRC,$buffer,($bufsize > $size ? $size : $bufsize));
        print DST $buffer;
    }
    close(SRC);
    close(DST);
}

sub read_upload_data {
    my $self = shift;
    my $data;
    my $bndry;
    my $blen;
    my $bpos;
    my $cpos;
    my $dpos;
    my $res;
    my $head;
    my $body;
    my %uploadinfo;
    my %upload;
    binmode(STDIN);
    if(defined($self->{-postmax}) && $ENV{CONTENT_LENGTH}>$self->{-postmax}) {
        die "Request entity too large";
    }
    ($bndry) = $ENV{CONTENT_TYPE} =~ /boundary="([^"]+)"/; #"
    ($bndry) = $ENV{CONTENT_TYPE} =~ /boundary=(\S+)/ unless $bndry;
    $bndry = '--'.$bndry;
    $blen = length($bndry);
    my $tmpfn = $self->make_upload_temp();
    
    open(FH,$tmpfn) || die $!;
    binmode(FH);
    $bpos = $self->fileindex(*FH,$bndry);
    seek(FH, $bpos + $blen + 2, 1);
    while(1) {
        $cpos = $self->fileindex(*FH,"\x0D\x0A\x0D\x0A");
        if($cpos == -1) { last; }
        read(FH, $head, $cpos);
        $res .= $head."\n";
        seek(FH, 4, 1);
        $dpos = tell(FH);
        $bpos = $self->fileindex(*FH,$bndry);
        if($bpos == -1) { last; }
        my %dc;
        foreach my $ln (split("\x0D\x0A",$head)) {
            if($ln =~ /^Content-Disposition:(.*)/i) {
                my @atrb = split(";",$1);
                foreach my $item (@atrb) {
                    if($item =~ /\s*(\S+)\s*=\s*"([^"]*)"/) { #"
                        $dc{$1} = $2;
                    }
                }
            }
            elsif($ln =~ /^Content-Type:\s*(\S+)/i) {
                $dc{Content_Type} = $1;
            }
        }
        if(defined($dc{name})) {
            $uploadinfo{$dc{name}} = \%dc;
            if(defined($dc{Content_Type})) {
                seek(FH, $bpos-2, 1);
                $upload{$dc{name}} = [$tmpfn,$dpos,$bpos-2];
            }
            else {
                read(FH, $body, $bpos-2);
                $upload{$dc{name}} = $body;
            }
        }
        seek(FH, $blen + 2, 1);
        read(FH, $data, 2);
        if($data eq '--') { last; }
    }
    close(FH);
    return (\%upload, \%uploadinfo);
}

sub upload_cache {
    my $self = shift;
    my ($cachekey,$key) = @_;
    my $upload;
    my $uploadinfo;
    if(!defined($self->{_UPLOAD})) {
        ($upload, $uploadinfo) = $self->read_upload_data();
        $self->{_UPLOAD} = $upload;
        $self->{_UPLOAD_INFO} = $uploadinfo;
    }
    if(defined($cachekey)) {
        if(defined($key)) {
            return $self->{$cachekey}->{$key};
        }
        else {
            return $self->{$cachekey};
        }
    }
}

sub upload {
    my $self = shift;
    my ($key) = @_;
    return $self->upload_cache('_UPLOAD',$key);
}

sub uploadinfo {
    my $self = shift;
    my ($key) = @_;
    return $self->upload_cache('_UPLOAD_INFO',$key);
}

sub read_stream_data {
    my $self = shift;
    my ($proc) = @_;
    my $data;
    binmode(STDIN);
    if(defined($self->{-postmax}) && $ENV{CONTENT_LENGTH}>$self->{-postmax}) {
        die "Request entity too large";
    }
    my $sz = read(STDIN,$data,$ENV{CONTENT_LENGTH});
    if(!defined($sz)) { die "Read error"; }
    my $atrb = $proc ? $proc->($data) : { DATA => $data } ;
    return $atrb;
}

sub stream {
    my $self = shift;
    my ($key,$proc) = @_;
    if(!defined($self->{_STREAM})) {
        my $stream = $self->read_stream_data($proc);
        $self->{_STREAM} = $stream;
    }
    if(defined($key)) {
        return $self->{_STREAM}->{$key};
    }
    else {
        return $self->{_STREAM};
    }
}

sub make_cookie {
    my $self = shift;
    my (%attr) = @_;
    my $cookie = $self->encode_uri($attr{-name});
    $cookie .= '='.$self->encode_uri($attr{-value}).';';
    if(defined($attr{-expires})) {
        if($attr{-expires} ne 'del') {
            my $delta = substr($attr{-expires},0,-1);
            my $unit = substr($attr{-expires},-1,1);
            my %units = (
                s => 1, m => 60, h => 3600, d => 86400
            );
            my $gmt = $delta * $units{$unit} + time;
            $cookie .= ' expires='.$self->gmt_date_str($gmt).';';
        }
        else {
            $cookie .= ' expires=Thu, 01-Jan-1970 00:00:00 GMT;';
        }
    }
    if(defined($attr{-domain})) {
        $cookie .= ' domain='.$attr{-domain}.';';
    }
    if(defined($attr{-path})) {
        $cookie .= ' path='.$attr{-path}.';';
    }
    if(defined($attr{-secure})) {
        $cookie .= ' secure;';
    }
    return $cookie;
}

sub cookie_data {
    my $self = shift;
    my $data = $ENV{HTTP_COOKIE};
    my %cookies = ( );
    if(!defined($data)) { return %cookies; }
    foreach my $c (split(';',$data)) {
        my ($key,$value) = split(/=/,$c);
        $key = substr($key,0,1) eq ' ' ? substr($key,1) : $key ;
        $key = $self->decode_uri($key);
        $value = $self->decode_uri($value);
        if(!defined($cookies{"$key"})) {
            $cookies{"$key"} = $value;
        }
        else {
            my $ary = $cookies{"$key"};
            if(ref($ary) eq 'ARRAY') {
                push(@$ary,$value);
            }
            else {
                $cookies{"$key"} = [$ary, $value];
            }
        }
    }
    return %cookies;
}

sub cookie {
    my $self = shift;
    my ($key) = @_;
    return $self->param_cache(
                $key,'_COOKIE',sub{$self->cookie_data();});
}

sub cookie_set {
    my $self = shift;
    my ($key,$data) = @_;
    if(!defined($self->{_COOKIE})) {
        $self->{_COOKIE} = { };
    }
    $self->{_COOKIE}->{$key} = $data;
}

## escape html special chars

sub escape {
    my $self = shift;
    my ($text,$qf,$pf) = @_;
    $text =~ s/\&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    $text =~ s/"/&quot;/g; # "
    $text =~ s/'/&#039;/g unless $qf; # '
    $text =~ s/\{/&#123;/g unless $pf; # CSSXSS
    return $text;
}

sub unescape {
    my $self = shift;
    my ($text) = @_;
    $text =~ s/\&amp;/\&/g;
    $text =~ s/\&lt;/\</g;
    $text =~ s/\&gt;/\>/g;
    $text =~ s/\&quot;/\"/g;
    $text =~ s/\&#039;/\'/g;
    $text =~ s/\&#123;/\{/g; # CSSXSS
    return $text;
}

sub replace_newline {
    my $self = shift;
    my ($text) = @_;
    $text =~ s/\x0D\x0A|\x0D|\x0A/\n/g;
    return $text;
}

sub sanitize_style {
    my $self = shift;
    my ($text) = @_;
    $text =~ s/[\@\x00-\x1F\x80-\xFF\\]//g;
    while($text =~ /(\/\*|\*\/|&#|script|java|exp|eval|cookie|include|behavior|behaviour|binding)/i) {
        $text =~ s/(\/\*|\*\/|&#|script|java|exp|eval|cookie|include|behavior|behaviour|binding)//ig;
    }
    return $text;
}

sub sanitize_escaped_style {
    my $self = shift;
    my ($text) = @_;
    return $self->escape($self->sanitize_style($self->unescape($text)));
}

sub str_to_atrb {
    my $self = shift;
    my ($text,$esc) = @_;
    if($esc) {
        $text = $self->unescape($text);
    }
    if(!$text) {
        return ();
    }
    my @param = split(/,/,$text);
    my %atrb;
    foreach my $x (@param) {
        my ($key,$value) = split(/=/,$x);
        $key = defined($key) ? $key : '';
        $value = defined($value) ? $value : '';
        $key =~ s/^\s*(\S+)\s*$/$1/;
        $value =~ s/^\s*(.+?)\s*$/$1/;
        $key = lc($key);
        $value =~ s/^"([^"]+)"$/$1/; #"
        if($key eq 'style') {
            $value = $self->sanitize_style($value);
        }
        $value = $self->escape($value);
        if($key) {
            $atrb{$key} = $value;
        }
    }
    return %atrb;
}

## server specific

sub check_path_info {
    my $self = shift;
    my ($path_info, $server_name, $script_name) = @_;
    if($server_name =~ /xrea\.com$/) {
        my $sname = File::Basename::basename($script_name);
        $path_info =~ s/\/\Q$sname\E(.*)/$1/;
    }
    return $path_info;
}

## access log
sub curr_date_str {
    my $self = shift;
    my ($tm) = @_;
    $tm = $tm ? $tm : time ;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)
       = localtime($tm);
    $mon++;
    $year = $year + 1900 ;
    my $week = $self->{-wday}->[$wday];
    if ($sec  < 10) { $sec  = "0$sec";  }
    if ($min  < 10) { $min  = "0$min";  }
    if ($hour < 10) { $hour = "0$hour"; }
    if ($mday < 10) { $mday = "0$mday"; }
    if ($mon  < 10) { $mon  = "0$mon";  }
    return "$year-$mon-$mday,$week,$hour:$min:$sec";
}

sub gmt_date_str {
    my $self = shift;
    my ($tm) = @_;
    $tm = $tm ? $tm : time ;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)
       = gmtime($tm);
    $year = $year + 1900 ;
    my $wdy = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
    my $mn = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
              'Sep','Oct','Nov','Dec')[$mon];
    if ($sec  < 10) { $sec  = "0$sec";  }
    if ($min  < 10) { $min  = "0$min";  }
    if ($hour < 10) { $hour = "0$hour"; }
    if ($mday < 10) { $mday = "0$mday"; }
    return "$wdy, $mday-$mn-$year $hour:$min:$sec GMT";
}

sub user_info {
    my $self = shift;
    my $pt = ','.(defined($ENV{PATH_INFO}) ? $ENV{PATH_INFO} : '');
    my $ra = ','.(defined($ENV{REMOTE_ADDR}) ? $ENV{REMOTE_ADDR} : '');
    my $rh = ','.(defined($ENV{REMOTE_HOST}) ? $ENV{REMOTE_HOST} : '');
    my $hr = ','.(defined($ENV{HTTP_REFERER}) ? $ENV{HTTP_REFERER} : '');
    my $ua = ','.(defined($ENV{HTTP_USER_AGENT})?$ENV{HTTP_USER_AGENT} : '');
    my $rq = ','.(defined($ENV{REQUEST_METHOD}) ? $ENV{REQUEST_METHOD} : '');
    my $info = $self->curr_date_str();
    $info .= $pt.$rq.$ra.$rh.$hr.$ua."\n";
    return $info;
}

sub accesslog {
    my $self = shift;
    my ($fname) = @_;
    $fname = defined($fname) ? $fname : 'access_log.txt' ;
    open(LOG,"+>> $fname");
    print LOG $self->user_info();
    close(LOG);
}

sub spamlog {
    my $self = shift;
    $self->accesslog('spam_log.txt');
}

## file access

sub lock {
    my $self = shift;
    my ($retry,$lockdir1,$lockdir2) = @_;
    while(!mkdir($lockdir1, 0755)) {
        if(--$retry <= 0) {
            if(mkdir($lockdir2, 0755)) {
                if((-M $lockdir1) * 86400 > 600) {
                    rename($lockdir2,$lockdir1) || die "lock error";
                    last;
                }
                else {
                    rmdir($lockdir2);
                }
            }
            die "busy";
        }
        sleep(1);
    }
}

sub unlock {
    my $self = shift;
    my ($lockdir1) = @_;
    rmdir($lockdir1);
}

sub check_filename {
    my $self = shift;
    my ($fname,$rex)= @_;
    if($fname =~ /^($rex)$/) { $fname = $1; }
    else { die "Malicious param"; }
    return $fname;
}

sub make_dir {
    my $self = shift;
    my ($dname,$perm)= @_;
    if (not -d $dname) {
        if (!mkdir($dname, $perm)) {
            die "mkdir(" . $dname . ") fail";
        }
    }
}

sub file_info {
    my $self = shift;
    my ($fname) = @_;
    my %info = (
        siz => (stat $fname)[7],
        acc => (stat $fname)[8],
        mod => (stat $fname)[9],
        cre => (stat $fname)[10]
    );
    return %info;
}

sub getwday {
    my $self = shift;
    my ($y,$m,$d) = @_;
    if ($m == 1 or $m == 2) {
        $y--;
        $m += 12;
    }
    return ($y+int($y/4)-int($y/100)+int($y/400)+int((13*$m+8)/5)+$d)%7;
}

sub genkey {
    my $self = shift;
    my ($len) = @_;
    my @letters = ('a'..'z','A'..'Z','0'..'9',".","/");
    my $result = '';
    srand;
    for (1..$len) {
        $result .= $letters[int(rand(@letters))];
    }
    return $result;
}

sub gensalt {
    my $self = shift;
    return $self->genkey(2);
}

sub pwdcrypt {
    my $self = shift;
    my ($pwd) = @_;
    return crypt($pwd, $self->gensalt());
}

sub sidcrypt {
    my $self = shift;
    my ($sid,$salt) = @_;
    $salt = substr($salt,0,2);
    my $esid = '';
    my $pwd = substr($sid,0,8);
    substr($sid,0,8) = '';
    while($pwd ne '') {
        $esid .= crypt($pwd, $salt);
        $pwd = substr($sid,0,8);
        substr($sid,0,8) = '';
    }
    return $esid;
}

sub newsidcrypt {
    my $self = shift;
    my ($pwd) = @_;
    return $self->sidcrypt($pwd, $self->gensalt());
}

## debug
sub debug {
    my $self = shift;
    my $header = $self->{-header};
    while(my ($key,$value) = each(%$self)) {
        print "key: $key, value: $value<br />\n";
    }
    print "<hr />\n";
    while(my ($key,$value) = each(%$header)) {
        print "key: $key, value: $value<br />\n";
    }
}

sub test {
    my $self = shift;
    my %qq = @_;
    print "<hr />\n";
    while(my ($key,$value) = each(%qq)) {
        print "key: $key, value: $value<br />\n";
    }
}

sub log {
    my $self = shift;
    my ($msg,$fname) = @_;
    $fname = $fname || 'log.txt';
    open(LOG,"+>> $fname");
    print LOG $msg;
    close(LOG);
}

1;
