<?php
	define("SESSION_PREFIX", "tategaki");
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	if (!defined("LOGIN_COOKIE_EXPIRE")) {
		define("LOGIN_COOKIE_EXPIRE", (3600 * 24 * 365));	// ログイン setcookie 保存時間
	}

	$fontsize = post_to_cookie('fs', 'fontsize', '18pt', 'fontsize');
	$lineheight = post_to_cookie('lh', 'lineheight', '1.2', 'lineheight');
	$height = post_to_cookie('h', 'height', '100%', 'height');
	$fontfamily = post_to_cookie('ff', 'fontfamily', 'ＭＳ 明朝', 'fontfamily');
	$fontweight = post_to_cookie('fw', 'fontweight', 'normal', 'fontweight');
	$srctype = post_to_cookie('st', 'srctype', 'html', 'srctype');

	if ($_POST) {
		if ($_POST['url'].'' <> '') {
			$contents = mb_convert_encoding(my_file_get_contents($_POST['url']), 'UTF-8', MB_CONVERT_ENCODING_AUTO);
		} else {
			$contents = $_POST['text'];
		}
	} else {
		$contents = mb_convert_encoding(my_file_get_contents($_GET['url']), 'UTF-8', MB_CONVERT_ENCODING_AUTO);
	}
	if ($srctype == 'text') {
		if ($_POST['title'] <> '') {
			$title = $_POST['title'];
		} else {
			$title = '縦書き';
		}
		$contents = ins_atag_br($contents);
	} else {
		$contents = preg_replace('/<div.*?>/i', '', $contents);
		$contents = str_ireplace('</div>', '', $contents);
		//	$contents = str_replace("\n", '<br>', str_replace("\r", '', $contents));
		preg_match('/<body.*?>(.*?)<\/body>/i', $contents, $body);
		if ($body[1].'' <> '') {
			$contents = $body[1];
		}
		if ($_POST['title'] <> '') {
			$title = $_POST['title'];
		} else {
			if (preg_match('/<h1.*?>(.*?)<\/h1>/i', $contents, $h1)) {
				$title = $h1[1];
			} elseif (preg_match('/<h2.*?>(.*?)<\/h2>/i', $contents, $h2)) {
				$title = $h2[1];
			} else {
				$title = '縦書き';
			}
		}
		//	$contents = str_ireplace("<br>", "\n", str_ireplace("<br />", "\n", $contents));
		//	$contents = preg_replace("/\\n+/", "\n", $contents);		// 連続した改行を1個にする
	}
	$contents = mb_convert_kana($contents, 'KV', 'UTF-8');
	$title = mb_convert_kana($title, 'KV', 'UTF-8');
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<title><?= $title ?></title>
<?php	if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) { ?>
<style>
div#vertical {
	writing-mode: tb-rl;		/* テキストを縦書きにする */
}
</style>
<?	} else { ?>
<?php
	$fontfamily = '@'.$fontfamily;	// 縦書きフォント
?>
<style>
html {
	writing-mode: vertical-rl;
	-webkit-writing-mode: vertical-rl;
	-epub-writing-mode: vertical-rl;
	text-align: justify;
}
strong.sesame_dot {
	font-weight: normal;
	text-emphasis-style: sesame;
	-webkit-text-emphasis-style: sesame;
	-epubt-text-emphasis-style: sesame;
}
span.tcy {
	text-combine: horizontal;
	-webkit-text-combine: horizontal;
	-epub-text-combine: horizontal;
}
<?	} ?>
</style>
<style>
body {
	margin: 0px;
	padding: 20px 40px;
	height: <?= $height ?>;
	font-size: <?= $fontsize ?>;
	line-height: <?= $lineheight ?>;
	font-weight: <?= $fontweight ?>;
	font-family: "<?= $fontfamily ?>",serif,sans-serif;
}
h1 { font-size: 140%; font-weight: bold; margin: 0; padding: 0; }
h2 { font-size: 130%; font-weight: bold; margin: 0; padding: 0; }
h3 { font-size: 120%; font-weight: bold; margin: 0; padding: 0; }
h4 { font-size: 110%; font-weight: bold; margin: 0; padding: 0; }
</style>
</head>
<body>
<div id="vertical">
<?= $contents ?>
</div>
</body>
</html>
