﻿Imports System.Drawing.Drawing2D
Imports Launcher7.Model

Namespace Views

    ''' <summary>
    ''' 透明セルクラス。
    ''' </summary>
    ''' <remarks></remarks>
    Public NotInheritable Class GlassButton
        Inherits ImageButton

        Private iconImage As Image

        Private mBtnInfo As LauncherButton

        Public Sub New(ByVal buttonInfo As LauncherButton)
            mBtnInfo = buttonInfo
            iconImage = CreateIconImage(buttonInfo.IconPath)
        End Sub

#Region "initialize methods"

        Private Function CreateIconImage(ByVal path As String) As Image
            Dim result As Image = Nothing

            If Right(path, 4).ToUpper <> ".PNG" Then
                Return GetIconImage(path)
            Else
                Return Image.FromFile(path)
            End If
        End Function

#End Region

        Public Sub FocusDraw(ByVal graphicsObject As Graphics, _
                             ByVal mousePosition As Point, _
                             ByVal column As Integer, ByVal row As Integer)
            Dim x As Integer = column * Model.ButtonSize
            Dim y As Integer = row * Model.ButtonSize
            Dim borderPath = New GraphicsPath
            Dim outCircle = New GraphicsPath
            Dim inCircle = New GraphicsPath

            With graphicsObject
                borderPath.AddRectangle(New Rectangle(x + 4, y + 4, Model.ButtonSize - 8, Model.ButtonSize - 8))

                outCircle.AddArc(mousePosition.X - Model.ButtonSize, _
                                 mousePosition.Y - Model.ButtonSize, _
                                 Model.ButtonSize * 2, Model.ButtonSize * 2, 0, 360)
                Dim outBrush = New PathGradientBrush(outCircle)
                outBrush.CenterPoint = mousePosition
                outBrush.CenterColor = Color.FromArgb(220, Color.Lime)
                outBrush.SurroundColors = New Color() {Color.FromArgb(0, Color.White)}

                inCircle.AddArc(mousePosition.X - Model.ButtonSize \ 2, _
                                mousePosition.Y - Model.ButtonSize \ 2, _
                                Model.ButtonSize, Model.ButtonSize, 0, 360)
                Dim inBrush = New PathGradientBrush(inCircle)
                inBrush.CenterPoint = mousePosition
                inBrush.CenterColor = Color.FromArgb(220, Color.White)
                inBrush.SurroundColors = New Color() {Color.FromArgb(0, Color.Lime)}

                .SetClip(borderPath)
                .FillPath(outBrush, outCircle)
                .FillPath(inBrush, inCircle)
                .ResetClip()
                inBrush.Dispose()
                outBrush.Dispose()

                .DrawImage(Model.SelectFrame, column * Model.ButtonSize, row * Model.ButtonSize)
                If Control.MouseButtons = Windows.Forms.MouseButtons.Left Then
                    .DrawImageUnscaled(iconImage, column * Model.ButtonSize + 10, row * Model.ButtonSize + 10)
                Else
                    .DrawImageUnscaled(iconImage, column * Model.ButtonSize + 8, row * Model.ButtonSize + 8)
                End If
            End With
        End Sub

        Public Sub NonFocusDraw(ByVal graphicsObject As Graphics, _
                                ByVal column As Integer, ByVal row As Integer)
            With graphicsObject
                .DrawImage(Model.SelectFrame, column * Model.ButtonSize, row * Model.ButtonSize)
                .DrawImageUnscaled(iconImage, column * Model.ButtonSize + 8, row * Model.ButtonSize + 8)
            End With
        End Sub

#Region "properties"

        Public ReadOnly Property Title() As String
            Get
                Return Me.mBtnInfo.Title
            End Get
        End Property

        Public ReadOnly Property LinkPath() As String
            Get
                Return Me.mBtnInfo.LinkPath
            End Get
        End Property

        Public ReadOnly Property Argument() As String
            Get
                Return Me.mBtnInfo.Argument
            End Get
        End Property

        Public ReadOnly Property WorkPath() As String
            Get
                Return Me.mBtnInfo.WorkPath
            End Get
        End Property

        Public ReadOnly Property Privilege() As String
            Get
                Return Me.mBtnInfo.Privilege
            End Get
        End Property

#End Region

    End Class

End Namespace

