﻿Imports System.IO
Imports System.Xml
Imports Launcher7.Model
Imports System.Runtime.InteropServices
Imports System.Runtime.InteropServices.ComTypes

Namespace Views

    Public NotInheritable Class MakeForm

        Private sltIdx As Integer, sltX As Integer, sltY As Integer

        Private pageTitle() As String

        Private adjustMap(,,) As AdjustButton

        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)

            pageTitle = New String(10) {}
            adjustMap = New AdjustButton(10, 20, 20) {}

            CreateAdjustMap()
            sltIdx = 0
            pageTitleText.Text = pageTitle(0)
        End Sub

#Region "load initialize"

        Private Sub CreateAdjustMap()
            Dim cnt As Integer = 0
            For Each pg As LauncherPage In GlobalValues.Pages
                CreateAdjustMap(cnt, pg)
                cnt += 1
            Next
        End Sub

        Private Sub CreateAdjustMap(ByVal pageIndex As Integer, _
                                    ByVal pageData As LauncherPage)
            pageTitle(pageIndex) = pageData.Title

            For y As Integer = 0 To pageData.RowCt
                For x As Integer = 0 To pageData.ColumnCt
                    If pageData(x, y) IsNot Nothing Then
                        Dim adjust = New AdjustButton()
                        With pageData(x, y)
                            adjust.Name = .Name
                            adjust.Title = .Title
                            adjust.LinkPath = .LinkPath
                            adjust.Argument = .Argument
                            adjust.WorkPath = .WorkPath
                            adjust.IconPath = .IconPath
                        End With
                        adjust.ReadImage()
                        adjustMap(pageIndex, x, y) = adjust
                    End If
                Next
            Next
        End Sub

#End Region

        Private Sub mainGrid_DropFile(ByVal send As Object, _
                                      ByVal drgevent As DragEventArgs, _
                                      ByVal filePath As String, _
                                      ByVal x As Integer, ByVal y As Integer) Handles mainGrid.DropFile
            sltX = x : sltY = y
            rightLinkCon.SetProperties(filePath)
            Me.Invalidate(True)
        End Sub

        Private Sub mainGrid_ClickGrid(ByVal send As Object, _
                                       ByVal x As Integer, ByVal y As Integer) Handles mainGrid.ClickGrid
            sltX = x : sltY = y
            If (x >= 0 AndAlso x < adjustMap.GetLength(1)) AndAlso _
               (y >= 0 AndAlso y < adjustMap.GetLength(2)) AndAlso _
               adjustMap(sltIdx, sltX, sltY) IsNot Nothing Then
                rightLinkCon.SetProperties(adjustMap(sltIdx, sltX, sltY))
            Else
                rightLinkCon.SetProperties()
            End If
        End Sub

        Private Sub mainGrid_DeleteLink(ByVal send As Object, _
                                        ByVal x As Integer, ByVal y As Integer) Handles mainGrid.DeleteLink
            adjustMap(sltIdx, x, y) = Nothing
            Me.rightLinkCon.SetProperties()
        End Sub

        Private Sub rightLinkCon_ChangeTextEvent(ByVal sender As LinkControl) _
                                                                Handles rightLinkCon.ChangeTextEvent
            If adjustMap(sltIdx, sltX, sltY) Is Nothing Then
                adjustMap(sltIdx, sltX, sltY) = New AdjustButton()
            End If

            With adjustMap(sltIdx, sltX, sltY)
                .Name = sender.LinkName
                .Title = sender.Title
                .Argument = sender.Argument
                .WorkPath = sender.WorkPath
                .LinkPath = sender.LinkPath
                .IconPath = sender.IconPath

                .ReadImage()
            End With
        End Sub

        Private Sub pageChoice_SelectedValueChanged(ByVal sender As Object, ByVal e As EventArgs) _
                                                                Handles pageChoice.SelectedValueChanged
            If pageTitle IsNot Nothing Then
                sltIdx = Integer.Parse(pageChoice.Text)
                pageTitleText.Text = pageTitle(sltIdx)
                rightLinkCon.SetProperties()
                Me.Invalidate(True)
            End If
        End Sub

        Private Sub pageTitleText_TextChanged(ByVal sender As Object, ByVal e As EventArgs) _
                                                                Handles pageTitleText.TextChanged
            pageTitle(sltIdx) = pageTitleText.Text
        End Sub

        Private Sub btnCreate_Click(ByVal sender As Object, ByVal e As EventArgs) _
                                                                Handles btnCreate.Click
            Dim iconList = New SortedList(Of String, AdjustButton)
            For Each ico As AdjustButton In Me.adjustMap
                If ico IsNot Nothing AndAlso Not iconList.ContainsKey(ico.Name) Then
                    iconList.Add(ico.Name, ico)
                End If
            Next
            CreateButtonList(iconList)
            CreateSettingPrm()

            ' ショートカット作成
            Dim shLink = New ShellLinkObject()
            Dim ipFile As IPersistFile = CType(shLink, IPersistFile)
            Dim hpath As String = System.Environment.GetEnvironmentVariable("USERPROFILE")

            Try
                For i As Integer = 0 To 9
                    If pageTitle(i) = String.Empty Then Continue For

                    With CType(shLink, IShellLink)
                        .SetPath(System.Environment.CurrentDirectory & "\bin\7Launcher.exe")
                        .SetArguments(i.ToString)
                        .SetWorkingDirectory(System.Environment.CurrentDirectory & "\bin")
                    End With

                    With CType(shLink, IPersistFile)
                        .Save(hpath & "\" & pageTitle(i) & ".lnk", False)
                    End With
                Next
            Catch ex As Exception
            Finally
                Marshal.ReleaseComObject(ipFile)
                Marshal.ReleaseComObject(shLink)
            End Try

            Process.Start("explorer", hpath)

            Application.Exit()
        End Sub

#Region "file create methods"

        Private Sub CreateButtonList(ByVal iconList As SortedList(Of String, AdjustButton))
            Dim doc = New XmlDocument
            Dim ele As XmlElement
            doc.AppendChild(doc.CreateXmlDeclaration("1.0", "UTF-8", ""))
            doc.AppendChild(doc.CreateElement("Buttons"))

            For Each ico As AdjustButton In iconList.Values
                Dim btn As XmlElement = doc.CreateElement("Button")
                With btn
                    .SetAttribute("Name", ico.Name)
                    .SetAttribute("Title", ico.Title)

                    ele = doc.CreateElement("LinkTarget")
                    If ico.LinkPath <> String.Empty Then
                        ele.AppendChild(doc.CreateTextNode(ico.LinkPath))
                    End If
                    .AppendChild(ele)

                    ele = doc.CreateElement("Argument")
                    If ico.Argument <> String.Empty Then
                        ele.AppendChild(doc.CreateTextNode(ico.Argument))
                    End If
                    .AppendChild(ele)

                    ele = doc.CreateElement("WorkPath")
                    If ico.WorkPath <> String.Empty Then
                        ele.AppendChild(doc.CreateTextNode(ico.WorkPath))
                    End If
                    .AppendChild(ele)

                    ele = doc.CreateElement("IconTarget")
                    If ico.IconPath <> String.Empty Then
                        ele.AppendChild(doc.CreateTextNode(ico.IconPath))
                    End If
                    .AppendChild(ele)

                    ele = doc.CreateElement("Privilege")
                    .AppendChild(ele)
                End With
                doc.SelectSingleNode("/Buttons").AppendChild(btn)
            Next

            doc.Save(AppSetting.FullName & "\" & BUTTON_SETTING)
        End Sub

        Private Sub CreateSettingPrm()
            Dim doc = New XmlDocument

            doc.AppendChild(doc.CreateXmlDeclaration("1.0", "UTF-8", ""))
            doc.AppendChild(doc.CreateElement("Setting"))

            With doc.SelectSingleNode("/Setting")
                Dim ele As XmlElement = doc.CreateElement("ButtonSize")
                ele.AppendChild(doc.CreateTextNode("64"))
                .AppendChild(ele)

                ele = doc.CreateElement("IconSize")
                ele.AppendChild(doc.CreateTextNode("48"))
                .AppendChild(ele)
            End With

            For pidx As Integer = 0 To 9
                Dim xmax As Integer = 0, ymax As Integer = 0
                For i As Integer = adjustMap.GetLength(2) To 1 Step -1
                    For j As Integer = adjustMap.GetLength(1) To 1 Step -1
                        If adjustMap(pidx, j - 1, i - 1) IsNot Nothing Then
                            If xmax < j Then xmax = j
                            If ymax < i Then ymax = i
                        End If
                    Next
                Next

                If xmax = 0 OrElse ymax = 0 Then
                    pageTitle(pidx) = String.Empty
                    Continue For
                End If

                Dim page As XmlElement = doc.CreateElement("Page")
                With page
                    .SetAttribute("Name", pidx)
                    .SetAttribute("X_cnt", xmax)
                    .SetAttribute("Y_cnt", ymax)
                    .SetAttribute("Title", pageTitle(pidx))

                    For i As Integer = 0 To ymax - 1
                        Dim row As XmlElement = doc.CreateElement("Row")

                        For j As Integer = 0 To xmax - 1
                            Dim clm As XmlElement = doc.CreateElement("Column")
                            If adjustMap(pidx, j, i) IsNot Nothing AndAlso _
                               adjustMap(pidx, j, i).Name <> String.Empty Then
                                clm.AppendChild(doc.CreateTextNode(adjustMap(pidx, j, i).Name))
                            End If
                            row.AppendChild(clm)
                        Next

                        .AppendChild(row)
                    Next
                End With
                doc.SelectSingleNode("/Setting").AppendChild(page)
            Next

            doc.Save(AppSetting.FullName & "\" & SETTING_PARAM)
        End Sub

#End Region

#Region "properties"

        Public ReadOnly Property AdjustButtonCell(ByVal x As Integer, _
                                                  ByVal y As Integer) As AdjustButton
            Get
                Return adjustMap(sltIdx, x, y)
            End Get
        End Property

        Public ReadOnly Property IsSelect(ByVal x, ByVal y) As Boolean
            Get
                Return (x = sltX AndAlso y = sltY)
            End Get
        End Property

#End Region

    End Class

End Namespace
