﻿Imports System.IO
Imports System.Runtime.InteropServices
Imports System.Runtime.InteropServices.ComTypes
Imports System.Text
Imports Launcher7.Model

Namespace Views

    Public NotInheritable Class LinkControl

        Public Event ChangeTextEvent(ByVal sender As LinkControl)

        Public Sub New()
            InitializeComponent()

            EnableTextChange()
        End Sub

#Region ""

        Private Sub EnableTextChange()
            AddHandler Me.nameText.TextChanged, AddressOf controlTextChanged
            AddHandler Me.titleText.TextChanged, AddressOf controlTextChanged
            AddHandler Me.linkText.TextChanged, AddressOf controlTextChanged
            AddHandler Me.argumentText.TextChanged, AddressOf controlTextChanged
            AddHandler Me.workPathText.TextChanged, AddressOf controlTextChanged
            AddHandler Me.iconPathText.TextChanged, AddressOf controlTextChanged
        End Sub

        Private Sub NotEnableTextChange()
            RemoveHandler Me.nameText.TextChanged, AddressOf controlTextChanged
            RemoveHandler Me.titleText.TextChanged, AddressOf controlTextChanged
            RemoveHandler Me.linkText.TextChanged, AddressOf controlTextChanged
            RemoveHandler Me.argumentText.TextChanged, AddressOf controlTextChanged
            RemoveHandler Me.workPathText.TextChanged, AddressOf controlTextChanged
            RemoveHandler Me.iconPathText.TextChanged, AddressOf controlTextChanged
        End Sub

#End Region

        Public Sub SetProperties()
            NotEnableTextChange()

            Me.nameText.Text = String.Empty
            Me.titleText.Text = String.Empty
            Me.linkText.Text = String.Empty
            Me.argumentText.Text = String.Empty
            Me.workPathText.Text = String.Empty
            Me.iconPathText.Text = String.Empty

            EnableTextChange()
        End Sub

        Public Sub SetProperties(ByVal filePath As String)
            Dim fl As FileInfo = New FileInfo(filePath)
            Dim nm As String = fl.Name.Substring(0, fl.Name.Length - 4)
            Dim ph As String

            Select Case fl.Extension
                Case ".lnk"
                    NotEnableTextChange()
                    Me.nameText.Text = nm
                    Me.titleText.Text = nm

                    ph = AppLinks.FullName & "\" & fl.Name
                    If File.Exists(ph) Then File.Delete(ph)
                    fl.CopyTo(ph)

                    Me.linkText.Text = ph
                    Me.iconPathText.Text = ph
                    EnableTextChange()
                    RaiseEvent ChangeTextEvent(Me)

                Case ".exe"
                    NotEnableTextChange()
                    Me.nameText.Text = nm
                    Me.titleText.Text = nm
                    Me.workPathText.Text = fl.DirectoryName
                    Me.linkText.Text = fl.FullName
                    Me.iconPathText.Text = fl.FullName
                    EnableTextChange()
                    RaiseEvent ChangeTextEvent(Me)
            End Select
        End Sub

        Public Sub SetProperties(ByVal param As AdjustButton)
            NotEnableTextChange()
            With param
                Me.nameText.Text = .Name
                Me.titleText.Text = .Title
                Me.linkText.Text = .LinkPath
                Me.argumentText.Text = .Argument
                Me.workPathText.Text = .WorkPath
                Me.iconPathText.Text = .IconPath
            End With
            EnableTextChange()
            RaiseEvent ChangeTextEvent(Me)
        End Sub

        Private Sub btnLink_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnLink.Click

        End Sub

        Private Sub btnWorkPath_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnWorkPath.Click

        End Sub

        Private Sub btnIconPath_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnIconPath.Click

        End Sub

        Private Sub controlTextChanged(ByVal sender As Object, ByVal e As EventArgs)
            RaiseEvent ChangeTextEvent(Me)
        End Sub

#Region "properties"

        Public ReadOnly Property LinkName() As String
            Get
                Return Me.nameText.Text
            End Get
        End Property

        Public ReadOnly Property Title() As String
            Get
                Return Me.titleText.Text
            End Get
        End Property

        Public ReadOnly Property LinkPath() As String
            Get
                Return Me.linkText.Text
            End Get
        End Property

        Public ReadOnly Property Argument() As String
            Get
                Return Me.argumentText.Text
            End Get
        End Property

        Public ReadOnly Property WorkPath() As String
            Get
                Return Me.workPathText.Text
            End Get
        End Property

        Public ReadOnly Property IconPath() As String
            Get
                Return Me.iconPathText.Text
            End Get
        End Property

#End Region

    End Class

End Namespace

