﻿Imports System.IO
Imports System.Xml
Imports System.Text
Imports System.Text.RegularExpressions

Namespace Model

    Public NotInheritable Class LauncherButton

        Public Shared Sub CreateButtonData(ByVal buttonList As List(Of LauncherButton), _
                                           ByVal buttonTag As XmlNode)
            Dim other = New LauncherButton(buttonTag)
            With other
                If .CheckExists(.mWorkPath) AndAlso _
                   .CheckExists(.mIconTarget) Then
                    buttonList.Add(other)
                End If
            End With
        End Sub

        Private mName As String

        Private mTitle As String

        Private mLinkTarget As String

        Private mArgument As String

        Private mWorkPath As String

        Private mIconTarget As String

        Private mPrivilege As String

        Private Sub New(ByVal buttonTag As XmlNode)
            With buttonTag
                mName = .Attributes("Name").Value.Trim()
                mTitle = .Attributes("Title").Value.Trim()
            End With

            mLinkTarget = ConvatPath(GetTagValue(buttonTag, "LinkTarget"))
            mArgument = GetTagValue(buttonTag, "Argument")
            mWorkPath = ConvatPath(GetTagValue(buttonTag, "WorkPath"))
            mIconTarget = ConvatPath(GetTagValue(buttonTag, "IconTarget"))
            mPrivilege = GetTagValue(buttonTag, "Privilege")
        End Sub

        Private Function GetTagValue(ByVal buttonTag As XmlNode, ByVal valueName As String) As String
            Return buttonTag.SelectSingleNode(valueName).InnerText.Trim()
        End Function

        Private Function CheckExists(ByVal path As String) As Boolean
            Return path = "" OrElse File.Exists(path) OrElse Directory.Exists(path)
        End Function

        Private Function ConvatPath(ByVal line As String) As String
            Dim buf = New StringBuilder(line)
            Dim trm() = New Char() {"%"c}

            For Each math As Match In Regex.Matches(line, "%.*?%")
                Dim s As String = System.Environment.GetEnvironmentVariable(math.Value.Trim(trm))
                buf.Replace(math.Value, s)
            Next

            Return buf.ToString()
        End Function

#Region "properties"

        Public ReadOnly Property Name() As String
            Get
                Return mName
            End Get
        End Property

        Public ReadOnly Property Title() As String
            Get
                Return mTitle
            End Get
        End Property

        Public ReadOnly Property LinkPath() As String
            Get
                Return mLinkTarget
            End Get
        End Property

        Public ReadOnly Property Argument() As String
            Get
                Return mArgument
            End Get
        End Property

        Public ReadOnly Property IconPath() As String
            Get
                Return mIconTarget
            End Get
        End Property

        Public ReadOnly Property WorkPath() As String
            Get
                Return mWorkPath
            End Get
        End Property

        Public ReadOnly Property Privilege() As String
            Get
                Return mPrivilege
            End Get
        End Property

#End Region

    End Class

End Namespace