﻿Imports System.Runtime.InteropServices

Namespace Model

    Public Class ImageButton

#Region "Win32 Api"

        <DllImport("comctl32")> _
        Protected Shared Function ImageList_Create(ByVal cx As Integer, ByVal cy As Integer, _
                                                 ByVal flags As UInteger, ByVal cInitial As Integer, ByVal cGrow As Integer) As IntPtr
        End Function

        <DllImport("shell32.dll")> _
        Protected Shared Function SHGetFileInfo(ByVal pszPath As String, ByVal dwFileAttributes As Integer, _
                                                ByRef psfi As Win32.SHFILEINFO, ByVal cbFileInfo As Integer, ByVal uFlags As Integer) As IntPtr
        End Function

        <DllImport("shell32.dll", EntryPoint:="#727")> _
        Protected Shared Function SHGetImageList(ByVal iImageList As Integer, ByRef riid As System.Guid, ByRef ppv As IntPtr) As Integer
        End Function

        <DllImport("comctl32")> _
        Protected Shared Function ImageList_GetIcon(ByVal himl As IntPtr, ByVal i As Integer, ByVal flags As Integer) As IntPtr
        End Function

        <DllImport("comctl32")> _
        Protected Shared Function ImageList_Destroy(ByVal himl As IntPtr) As IntPtr
        End Function

#End Region

        Protected Function GetIconImage(ByVal path As String) As Image
            Dim shinfo As New Win32.SHFILEINFO()
            Dim hSuccess As IntPtr
            Dim oguid = New System.Guid("46EB5926-582E-4017-9FDF-E8998DAA0950")
            Dim result As Image = Nothing

            Dim hImgList As IntPtr = ImageList_Create(Model.IconSize, Model.IconSize, _
                                                      Win32.ILC_COLOR Or Win32.ILC_MASK, 4, 0)
            SHGetImageList(Win32.SHIL_EXTRALARGE, oguid, hImgList)

            hSuccess = SHGetFileInfo(path, 0, shinfo, Marshal.SizeOf(shinfo), _
                                     Win32.SHGFI_ICON Or Win32.SHGFI_SYSICONINDEX Or _
                                     Win32.SHGFI_LARGEICON Or Win32.SHGFI_LINKOVERLAY)

            If Not hSuccess.Equals(IntPtr.Zero) Then
                Dim icn As IntPtr = ImageList_GetIcon(hImgList, shinfo.iIcon.ToInt32(), 0)
                result = Icon.FromHandle(icn).ToBitmap()
            End If

            ImageList_Destroy(hImgList)

            Return result
        End Function


    End Class

End Namespace

