﻿Imports System.IO
Imports System.Environment
Imports Launcher7.Model
Imports Microsoft.VisualBasic.ApplicationServices

Namespace My

    Partial Friend Class MyApplication

        Private Sub MyApplication_Startup(ByVal sender As Object, ByVal e As StartupEventArgs) Handles Me.Startup
            CurrentDirectory = CurrentDirectory & Model.APPLICATION_PATH

            Try
                ReadApplicationFolder()
                CheckApplicationDirectory()

                ReadLauncherButtons()
                ReadLauncherSetting()

                If e.CommandLine.Count < 1 Then
                    Me.MainForm = New Views.MakeForm()
                Else
                    Model.CurrentPage = Model.Page(e.CommandLine(0))
                    Me.MainForm = New Views.ButtonFrame()
                End If
                '

            Catch ex As Exception
                MessageBox.Show(ex.Message)
                e.Cancel = True
            End Try
        End Sub

        Private Sub CheckApplicationDirectory()
            If Not Model.AppDirectory.Exists Then
                AppDirectory.Create()
                AppLinks.Create()
                AppSetting.Create()
            End If

            For Each fl As FileInfo In New DirectoryInfo("data").GetFiles
                If fl.Extension = ".xml" Then
                    Dim des As String = String.Format("{0}\{1}", AppSetting.FullName, fl.Name)
                    If Not File.Exists(des) Then fl.CopyTo(des, True)
                End If
            Next
        End Sub

    End Class

End Namespace

