/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBoxItem {
    protected String name;
    protected String text;
    protected int value;
    protected boolean isActive;
    protected CColor color;
    protected int id = -1;
    protected ControlGroup<?> parent;
    private boolean toUpperCase = true;

    protected ListBoxItem(ControlGroup<?> controlGroup, String string, int n) {
        this.name = string;
        this.text = string;
        this.value = n;
        this.parent = controlGroup;
        this.color = new CColor(controlGroup.color);
    }

    public CColor getColor() {
        return this.color;
    }

    public void setColor(CColor cColor) {
        this.color.set(cColor);
        this.updateListBoxItems();
    }

    public void setColorActive(int n) {
        this.color.setActive(n);
        this.updateListBoxItems();
    }

    public void setColorForeground(int n) {
        this.color.setForeground(n);
        this.updateListBoxItems();
    }

    public void setColorBackground(int n) {
        this.color.setBackground(n);
        this.updateListBoxItems();
    }

    public void setColorLabel(int n) {
        this.color.setCaptionLabel(n);
        this.updateListBoxItems();
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public ListBoxItem setText(String string) {
        this.text = string;
        this.updateListBoxItems();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isActive() {
        ControlP5.logger().info("no effect for isActive, please dont use yet.");
        return this.isActive;
    }

    public String toString() {
        return "\ntype:\t" + this.getClass() + "\nname:\t" + this.name + "\n" + "label:\t" + this.text + "\n" + "id:\t" + this.id + "\n" + "value:\t" + this.value + "\n" + "color:\t" + this.getColor() + "\n";
    }

    public void toUpperCase(boolean bl) {
        this.toUpperCase = bl;
        this.updateListBoxItems();
    }

    public boolean getToUpperCase() {
        return this.toUpperCase;
    }

    private void updateListBoxItems() {
        try {
            Method method = this.parent.getClass().getMethod("updateListBoxItems", new Class[0]);
            method.invoke(this.parent, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

