/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControlWindow;
import controlP5.ListBox;
import controlP5.ListBoxItem;
import controlP5.Slider;
import controlP5.Textlabel;
import processing.core.PApplet;
import processing.core.PImage;

public class MultiExposedHolic
extends PApplet {
    ControlP5 cp5;
    ControlWindow controlWindow;
    ControlWindow viewWindow;
    Textlabel readmeText;
    ListBox l;
    int blendmode = 0;
    String imgPath;
    PImage img0;
    PImage img1;
    PImage tuned_img0;
    PImage tuned_img1;
    PImage writeimg;
    float gamma_s = 1.0f;
    float gamma_m = 1.0f;
    float gain_s = 1.0f;
    float gain_m = 1.0f;
    float[] lut_s = new float[256];
    float[] lut_m = new float[256];
    int view_width = 1024;
    int view_height = 768;
    int view_swidth0;
    int view_sheight0;
    int view_swidth1;
    int view_sheight1;
    int size_sx = 160;
    int size_sy = 120;
    int size_x = 800;
    int size_y = 640;

    public void TuneImage() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        while (n5 < 256) {
            this.lut_s[n5] = 255.0f * MultiExposedHolic.pow((float)((float)n5 / 255.0f), (float)(1.0f / this.gamma_s));
            ++n5;
        }
        n5 = 0;
        while (n5 < 256) {
            this.lut_m[n5] = 255.0f * MultiExposedHolic.pow((float)((float)n5 / 255.0f), (float)(1.0f / this.gamma_m));
            ++n5;
        }
        this.tuned_img0 = this.createImage(this.img0.width, this.img0.height, 1);
        this.tuned_img1 = this.createImage(this.img1.width, this.img1.height, 1);
        this.img0.loadPixels();
        this.img1.loadPixels();
        n5 = 0;
        while (n5 < this.img0.width * this.img0.height) {
            n4 = this.img0.pixels[n5];
            n3 = (int)(this.lut_s[(int)this.red(n4)] * this.gain_s);
            n2 = (int)(this.lut_s[(int)this.green(n4)] * this.gain_s);
            n = (int)(this.lut_s[(int)this.blue(n4)] * this.gain_s);
            this.tuned_img0.pixels[n5] = this.color(n3, n2, n);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.img1.width * this.img1.height) {
            n4 = this.img1.pixels[n5];
            n3 = (int)(this.lut_m[(int)this.red(n4)] * this.gain_m);
            n2 = (int)(this.lut_m[(int)this.green(n4)] * this.gain_m);
            n = (int)(this.lut_m[(int)this.blue(n4)] * this.gain_m);
            this.tuned_img1.pixels[n5] = this.color(n3, n2, n);
            ++n5;
        }
    }

    public void ImageMultiExposed() {
        this.writeimg = this.createImage(this.img0.width, this.img0.height, 1);
        if (this.writeimg.width > this.size_x || this.writeimg.height > this.size_y) {
            float f = (float)this.writeimg.width / (float)this.size_x;
            float f2 = (float)this.writeimg.height / (float)this.size_y;
            float f3 = f > f2 ? f : f2;
            this.view_width = (int)((float)this.writeimg.width / f3);
            this.view_height = (int)((float)this.writeimg.height / f3);
        } else {
            this.view_width = this.writeimg.width;
            this.view_height = this.writeimg.height;
        }
        this.tuned_img0.loadPixels();
        this.tuned_img1.loadPixels();
        switch (this.blendmode) {
            case 1: {
                int n = 0;
                while (n < this.img0.width * this.img0.height) {
                    int n2 = this.tuned_img0.pixels[n];
                    int n3 = this.tuned_img1.pixels[n];
                    int n4 = (int)this.red(n2) + (int)this.red(n3) - (int)this.red(n2) * (int)this.red(n3) / 255;
                    int n5 = (int)this.green(n2) + (int)this.green(n3) - (int)this.green(n2) * (int)this.green(n3) / 255;
                    int n6 = (int)this.blue(n2) + (int)this.blue(n3) - (int)this.blue(n2) * (int)this.blue(n3) / 255;
                    this.writeimg.pixels[n] = this.color(n4, n5, n6);
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.img0.width * this.img0.height) {
                    int n7 = this.tuned_img0.pixels[n];
                    int n8 = this.tuned_img1.pixels[n];
                    int n9 = (int)this.red(n7) * (int)this.red(n8) / 255;
                    int n10 = (int)this.green(n7) * (int)this.green(n8) / 255;
                    int n11 = (int)this.blue(n7) * (int)this.blue(n8) / 255;
                    this.writeimg.pixels[n] = this.color(n9, n10, n11);
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.img0.width * this.img0.height) {
                    int n12 = this.tuned_img0.pixels[n];
                    int n13 = this.tuned_img1.pixels[n];
                    int n14 = (int)this.red(n12) >= 128 ? 2 * ((int)this.red(n12) + (int)this.red(n13) - (int)this.red(n12) * (int)this.red(n13) / 255) - 255 : (int)this.red(n12) * (int)this.red(n13) * 2 / 255;
                    int n15 = (int)this.green(n12) >= 128 ? 2 * ((int)this.green(n12) + (int)this.green(n13) - (int)this.green(n12) * (int)this.green(n13) / 255) - 255 : (int)this.green(n12) * (int)this.green(n13) * 2 / 255;
                    int n16 = (int)this.blue(n12) >= 128 ? 2 * ((int)this.blue(n12) + (int)this.blue(n13) - (int)this.blue(n12) * (int)this.blue(n13) / 255) - 255 : (int)this.blue(n12) * (int)this.blue(n13) * 2 / 255;
                    this.writeimg.pixels[n] = this.color(n14, n15, n16);
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.img0.width * this.img0.height) {
                    int n17 = this.tuned_img0.pixels[n];
                    int n18 = this.tuned_img1.pixels[n];
                    int n19 = (int)this.red(n17) > (int)this.red(n18) ? (int)this.red(n17) : (int)this.red(n18);
                    int n20 = (int)this.green(n17) > (int)this.green(n18) ? (int)this.green(n17) : (int)this.green(n18);
                    int n21 = (int)this.blue(n17) > (int)this.blue(n18) ? (int)this.blue(n17) : (int)this.blue(n18);
                    this.writeimg.pixels[n] = this.color(n19, n20, n21);
                    ++n;
                }
                break;
            }
        }
        this.writeimg.updatePixels();
    }

    public void setup() {
        this.size(this.size_x, this.size_y + this.size_sy);
        this.cp5 = new ControlP5((PApplet)this);
        this.controlWindow = this.cp5.addControlWindow("Tunewindow", 100, 100, 360, 600).hideCoordinates().setBackground(this.color(40));
        ((Button)((Button)this.cp5.addButton("Load Source Image").setPosition(40.0f, 40.0f)).setSize(130, 39)).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gamma_s").setRange(0.0f, 2.0f).setPosition(40.0f, 100.0f)).setSize(100, 25).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gain_s").setRange(0.0f, 4.0f).setPosition(40.0f, 140.0f)).setSize(100, 25).moveTo(this.controlWindow);
        ((Button)((Button)this.cp5.addButton("Load MultipleExposed Image").setPosition(200.0f, 40.0f)).setSize(130, 39)).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gamma_m").setRange(0.0f, 2.0f).setPosition(200.0f, 100.0f)).setSize(100, 25).moveTo(this.controlWindow);
        ((Slider)this.cp5.addSlider("gain_m").setRange(0.0f, 4.0f).setPosition(200.0f, 140.0f)).setSize(100, 25).moveTo(this.controlWindow);
        this.l = (ListBox)((ListBox)((ListBox)this.cp5.addListBox("myList").setPosition(40.0f, 250.0f)).setSize(120, 180).setItemHeight(39).setBarHeight(20)).setColorBackground(this.color(40, 128)).setColorActive(this.color(255, 128)).moveTo(this.controlWindow);
        this.l.captionLabel().toUpperCase(true);
        this.l.captionLabel().set("MultiExposed Mode");
        this.l.captionLabel().setColor(-65536);
        this.l.captionLabel().style().marginTop = 3;
        this.l.valueLabel().style().marginTop = 3;
        ListBoxItem listBoxItem = this.l.addItem("Screen", 0);
        listBoxItem.setColorBackground(-65536);
        listBoxItem = this.l.addItem("Multiply", 1);
        listBoxItem.setColorBackground(-65536);
        listBoxItem = this.l.addItem("Overlay", 2);
        listBoxItem.setColorBackground(-65536);
        listBoxItem = this.l.addItem("Lighten", 3);
        listBoxItem.setColorBackground(-65536);
        ((Button)((Button)this.cp5.addButton("Save Image").setPosition(40.0f, 500.0f)).setSize(100, 39)).moveTo(this.controlWindow);
        ((Button)((Button)this.cp5.addButton("Exit").setPosition(160.0f, 500.0f)).setSize(100, 39)).moveTo(this.controlWindow);
        this.img0 = this.createImage(this.size_sx, this.size_sy, 1);
        this.img1 = this.createImage(this.size_sx, this.size_sy, 1);
        this.writeimg = this.createImage(this.size_x, this.size_y, 1);
    }

    public void controlEvent(ControlEvent controlEvent) {
        float f;
        float f2;
        float f3;
        if (controlEvent.isFrom("Load Source Image")) {
            this.imgPath = this.selectInput();
            this.img0 = this.loadImage(this.imgPath);
            if (this.img0.width > this.size_sx || this.img0.height > this.size_sy) {
                f3 = (float)this.img0.width / (float)this.size_sx;
                f2 = (float)this.img0.height / (float)this.size_sy;
                f = f3 > f2 ? f3 : f2;
                this.view_swidth0 = (int)((float)this.img0.width / f);
                this.view_sheight0 = (int)((float)this.img0.height / f);
            } else {
                this.view_swidth0 = this.img0.width;
                this.view_sheight0 = this.img0.height;
            }
        }
        if (controlEvent.isFrom("Load MultipleExposed Image")) {
            this.imgPath = this.selectInput();
            this.img1 = this.loadImage(this.imgPath);
            if (this.img1.width > this.size_sx || this.img1.height > this.size_sy) {
                f3 = (float)this.img1.width / (float)this.size_sx;
                f2 = (float)this.img1.height / (float)this.size_sy;
                f = f3 > f2 ? f3 : f2;
                this.view_swidth1 = (int)((float)this.img1.width / f);
                this.view_sheight1 = (int)((float)this.img1.height / f);
            } else {
                this.view_swidth1 = this.img1.width;
                this.view_sheight1 = this.img1.height;
            }
        }
        if (controlEvent.isGroup()) {
            this.blendmode = (int)controlEvent.group().value() + 1;
        }
        if (controlEvent.isFrom("Save Image")) {
            String string = this.selectOutput();
            this.writeimg.save(string);
        }
        if (controlEvent.isFrom("Exit")) {
            this.exit();
        }
    }

    public void draw() {
        this.background(0);
        this.tuned_img0 = this.img0;
        this.tuned_img1 = this.img1;
        if (this.img0.width == this.img1.width && this.img0.height == this.img1.height) {
            this.TuneImage();
            this.ImageMultiExposed();
        }
        this.image(this.tuned_img0, 0.0f, 0.0f, this.view_swidth0, this.view_sheight0);
        this.image(this.tuned_img1, this.size_sx, 0.0f, this.view_swidth1, this.view_sheight1);
        if (this.img0.width == this.img1.width && this.img0.height == this.img0.height) {
            this.image(this.writeimg, 0.0f, this.size_sy, this.view_width, this.view_height);
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "MultiExposedHolic"});
    }
}

