# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

use strict;

package MT::Entry;

sub jumble {
	my $self = shift;
	my $plugin = MT->component('Nabeatsu');

	$self->title($plugin->translate('foo'));
	$self->text($plugin->translate('bar'));
	$self->text_more($plugin->translate('buz'));
}

package MT::Blog;

sub jumble {
	my $self = shift;
	my $plugin = MT->component('Nabeatsu');

	$self->name($plugin->translate('foo'));
	$self->description($plugin->translate('bar'));
}

package MT::Category;

sub jumble {
	my $self = shift;
	my $plugin = MT->component('Nabeatsu');

	$self->label($plugin->translate('foo'));
	$self->description($plugin->translate('bar'));
}

package Nabeatsu;

sub _hdlr_nabeatsu {
    my($ctx, $args, $cond) = @_;
	my $nabeatsu = $args->{'nabeatsu'} || '';

	my %keys = qw(
		entries		entry
		blogs		blog
		categories	category
	);

	my $tag = lc($ctx->stash('tag'));
	my $key = $keys{$tag};
	my $build = undef;

	if ($nabeatsu =~ m/of\s+the\s+world/) {
		local $SIG{__WARN__} = sub {  }; 

		my $current_id = 0;
		my $index = 0;
		require MT::Builder;
		$build = \&MT::Builder::build;
		*MT::Builder::build = sub {
			my ($builder, $ctx, $tokens, $cond) = @_;
			my $obj = $ctx->{__stash}{$key};
			if ($obj && $obj->id != $current_id) {
				$index++;
				$current_id = $obj->id;
				if (($index % 3) == 0 || $index =~ m/3/) {
					my $clone = $obj->clone;
					$clone->jumble;
					$ctx->{__stash}{$key} = $clone;
				}
			}

			$build->(@_);
		};
	}

    defined(my $result = $ctx->super_handler( $args, $cond ))
        or return $ctx->error($ctx->errstr);

	if ($build) {
		*MT::Builder::build = $build;
	}

    return $result;
}

1;
