<?php
# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

function nabeatsu_init() {
	global $mt;

	global $nabeatsu_l10n_lexicon;
	$nabeatsu_l10n_lexicon = null;
	$publish_charset = $mt->config('DefaultLanguage');
	$l10n = dirname(dirname(realpath(__FILE__))) . DIRECTORY_SEPARATOR
		. 'lib' . DIRECTORY_SEPARATOR . 'Nabeatsu' . DIRECTORY_SEPARATOR
		. 'L10N' . DIRECTORY_SEPARATOR . $publish_charset . '.pm';
	if (file_exists($l10n)) {
		$fh = fopen($l10n, 'r');
		$in = false;
		$cont = '';
		while ($l = fgets($fh)) {
			if ($l == "%Lexicon = (\n") {
				$in = true;
				continue;
			}
			else if ($l == ");\n") {
				$in = false;
				continue;
			}
			else if ($in) {
				$cont .= $l;
			}
		}

		eval('$nabeatsu_l10n_lexicon = array(' . $cont . ');');
	}

	$ctx =& $mt->context();
	$handler_assoc = array(
		'entries' => 'nabeatsu_iterate_wrapper',
		'categories' => 'nabeatsu_iterate_wrapper',
		'blogs' => 'nabeatsu_iterate_wrapper',
	);
	global $nabeatsu_orig_handlers;
	$nabeatsu_orig_handlers = array();
	foreach ($handler_assoc as $from => $to) {
		$nabeatsu_orig_handlers[$from] = $ctx->add_container_tag($from, $to);
	}
}

function nabeatsu_translate($str) {
	global $nabeatsu_l10n_lexicon;
	if ($nabeatsu_l10n_lexicon && $nabeatsu_l10n_lexicon[$str]) {
		return $nabeatsu_l10n_lexicon[$str];
	}
	else {
		return $str;
	}
}

function nabeatsu_entry_jumble(&$obj) {
	$obj['entry_title'] = nabeatsu_translate('foo');
	$obj['entry_text'] = nabeatsu_translate('bar');
	$obj['entry_title_more'] = nabeatsu_translate('buz');
}

function nabeatsu_blog_jumble(&$obj) {
	$obj['blog_name'] = nabeatsu_translate('foo');
	$obj['blog_description'] = nabeatsu_translate('bar');
}

function nabeatsu_category_jumble(&$obj) {
	$obj['category_label'] = nabeatsu_translate('foo');
	$obj['category_description'] = nabeatsu_translate('bar');
}

function nabeatsu_iterate_wrapper($args, $content, &$ctx, &$repeat) {
    $tag = $ctx->this_tag();
	$tag = preg_replace('/^mt:?/', '', strtolower($tag));
    $localvars = array('nabeatsu_processed');
    if (!isset($content)) {
        $ctx->localize($localvars);
		$ctx->stash('nabeatsu_processed', 0);
    }

	$map = array(
		'entries' => array(
			'key' => 'entries',
			'datasource' => 'entry',
		),
		'blogs' => array(
			'key' => '_blogs',
			'datasource' => 'blog',
		),
		'categories' => array(
			'key' => '_categories',
			'datasource' => 'category',
		),
	);
	$obj_key = $map[$tag]['key'];
	$datasource = $map[$tag]['datasource'];

	$objs = $ctx->stash($obj_key);
	$processed = $ctx->stash('nabeatsu_processed');
	if ($objs && ! $processed) {
		for ($i = 0; $i < sizeof($objs); $i++) {
			$index = $i+1;
			if (($index % 3) == 0 || (strpos($index, '3') !== false)) {
				call_user_func_array(
					'nabeatsu_' . $datasource . '_jumble',
					array(&$objs[$i])
				);
			}
		}

		$ctx->stash('nabeatsu_processed', 1);
		$ctx->stash($obj_key, $objs);
	}

    global $nabeatsu_orig_handlers;
    $fn = $nabeatsu_orig_handlers[$tag];
    $result = $fn($args, $content, $ctx, $repeat);

	if (! $repeat) {
        $ctx->restore($localvars);
	}

    return $result;
}

nabeatsu_init();

?>
