/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.portal;

import jp.mosp.framework.base.MospException;

/**
 * アクション前処理インターフェース。<br><br>
 * PlatfromAction.preAction()内で実行される。<br>
 * 全てのアクションの前処理として実行したい処理を実装する。<br>
 * 但し、ログインユーザが存在しない場合は実行しない。<br>
 */
public interface PreActionBeanInterface {
	
	/**
	 * アクション前処理を実行する。<br>
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	void preAction() throws MospException;
	
}
