/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.math.BigInteger;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class PatriciaTrieSearch
implements LzssSearchMethod {
    private static final int UNUSED = 0;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private int[] parent;
    private int[] hashTable;
    private int[] prev;
    private int[] next;
    private int[] position;
    private int[] level;
    private int[] childnum;
    private int avail;
    private int shift;
    private int lastMatchPos;
    private int lastMatchLen;

    private PatriciaTrieSearch() {
    }

    public PatriciaTrieSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer) {
        this.DictionarySize = DictionarySize;
        this.MaxMatch = MaxMatch;
        this.Threshold = Threshold;
        this.TextBuffer = TextBuffer;
        this.DictionaryLimit = this.DictionarySize;
        this.parent = new int[this.DictionarySize * 2];
        this.prev = new int[this.DictionarySize * 2];
        this.next = new int[this.DictionarySize * 2];
        this.position = new int[this.DictionarySize];
        this.level = new int[this.DictionarySize];
        this.childnum = new int[this.DictionarySize];
        this.hashTable = new int[PatriciaTrieSearch.generateProbablePrime(this.DictionarySize + (this.DictionarySize >> 2))];
        int i = 2;
        while (i < this.DictionarySize) {
            this.next[i] = i - 1;
            ++i;
        }
        this.avail = this.DictionarySize - 1;
        i = 0;
        while (i < this.DictionarySize * 2) {
            this.parent[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.hashTable.length) {
            this.hashTable[i] = 0;
            ++i;
        }
        this.shift = Bits.len(this.DictionarySize) - 8;
        this.lastMatchLen = 0;
        this.lastMatchPos = 0;
    }

    public void put(int position) {
        int matchlen;
        int matchpos;
        block13: {
            int max;
            int scannode;
            int posnode = (position & this.DictionarySize - 1) + this.DictionarySize;
            this.deleteNode(posnode);
            int matchnode = -1;
            matchpos = position;
            if (3 < this.lastMatchLen) {
                scannode = this.lastMatchPos + 1 | this.DictionarySize;
                while (this.parent[scannode] == 0) {
                    scannode = this.next[scannode];
                }
                int node = this.parent[scannode];
                --this.lastMatchLen;
                while (node > 0 && this.lastMatchLen <= this.level[node]) {
                    scannode = node;
                    node = this.parent[node];
                }
                while (node > 0) {
                    this.position[node] = position;
                    node = this.parent[node];
                }
                matchlen = this.lastMatchLen;
            } else {
                scannode = this.child(this.TextBuffer[position] - 128, this.TextBuffer[position + 1] & 0xFF);
                matchlen = 2;
                if (scannode == 0) {
                    this.attachNode(this.TextBuffer[position] - 128, posnode, this.TextBuffer[position + 1] & 0xFF);
                    this.lastMatchLen = matchlen;
                    return;
                }
            }
            while (true) {
                if (scannode < this.DictionarySize) {
                    max = this.level[scannode];
                    matchnode = scannode;
                    matchpos = this.position[scannode];
                } else {
                    max = this.MaxMatch;
                    matchnode = scannode;
                    matchpos = position <= scannode ? scannode - this.DictionarySize : scannode;
                }
                while (matchlen < max && this.TextBuffer[matchpos + matchlen] == this.TextBuffer[position + matchlen]) {
                    ++matchlen;
                }
                if (matchlen != max || matchlen >= this.MaxMatch) break;
                this.position[scannode] = position;
                if ((scannode = this.child(scannode, this.TextBuffer[position + matchlen] & 0xFF)) == 0) {
                    this.attachNode(matchnode, posnode, this.TextBuffer[position + matchlen] & 0xFF);
                    break block13;
                }
                ++matchlen;
            }
            if (matchlen < max) {
                this.splitNode(matchnode, matchpos, posnode, position, matchlen);
            } else {
                this.replaceNode(matchnode, posnode);
                this.next[matchnode] = position;
            }
        }
        this.lastMatchLen = matchlen;
        this.lastMatchPos = matchpos;
    }

    public int searchAndPut(int position) {
        int matchlen;
        int scannode;
        int matchpos;
        block18: {
            int posnode = (position & this.DictionarySize - 1) + this.DictionarySize;
            this.deleteNode(posnode);
            int matchnode = -1;
            matchpos = position;
            scannode = 0;
            matchlen = 0;
            if (3 < this.lastMatchLen) {
                scannode = this.lastMatchPos + 1 | this.DictionarySize;
                while (this.parent[scannode] == 0) {
                    scannode = this.next[scannode];
                }
                int node = this.parent[scannode];
                --this.lastMatchLen;
                while (node > 0 && this.lastMatchLen <= this.level[node]) {
                    scannode = node;
                    node = this.parent[node];
                }
                while (node > 0) {
                    this.position[node] = position;
                    node = this.parent[node];
                }
                matchlen = this.lastMatchLen;
            } else {
                scannode = this.child(this.TextBuffer[position] - 128, this.TextBuffer[position + 1] & 0xFF);
                matchlen = 2;
            }
            if (scannode != 0) {
                int max;
                while (true) {
                    if (scannode < this.DictionarySize) {
                        max = this.level[scannode];
                        matchnode = scannode;
                        matchpos = this.position[scannode];
                    } else {
                        max = this.MaxMatch;
                        matchnode = scannode;
                        matchpos = position <= scannode ? scannode - this.DictionarySize : scannode;
                    }
                    while (matchlen < max && this.TextBuffer[matchpos + matchlen] == this.TextBuffer[position + matchlen]) {
                        ++matchlen;
                    }
                    if (matchlen != max || matchlen >= this.MaxMatch) break;
                    this.position[scannode] = position;
                    if ((scannode = this.child(scannode, this.TextBuffer[position + matchlen] & 0xFF)) == 0) {
                        this.attachNode(matchnode, posnode, this.TextBuffer[position + matchlen] & 0xFF);
                        break block18;
                    }
                    ++matchlen;
                }
                if (matchlen < max) {
                    this.splitNode(matchnode, matchpos, posnode, position, matchlen);
                } else {
                    this.replaceNode(matchnode, posnode);
                    this.next[matchnode] = position;
                }
            } else {
                this.attachNode(this.TextBuffer[position] - 128, posnode, this.TextBuffer[position + 1] & 0xFF);
                matchlen = 0;
            }
        }
        this.lastMatchLen = matchlen;
        this.lastMatchPos = matchpos;
        scannode = position - this.DictionarySize;
        if (this.DictionaryLimit <= scannode) {
            int len = 0;
            while (this.TextBuffer[scannode + len] == this.TextBuffer[position + len]) {
                if (this.MaxMatch <= ++len) break;
            }
            if (matchlen < len) {
                matchpos = scannode;
                matchlen = len;
            }
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public int search(int position, int lastPutPos) {
        int scanlimit = Math.max(this.DictionaryLimit, lastPutPos);
        int scanpos = position - 1;
        int matchlen = 0;
        int matchpos = 0;
        byte[] buf = this.TextBuffer;
        int max = Math.min(this.TextBuffer.length, position + this.MaxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        while (scanlimit < scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max <= ++p) break;
            }
            if (matchlen < (len = p - position)) {
                matchpos = scanpos;
                matchlen = len;
                if (max <= p) break;
            }
            --scanpos;
        }
        if (2 < this.TextBuffer.length - position) {
            int matchnode = this.child(this.TextBuffer[position] - 128, this.TextBuffer[position + 1] & 0xFF);
            scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
            len = 2;
            while (matchnode != 0) {
                int maxlen;
                if (matchnode < this.DictionarySize) {
                    maxlen = this.level[matchnode];
                    scanpos = this.position[matchnode];
                } else {
                    maxlen = this.MaxMatch;
                    int n = scanpos = lastPutPos < matchnode ? matchnode - this.DictionarySize : matchnode;
                }
                if (scanlimit > scanpos) break;
                max = Math.min(this.TextBuffer.length, position + maxlen);
                s = scanpos + len;
                p = position + len;
                if (p < max) {
                    while (buf[s] == buf[p]) {
                        ++s;
                        if (max <= ++p) break;
                    }
                }
                if (matchlen < (len = p - position)) {
                    matchpos = scanpos;
                    matchlen = len;
                }
                if (len != maxlen || matchlen >= this.MaxMatch || position + len >= this.TextBuffer.length) break;
                if ((matchnode = this.child(matchnode, this.TextBuffer[position + len] & 0xFF)) == 0) continue;
                ++len;
            }
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public void slide() {
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        this.lastMatchPos -= this.DictionarySize;
        int i = 0;
        while (i < this.position.length) {
            int pos = this.position[i] - this.DictionarySize;
            this.position[i] = pos > 0 ? pos : 0;
            ++i;
        }
    }

    public int putRequires() {
        return this.MaxMatch;
    }

    private void splitNode(int oldnode, int oldpos, int posnode, int position, int splitLen) {
        int newnode = this.avail;
        this.avail = this.next[newnode];
        this.replaceNode(oldnode, newnode);
        this.level[newnode] = splitLen;
        this.position[newnode] = position;
        this.childnum[newnode] = 0;
        this.attachNode(newnode, oldnode, this.TextBuffer[oldpos + splitLen] & 0xFF);
        this.attachNode(newnode, posnode, this.TextBuffer[position + splitLen] & 0xFF);
    }

    private void deleteNode(int node) {
        if (this.parent[node] != 0) {
            int parent = this.parent[node];
            int prev = this.prev[node];
            int next = this.next[node];
            this.parent[node] = 0;
            this.prev[node] = 0;
            this.next[node] = 0;
            if (prev >= 0) {
                this.next[prev] = next;
            } else {
                this.hashTable[prev ^ 0xFFFFFFFF] = next;
            }
            this.prev[next] = prev;
            if (parent > 0) {
                int n = parent;
                this.childnum[n] = this.childnum[n] - 1;
                if (this.childnum[parent] <= 1) {
                    this.contractNode(this.child(parent, this.TextBuffer[this.position[parent] + this.level[parent]] & 0xFF));
                }
            }
        }
    }

    private void attachNode(int parentnode, int childnode, int ch) {
        int hash = this.hash(parentnode, ch);
        int node = this.hashTable[hash];
        this.hashTable[hash] = childnode;
        this.parent[childnode] = parentnode;
        this.prev[childnode] = ~hash;
        this.next[childnode] = node;
        this.prev[node] = childnode;
        if (parentnode > 0) {
            int n = parentnode;
            this.childnum[n] = this.childnum[n] + 1;
        }
    }

    private void replaceNode(int oldnode, int newnode) {
        this.parent[newnode] = this.parent[oldnode];
        this.prev[newnode] = this.prev[oldnode];
        this.next[newnode] = this.next[oldnode];
        this.prev[this.next[newnode]] = newnode;
        if (this.prev[newnode] < 0) {
            this.hashTable[this.prev[newnode] ^ 0xFFFFFFFF] = newnode;
        } else {
            this.next[this.prev[newnode]] = newnode;
        }
        this.parent[oldnode] = 0;
        this.prev[oldnode] = 0;
        this.next[oldnode] = 0;
    }

    private void contractNode(int node) {
        int parentnode = this.parent[node];
        this.prev[this.next[node]] = this.prev[node];
        if (this.prev[node] >= 0) {
            this.next[this.prev[node]] = this.next[node];
        } else {
            this.hashTable[this.prev[node] ^ 0xFFFFFFFF] = this.next[node];
        }
        this.replaceNode(parentnode, node);
        this.next[parentnode] = this.avail;
        this.avail = parentnode;
    }

    private void slideTree(int[] src, int[] dst, int width) {
        int i = 0;
        while (i < this.DictionarySize) {
            dst[i] = src[i] < this.DictionarySize ? src[i] : (src[i] - width & this.DictionarySize - 1) + this.DictionarySize;
            ++i;
        }
        i = this.DictionarySize;
        while (i < src.length) {
            dst[(i - width & this.DictionarySize - 1) + this.DictionarySize] = src[i] < this.DictionarySize ? src[i] : (src[i] - width & this.DictionarySize - 1) + this.DictionarySize;
            ++i;
        }
    }

    private int child(int parent, int ch) {
        int node = this.hashTable[this.hash(parent, ch)];
        while (node != 0 && this.parent[node] != parent) {
            node = this.next[node];
        }
        return node;
    }

    private int hash(int node, int ch) {
        return (node + (ch << this.shift) + 256) % this.hashTable.length;
    }

    private static int generateProbablePrime(int num) {
        num += (num & 1) == 0 ? 1 : 0;
        while (!new BigInteger(Integer.toString(num)).isProbablePrime(8)) {
            num += (num += (num += (num += 2) % 3 == 0 ? 2 : 0) % 5 == 0 ? 2 : 0) % 7 == 0 ? 2 : 0;
        }
        return num;
    }
}

