/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.setup.bean.InitialAccountCreateBeanInterface;
import jp.mosp.setup.dto.InitialAccountParameterInterface;
import jp.mosp.setup.dto.impl.InitialAccountParameter;

public class InitialAccountCreateBean
extends PlatformBean
implements InitialAccountCreateBeanInterface {
    public void initBean() {
    }

    public InitialAccountParameterInterface getInitParameter() {
        return new InitialAccountParameter();
    }

    public void execute(InitialAccountParameterInterface parameter) throws MospException {
        this.insertHuman(parameter);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String personalId = this.getPersonalId(parameter);
        if (personalId.isEmpty()) {
            return;
        }
        this.insertEntrance(parameter, personalId);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.insertUser(parameter, personalId);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected void insertHuman(InitialAccountParameterInterface parameter) throws MospException {
        HumanRegistBeanInterface register = (HumanRegistBeanInterface)this.createBean(HumanRegistBeanInterface.class);
        HumanDtoInterface dto = register.getInitDto();
        dto.setActivateDate(this.getActivateDate(parameter));
        dto.setEmployeeCode(parameter.getEmployeeCode());
        dto.setLastName(parameter.getLastName());
        dto.setFirstName(parameter.getFirstName());
        dto.setLastKana(parameter.getLastKana());
        dto.setFirstKana(parameter.getFirstKana());
        dto.setWorkPlaceCode("");
        dto.setEmploymentContractCode("");
        dto.setSectionCode("");
        dto.setPositionCode("");
        dto.setMail("");
        register.insert(dto);
    }

    protected String getPersonalId(InitialAccountParameterInterface parameter) throws MospException {
        HumanReferenceBeanInterface human = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        return human.getPersonalId(parameter.getEmployeeCode(), this.getActivateDate(parameter));
    }

    protected void insertEntrance(InitialAccountParameterInterface parameter, String personalId) throws MospException {
        EntranceRegistBeanInterface register = (EntranceRegistBeanInterface)this.createBean(EntranceRegistBeanInterface.class);
        EntranceDtoInterface dto = register.getInitDto();
        dto.setEntranceDate(parameter.getEntranceDate());
        dto.setPersonalId(personalId);
        register.insert(dto);
    }

    protected void insertUser(InitialAccountParameterInterface parameter, String personalId) throws MospException {
        UserMasterRegistBeanInterface userMasterRegist = (UserMasterRegistBeanInterface)this.createBean(UserMasterRegistBeanInterface.class);
        UserMasterDtoInterface dto = userMasterRegist.getInitDto();
        String userId = parameter.getUserId();
        dto.setUserId(userId);
        dto.setActivateDate(this.getActivateDate(parameter));
        dto.setPersonalId(personalId);
        dto.setRoleCode(parameter.getRoleCode());
        dto.setInactivateFlag(0);
        userMasterRegist.insert(dto);
        this.initPassword(parameter);
    }

    protected void initPassword(InitialAccountParameterInterface parameter) throws MospException {
        UserPasswordRegistBeanInterface userPasswordRegist = (UserPasswordRegistBeanInterface)this.createBean(UserPasswordRegistBeanInterface.class);
        UserPasswordDtoInterface dto = userPasswordRegist.getInitDto();
        dto.setChangeDate(this.getActivateDate(parameter));
        String userId = parameter.getUserId();
        dto.setUserId(userId);
        PasswordCheckBeanInterface passwordCheck = (PasswordCheckBeanInterface)this.createBean(PasswordCheckBeanInterface.class);
        String initialPassword = passwordCheck.getInitialPassword(userId);
        dto.setPassword(SeUtility.encrypt((String)SeUtility.encrypt((String)initialPassword)));
        userPasswordRegist.regist(dto);
    }

    protected Date getActivateDate(InitialAccountParameterInterface parameter) {
        Date entranceDate = parameter.getEntranceDate();
        Date systemDate = DateUtility.getSystemDate();
        Date activateDate = parameter.getActivateDate();
        if (activateDate != null) {
            return activateDate;
        }
        if (systemDate.compareTo(entranceDate) < 0) {
            return systemDate;
        }
        return entranceDate;
    }

    protected void addInsertFailedMessage() {
        String[] aryMeassage = new String[]{this.mospParams.getName("Insert")};
        this.mospParams.addMessage("PFI0002", aryMeassage);
    }
}

