/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.bean.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.bean.system.UserMasterSearchBeanInterface;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.setup.base.ConnectionXmlManager;
import jp.mosp.setup.base.DbSetUpException;
import jp.mosp.setup.bean.InitialAccountCreateBeanInterface;
import jp.mosp.setup.bean.impl.DbSetUpManagement;
import jp.mosp.setup.constant.Command;
import jp.mosp.setup.constant.SetUpStatus;
import jp.mosp.setup.dto.DbSetUpParameterInterface;
import jp.mosp.setup.dto.InitialAccountParameterInterface;
import jp.mosp.setup.dto.impl.DbSetUpParameter;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbSetUpManagement {
    private MospParams mospParams;
    private DbSetUpParameterInterface parameter;

    DbSetUpManagement() {
    }

    public void setMospParams(MospParams mospParams) {
        this.mospParams = mospParams;
    }

    public void setParameter(DbSetUpParameterInterface parameter) {
        this.parameter = parameter;
    }

    private DbSetUpManagement(MospParams mospParams, DbSetUpParameterInterface parameter) {
        this.mospParams = mospParams;
        this.parameter = parameter;
    }

    public static DbSetUpManagement getInstance(MospParams mospParams, DbSetUpParameterInterface parameter) {
        return new DbSetUpManagement(mospParams, parameter);
    }

    public static DbSetUpParameterInterface initParameter(MospParams mospParams) {
        DbSetUpParameter parameter = new DbSetUpParameter();
        parameter.setServerName(mospParams.getApplicationProperty("DefaultServerName"));
        parameter.setPort(mospParams.getApplicationProperty("DefaultPort", 5432));
        parameter.setPostgresDb(mospParams.getApplicationProperty("PostgresDataBase"));
        parameter.setSuperUser(mospParams.getApplicationProperty("SuperUserName"));
        parameter.setSuperPassword(mospParams.getApplicationProperty("SuperUserPassword"));
        parameter.setDefaultDbUser(mospParams.getApplicationProperty("DefaultDbUser"));
        parameter.setDirs(mospParams.getApplicationProperties("SetUpDatabase"));
        parameter.setRoleCode(mospParams.getApplicationProperty("InitUserRoleCode"));
        parameter.setCommand(Command.DEFAULT);
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetUpStatus confirm() {
        SuperUserManager manager = null;
        try {
            if (this.parameter != null) {
                manager = this.createManager(this.parameter);
                SetUpStatus setUpStatus = SetUpStatus.NULL;
                return setUpStatus;
            }
            manager = this.createManager();
            if (this.confirmAccount(manager.getConnection())) {
                SetUpStatus setUpStatus = SetUpStatus.ALREADY;
                return setUpStatus;
            }
            SetUpStatus setUpStatus = SetUpStatus.EMPTY;
            return setUpStatus;
        }
        catch (DbSetUpException e) {
            this.mospParams.addErrorMessage("SUE001", new String[0]);
            if (this.parameter != null) {
                SetUpStatus setUpStatus = SetUpStatus.ERROR;
                return setUpStatus;
            }
            SetUpStatus setUpStatus = SetUpStatus.NULL;
            return setUpStatus;
        }
        catch (MospException e) {
            if (manager != null) {
                manager.release();
            }
            SetUpStatus setUpStatus = SetUpStatus.EMPTY;
            return setUpStatus;
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
    }

    public void execute() throws MospException {
        this.validate();
        SqlHolder holder = this.loadFiles();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        SuperUserManager manager = null;
        try {
            this.checkDuplicate();
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            manager = this.createManager(this.parameter);
            manager.create(this.parameter);
            this.prepareTable(holder);
            this.initialize(new boolean[0]);
            if (this.mospParams.hasErrorMessage()) {
                manager.destory(this.parameter);
            }
        }
        catch (MospException e) {
            if (manager != null) {
                manager.destory(this.parameter);
                manager.release();
            }
            throw e;
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
    }

    public void createDataBase() throws MospException {
        this.checkRequired();
        SqlHolder holder = this.loadFiles();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.createConnectionXml();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        SuperUserManager manager = null;
        try {
            this.checkDuplicate();
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            manager = this.createManager(this.parameter);
            manager.create(this.parameter);
            this.prepareTable(holder);
        }
        catch (MospException e) {
            if (manager != null) {
                manager.destory(this.parameter);
                manager.release();
            }
            throw e;
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
        this.loadConnectionXml();
    }

    public void createXml() throws MospException {
        this.createConnectionXml();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.loadConnectionXml();
    }

    public void dropDatabase() throws MospException {
        this.checkRequired();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        SuperUserManager manager = null;
        try {
            manager = this.createManager(this.parameter);
            manager.destory(this.parameter);
        }
        catch (MospException e) {
            throw e;
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
    }

    public void initialize(boolean ... individual) throws MospException {
        boolean isIndividual = individual != null && individual.length > 0 && individual[0];
        this.parameter.setCommand(Command.AS_SUPER);
        SuperUserManager manager = null;
        try {
            manager = isIndividual ? this.createManager() : this.createManager(this.parameter);
            manager.setAutoCommit(false);
            Connection connection = manager.getConnection();
            InitialAccountCreateBeanInterface create = (InitialAccountCreateBeanInterface)this.loadBean(InitialAccountCreateBeanInterface.class, connection);
            InitialAccountParameterInterface accountParameter = create.getInitParameter();
            accountParameter.setUserId(this.parameter.getUserId());
            accountParameter.setEmployeeCode(this.parameter.getEmployeeCode());
            accountParameter.setLastName(this.parameter.getLastName());
            accountParameter.setFirstName(this.parameter.getFirstName());
            accountParameter.setLastKana(this.parameter.getLastKana());
            accountParameter.setFirstKana(this.parameter.getFirstKana());
            accountParameter.setEntranceDate(this.parameter.getEntranceDate());
            accountParameter.setActivateDate(this.parameter.getActivateDate());
            accountParameter.setRoleCode(this.parameter.getRoleCode());
            create.execute(accountParameter);
            if (this.mospParams.hasErrorMessage()) {
                this.addInsertFailedMessage();
                manager.release();
                return;
            }
            manager.commit();
        }
        catch (MospException e) {
            throw e;
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
    }

    protected void prepareTable(SqlHolder holder) throws MospException {
        this.parameter.setCommand(Command.AS_SUPER);
        SuperUserManager manager = null;
        try {
            manager = this.createManager(this.parameter);
            manager.setAutoCommit(false);
            manager.executeBatch(holder.getQueryList());
            manager.grant(holder.getGrantList(), this.parameter.getDefaultDbUser(), this.parameter.getUserName());
            manager.commit();
        }
        catch (DbSetUpException e) {
            throw new MospException(e.getCause());
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
    }

    protected SuperUserManager createManager(DbSetUpParameterInterface parameter) {
        Command command;
        String password;
        int port;
        String driver = this.mospParams.getApplicationProperty("DbDriver");
        String serverName = parameter.getServerName();
        if (serverName == null || serverName.isEmpty()) {
            serverName = this.mospParams.getApplicationProperty("DefaultServerName");
        }
        if ((port = parameter.getPort()) == 0) {
            port = this.mospParams.getApplicationProperty("DefaultPort", 5432);
        }
        String url = MessageFormat.format(this.mospParams.getApplicationProperty("DatabaseUrlPattern"), serverName, String.valueOf(port));
        String dbName = parameter.getPostgresDb();
        String user = parameter.getSuperUser();
        if (user == null || user.isEmpty()) {
            user = this.mospParams.getApplicationProperty("SuperUserName");
        }
        if ((password = parameter.getSuperPassword()) == null || password.isEmpty()) {
            password = this.mospParams.getApplicationProperty("SuperUserPassword");
        }
        if (Command.AS_USER.equals((Object)(command = parameter.getCommand()))) {
            dbName = parameter.getDbName();
            user = parameter.getUserName();
            password = parameter.getUserPassword();
        }
        if (Command.AS_SUPER.equals((Object)command)) {
            dbName = parameter.getDbName();
        }
        return SuperUserManager.getInstance((MospParams)this.mospParams, (String)driver, (String)url, (String)dbName, (String)user, (String)password);
    }

    protected SuperUserManager createManager() {
        String driver = this.mospParams.getApplicationProperty("DbDriver");
        String url = this.mospParams.getApplicationProperty("DbUrl");
        String dbName = "";
        String user = this.mospParams.getApplicationProperty("DbUser");
        String password = this.mospParams.getApplicationProperty("DbPass");
        return SuperUserManager.getInstance((MospParams)this.mospParams, (String)driver, (String)url, (String)dbName, (String)user, (String)password);
    }

    protected void checkDuplicate() throws MospException {
        SuperUserManager manager = null;
        try {
            manager = this.createManager(this.parameter);
            Set set = manager.checkDuplicate(this.parameter);
            for (String key : set) {
                this.mospParams.addErrorMessage("SUE005", new String[]{this.mospParams.getName(key)});
            }
        }
        catch (DbSetUpException e) {
            throw new MospException(e.getCause());
        }
        catch (MospException e) {
            throw new MospException(e.getCause());
        }
        finally {
            if (manager != null) {
                manager.release();
            }
        }
    }

    protected void validate() {
        this.checkRequired();
        this.checkLength();
        this.checkCharacterType();
    }

    protected void checkRequired() {
        String[] repServerName = new String[]{this.mospParams.getName("Server")};
        InputCheckUtility.checkRequired((String)this.parameter.getServerName(), (String[])repServerName, (MospParams)this.mospParams);
        String[] repSuperUserPassword = new String[]{this.mospParams.getName("PosgrePass")};
        InputCheckUtility.checkRequired((String)this.parameter.getSuperPassword(), (String[])repSuperUserPassword, (MospParams)this.mospParams);
        String[] repDbName = new String[]{this.mospParams.getName("DbName")};
        InputCheckUtility.checkRequired((String)this.parameter.getDbName(), (String[])repDbName, (MospParams)this.mospParams);
        String[] repUserName = new String[]{this.mospParams.getName("RoleName")};
        String userName = this.parameter.getUserName();
        InputCheckUtility.checkRequired((String)userName, (String[])repUserName, (MospParams)this.mospParams);
        if ("user".equals(userName) || "role".equals(userName)) {
            this.mospParams.addErrorMessage("SUE004", new String[0]);
        }
        String[] repUserPassword = new String[]{this.mospParams.getName("RolePass")};
        InputCheckUtility.checkRequired((String)this.parameter.getUserPassword(), (String[])repUserPassword, (MospParams)this.mospParams);
        this.checkSQLInjection();
    }

    protected void checkSQLInjection() {
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Pattern pattern = Pattern.compile("'+|--|;+|\\\\+");
        String[] repDbName = new String[]{this.mospParams.getName("DbName")};
        if (pattern.matcher(this.parameter.getDbName()).find()) {
            this.mospParams.addErrorMessage("SUW002", repDbName);
        }
        String[] repUserName = new String[]{this.mospParams.getName("RoleName")};
        if (pattern.matcher(this.parameter.getUserName()).find()) {
            this.mospParams.addErrorMessage("SUW002", repUserName);
        }
        String[] repUserPassword = new String[]{this.mospParams.getName("RolePass")};
        if (pattern.matcher(this.parameter.getUserPassword()).find()) {
            this.mospParams.addErrorMessage("SUW002", repUserPassword);
        }
    }

    protected void checkLength() {
        String userId = this.mospParams.getName("MospLoginUser");
        InputCheckUtility.checkLength((String)this.parameter.getUserId(), (int)50, (String)userId, (MospParams)this.mospParams);
        String employeeCode = this.mospParams.getName("Employee", new String[]{"Code"});
        InputCheckUtility.checkLength((String)this.parameter.getEmployeeCode(), (int)10, (String)employeeCode, (MospParams)this.mospParams);
        String lastName = this.mospParams.getName("LastName");
        InputCheckUtility.checkLength((String)this.parameter.getLastName(), (int)50, (String)lastName, (MospParams)this.mospParams);
        String firstName = this.mospParams.getName("FirstName");
        InputCheckUtility.checkLength((String)this.parameter.getFirstName(), (int)50, (String)firstName, (MospParams)this.mospParams);
        String lastKana = this.mospParams.getName("LastName", new String[]{"FrontParentheses", "Kana", "BackParentheses"});
        InputCheckUtility.checkLength((String)this.parameter.getLastKana(), (int)50, (String)lastKana, (MospParams)this.mospParams);
        String firstKana = this.mospParams.getName("FirstName", new String[]{"FrontParentheses", "Kana", "BackParentheses"});
        InputCheckUtility.checkLength((String)this.parameter.getFirstKana(), (int)50, (String)firstKana, (MospParams)this.mospParams);
    }

    protected void checkCharacterType() {
        String[] repUserId = new String[]{this.mospParams.getName("MospLoginUser")};
        if (!ValidateUtility.chkRegex((String)"[._@A-Za-z0-9-]*", (String)this.parameter.getUserId())) {
            this.mospParams.addErrorMessage("PFW0125", repUserId);
        }
        String[] repEmployeeCode = new String[]{this.mospParams.getName("Employee", new String[]{"Code"})};
        InputCheckUtility.checkCode((String)this.parameter.getEmployeeCode(), (String[])repEmployeeCode, (MospParams)this.mospParams);
    }

    protected SqlHolder loadFiles() {
        File sql = new File(this.mospParams.getApplicationProperty("Docbase"), "sql");
        ArrayList<File> dirList = new ArrayList<File>();
        dirList.add(sql);
        for (String childName : this.parameter.getDirs()) {
            File child = new File(sql, childName);
            if (!child.exists() || !child.isDirectory()) continue;
            dirList.add(child);
        }
        LinkedList queryList = new LinkedList();
        LinkedList grantList = new LinkedList();
        for (File dir : dirList) {
            File[] sqlFiles = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            queryList.addAll(this.parse(sqlFiles));
            File[] grantFiles = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            grantList.addAll(this.parse(grantFiles));
        }
        return new SqlHolder(queryList, grantList);
    }

    protected List<String> parse(File ... files) {
        LinkedList<String> list = new LinkedList<String>();
        for (File sql : files) {
            List queryList = this.trim(sql);
            if (queryList.isEmpty()) {
                this.mospParams.addErrorMessage("FWE9122", new String[0]);
                continue;
            }
            list.addAll(queryList);
        }
        return list;
    }

    protected void createConnectionXml() {
        File xml = new File(this.mospParams.getApplicationProperty("Docbase"), "WEB-INF/xml/user/user_connection.xml");
        HashSet<Boolean> overWriteSet = new HashSet<Boolean>();
        if (!xml.exists()) {
            try {
                overWriteSet.add(xml.createNewFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        overWriteSet.add(xml.isFile());
        overWriteSet.add(xml.canWrite());
        if (overWriteSet.contains(Boolean.FALSE)) {
            this.mospParams.addErrorMessage("SUE007", new String[0]);
            return;
        }
        String url = MessageFormat.format(this.mospParams.getApplicationProperty("DatabaseUrlPattern"), this.parameter.getServerName(), String.valueOf(this.parameter.getPort()));
        String dbName = this.parameter.getDbName();
        String user = this.parameter.getUserName();
        String password = this.parameter.getUserPassword();
        try {
            ConnectionXmlManager.export((File)xml, (String)(url + dbName), (String)user, (String)password);
        }
        catch (MospException e) {
            e.printStackTrace();
        }
    }

    protected void loadConnectionXml() throws MospException {
        Map map = ConnectionXmlManager.load((File)new File(this.mospParams.getApplicationProperty("Docbase"), "WEB-INF/xml/user/user_connection.xml"));
        this.mospParams.getProperties().setApplicationProperty("DbUrl", (String)map.get("DbUrl"));
        this.mospParams.getProperties().setApplicationProperty("DbUser", (String)map.get("DbUser"));
        this.mospParams.getProperties().setApplicationProperty("DbPass", (String)map.get("DbPass"));
    }

    protected boolean confirmAccount(Connection connection) throws MospException {
        UserMasterSearchBeanInterface search = (UserMasterSearchBeanInterface)this.loadBean(UserMasterSearchBeanInterface.class, connection);
        search.setUserId("");
        search.setActivateDate(DateUtility.getSystemDate());
        search.setEmployeeCode("");
        search.setEmployeeName("");
        search.setRoleCode(this.mospParams.getApplicationProperty("InitUserRoleCode"));
        search.setInactivateFlag("");
        return !search.getSearchList().isEmpty();
    }

    protected <T> T loadBean(Class<T> cls, Connection connection) throws MospException {
        return (T)InstanceFactory.loadBean(cls, (MospParams)this.mospParams, (Connection)connection);
    }

    protected void addInsertFailedMessage() {
        String[] aryMeassage = new String[]{this.mospParams.getName("Insert")};
        this.mospParams.addMessage("PFI0002", aryMeassage);
    }

    protected List<String> trim(File file) {
        String[] splits;
        List lineList = this.read(file);
        Pattern pattern = Pattern.compile("--+");
        ArrayList<String> mergeList = new ArrayList<String>();
        for (String line : lineList) {
            Matcher matcher = pattern.matcher(line);
            String value = line;
            if (matcher.find()) {
                value = line.substring(0, matcher.start());
            }
            if (value == null || value.isEmpty()) continue;
            mergeList.add(value);
        }
        StringBuffer sb = new StringBuffer();
        for (String value : mergeList) {
            sb.append(value);
        }
        String middle = sb.toString().replaceAll("/\\*([^*]|\\*[^/])*\\*/", "");
        LinkedList<String> queryList = new LinkedList<String>();
        for (String query : splits = Pattern.compile(";").split(middle)) {
            if ((query = query.replaceAll("\\n+", "")).isEmpty()) continue;
            queryList.add(query + ";");
        }
        return queryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> read(File file) {
        BufferedReader reader = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

