/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationSearchBeanInterface;
import jp.mosp.platform.comparator.workflow.ApprovalUnitMasterUnitCodeComparator;
import jp.mosp.platform.comparator.workflow.RouteApplicationMasterApplicationCodeComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.workflow.vo.RouteApplicationListVo;

public class RouteApplicationListAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3310";
    public static final String CMD_SEARCH = "PF3312";
    public static final String CMD_RE_SEARCH = "PF3313";
    public static final String CMD_SORT = "PF3318";
    public static final String CMD_PAGE = "PF3319";
    public static final String CMD_BATCH_UPDATE = "PF3385";

    public RouteApplicationListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new RouteApplicationListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        RouteApplicationListVo vo = (RouteApplicationListVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        this.setDefaultValues();
        vo.setPltSearchFlowType("");
        vo.setTxtSearchApplicationCode("");
        vo.setTxtSearchApplicationName("");
        vo.setTxtSearchApplicationEmployee("");
        vo.setTxtSearchRouteCode("");
        vo.setTxtSearchRouteName("");
        vo.setTxtSearchRouteEmployee("");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ApprovalUnitMasterUnitCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
    }

    protected void search() throws MospException {
        RouteApplicationListVo vo = (RouteApplicationListVo)this.mospParams.getVo();
        RouteApplicationSearchBeanInterface search = this.reference().routeApplicationSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        search.setWorkflowType(vo.getPltSearchFlowType());
        search.setRouteApplicationCode(vo.getTxtSearchApplicationCode());
        search.setRouteApplicationName(vo.getTxtSearchApplicationName());
        search.setEmployeeCode(vo.getTxtSearchApplicationEmployee());
        search.setRouteCode(vo.getTxtSearchRouteCode());
        search.setRouteName(vo.getTxtSearchRouteName());
        search.setApproverEmployeeCode(vo.getTxtSearchRouteEmployee());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(RouteApplicationMasterApplicationCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.isEmpty()) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchUpdate() throws MospException {
        RouteApplicationListVo vo = (RouteApplicationListVo)this.mospParams.getVo();
        PlatformBeanHandlerInterface platform = this.platform();
        platform.routeApplicationRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        RouteApplicationListVo vo = (RouteApplicationListVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblApplicationCode = new String[list.size()];
        String[] aryLblApplicationName = new String[list.size()];
        String[] aryLblRouteName = new String[list.size()];
        String[] aryLblRouteCode = new String[list.size()];
        String[] aryLblFlowType = new String[list.size()];
        String[] aryLblApplicationLength = new String[list.size()];
        String[] aryLblUnitInactivate = new String[list.size()];
        HumanReferenceBeanInterface getHumanInfo = this.reference().human();
        WorkPlaceReferenceBeanInterface getWorkPlaceInfo = this.reference().workPlace();
        EmploymentContractReferenceBeanInterface getEmploymentInfo = this.reference().employmentContract();
        PositionReferenceBeanInterface getPositionInfo = this.reference().position();
        SectionReferenceBeanInterface getSectionInfo = this.reference().section();
        ApprovalRouteReferenceBeanInterface getRouteInfo = this.reference().approvalRoute();
        for (int i = 0; i < list.size(); ++i) {
            RouteApplicationDtoInterface dto = (RouteApplicationDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getPfmRouteApplicationId());
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblApplicationCode[i] = dto.getRouteApplicationCode();
            aryLblApplicationName[i] = dto.getRouteApplicationName();
            aryLblFlowType[i] = this.getFlowTypeName(dto.getWorkflowType());
            aryLblUnitInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
            Date date = dto.getActivateDate();
            aryLblRouteName[i] = getRouteInfo.getRouteName(dto.getRouteCode(), date);
            StringBuffer sb = new StringBuffer();
            if (dto.getRouteApplicationType() == Integer.valueOf("0").intValue()) {
                if (!dto.getWorkPlaceCode().equals("")) {
                    sb.append(getWorkPlaceInfo.getWorkPlaceAbbr(dto.getWorkPlaceCode(), date));
                }
                if (!dto.getEmploymentContractCode().equals("")) {
                    String employmentAbbr = getEmploymentInfo.getContractAbbr(dto.getEmploymentContractCode(), date);
                    if (sb.length() != 0) {
                        sb.append(" ");
                    }
                    sb.append(employmentAbbr);
                }
                if (!dto.getPositionCode().equals("")) {
                    String positionAbbr = getPositionInfo.getPositionAbbr(dto.getPositionCode(), date);
                    if (sb.length() != 0) {
                        sb.append(" ");
                    }
                    sb.append(positionAbbr);
                }
                if (!dto.getSectionCode().equals("")) {
                    String sectionAbbr = getSectionInfo.getSectionAbbr(dto.getSectionCode(), date);
                    if (sb.length() != 0) {
                        sb.append(" ");
                    }
                    sb.append(sectionAbbr);
                }
                aryLblApplicationLength[i] = sb.toString();
            } else {
                String[] aryPersonalCode = dto.getPersonalIds().split(",");
                ArrayList<String> aryEmployeeCode = new ArrayList<String>();
                for (String element : aryPersonalCode) {
                    String employeeCode = getHumanInfo.getEmployeeCode(element, date);
                    if (employeeCode.equals("")) continue;
                    aryEmployeeCode.add(employeeCode);
                }
                Collections.sort(aryEmployeeCode);
                String humanName = "";
                if (!aryEmployeeCode.isEmpty()) {
                    HumanDtoInterface humanDto = getHumanInfo.getHumanInfoForEmployeeCode((String)aryEmployeeCode.get(0), date);
                    humanName = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
                }
                aryLblApplicationLength[i] = humanName;
            }
            aryLblRouteCode[i] = dto.getRouteCode();
        }
        vo.setAryCkbRouteApplicationListId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblApplicationCode(aryLblApplicationCode);
        vo.setAryLblApplicationName(aryLblApplicationName);
        vo.setAryLblRouteName(aryLblRouteName);
        vo.setAryLblRouteCode(aryLblRouteCode);
        vo.setAryLblFlowType(aryLblFlowType);
        vo.setAryLblApplicationLength(aryLblApplicationLength);
        vo.setAryLblInactivate(aryLblUnitInactivate);
    }

    private String getFlowTypeName(int workflowType) {
        for (String[] code : this.mospParams.getProperties().getCodeArray("WorkflowType", false)) {
            if (!code[0].equals(String.valueOf(workflowType))) continue;
            return code[1];
        }
        return "";
    }

    public void setDefaultValues() {
        RouteApplicationListVo vo = (RouteApplicationListVo)this.mospParams.getVo();
        vo.setAryLblActivateDate(new String[0]);
        vo.setAryLblApplicationCode(new String[0]);
        vo.setAryLblApplicationName(new String[0]);
        vo.setAryLblRouteName(new String[0]);
        vo.setAryLblRouteCode(new String[0]);
        vo.setAryLblFlowType(new String[0]);
        vo.setAryLblApplicationLength(new String[0]);
        vo.setAryLblInactivate(new String[0]);
        vo.setAryCkbRecordId(new long[0]);
        vo.setAryCkbRouteApplicationListId(new String[0]);
        vo.setCkbSelect(new String[0]);
    }
}

