/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationRegistBeanInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmRouteApplicationDto;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.workflow.vo.RouteApplicationCardVo;

public class RouteApplicationCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3320";
    public static final String CMD_SELECT_SHOW = "PF3321";
    public static final String CMD_REGIST = "PF3325";
    public static final String CMD_DELETE = "PF3327";
    public static final String CMD_SET_ACTIVATION_DATE = "PF3370";
    public static final String CMD_INSERT_MODE = "PF3371";
    public static final String CMD_ADD_MODE = "PF3373";

    protected BaseVo getSpecificVo() {
        return new RouteApplicationCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo();
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.selectShow();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void selectShow() throws MospException {
        this.editMode();
    }

    protected void regist() throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        RouteApplicationRegistBeanInterface regist = platform.routeApplicationRegist();
        PfmRouteApplicationDto dto = new PfmRouteApplicationDto();
        this.setDtoFields((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        regist.insert((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getRouteApplicationCode(), dto.getActivateDate());
    }

    private void add() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        RouteApplicationRegistBeanInterface regist = platform.routeApplicationRegist();
        PfmRouteApplicationDto dto = new PfmRouteApplicationDto();
        this.setDtoFields((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        regist.add((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getRouteApplicationCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        RouteApplicationRegistBeanInterface regist = platform.routeApplicationRegist();
        PfmRouteApplicationDto dto = new PfmRouteApplicationDto();
        this.setDtoFields((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        regist.update((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getRouteApplicationCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        RouteApplicationRegistBeanInterface regist = platform.routeApplicationRegist();
        PfmRouteApplicationDto dto = new PfmRouteApplicationDto();
        this.setDtoFields((RouteApplicationDtoInterface)dto);
        regist.delete((RouteApplicationDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void addMode() throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        this.setEditAddMode();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    public void setDefaultValues() {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        vo.setTxtApplicationCode("");
        vo.setTxtApplicationName("");
        vo.setPltRouteName("");
        vo.setPltFlowType("");
        vo.setPltWorkPlace("");
        vo.setPltEmployment("");
        vo.setPltSection("");
        vo.setPltPosition("");
        vo.setTxtEmployeeCode("");
        vo.setLblSectionPosition("");
        vo.setRadioSelect("0");
    }

    private void setEditUpdateMode(String routeApplicationCode, Date activateDate) throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        RouteApplicationReferenceBeanInterface reference = this.reference().routeApplication();
        RouteApplicationDtoInterface dto = reference.findForKey(routeApplicationCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(reference.getRouteApplicationHistory(routeApplicationCode));
    }

    private void setDtoFields(RouteApplicationDtoInterface dto) throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setRouteApplicationCode(vo.getTxtApplicationCode());
        dto.setRouteApplicationName(vo.getTxtApplicationName());
        dto.setRouteCode(vo.getPltRouteName());
        dto.setWorkflowType(Integer.valueOf(vo.getPltFlowType()).intValue());
        dto.setInactivateFlag(Integer.valueOf(vo.getPltEditInactivate()).intValue());
        dto.setRouteApplicationType(Integer.valueOf(vo.getRadioSelect()).intValue());
        if (vo.getRadioSelect().equals("0")) {
            dto.setWorkPlaceCode(vo.getPltWorkPlace());
            dto.setEmploymentContractCode(vo.getPltEmployment());
            dto.setSectionCode(vo.getPltSection());
            dto.setPositionCode(vo.getPltPosition());
            dto.setPersonalIds("");
        } else {
            dto.setWorkPlaceCode("");
            dto.setEmploymentContractCode("");
            dto.setSectionCode("");
            dto.setPositionCode("");
            dto.setPersonalIds(this.reference().human().getPersonalIds(vo.getTxtEmployeeCode(), this.getEditActivateDate()));
        }
    }

    private void setVoFields(RouteApplicationDtoInterface dto) throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        HumanReferenceBeanInterface human = this.reference().human();
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtApplicationCode(dto.getRouteApplicationCode());
        vo.setTxtApplicationName(dto.getRouteApplicationName());
        vo.setPltRouteName(dto.getRouteCode());
        vo.setPltFlowType(String.valueOf(dto.getWorkflowType()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setRadioSelect(String.valueOf(dto.getRouteApplicationType()));
        vo.setPltWorkPlace(dto.getWorkPlaceCode());
        vo.setPltEmployment(dto.getEmploymentContractCode());
        vo.setPltSection(dto.getSectionCode());
        vo.setPltPosition(dto.getPositionCode());
        if (vo.getRadioSelect().equals("1")) {
            vo.setTxtEmployeeCode(human.getEmployeeCodes(dto.getPersonalIds(), dto.getActivateDate()));
            vo.setLblSectionPosition(human.getHumanNames(dto.getPersonalIds(), dto.getActivateDate()));
        } else {
            vo.setTxtEmployeeCode("");
            vo.setLblSectionPosition("");
        }
    }

    private void setPulldown() throws MospException {
        RouteApplicationCardVo vo = (RouteApplicationCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltRouteName(this.getInputActivateDatePulldown());
            vo.setAryPltWorkPlace(this.getInputActivateDatePulldown());
            vo.setAryPltEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSectionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltPositionMaster(this.getInputActivateDatePulldown());
        } else {
            Date date = this.getEditActivateDate();
            String[][] aryRouteName = this.reference().approvalRoute().getCodedSelectArray(date, true);
            vo.setAryPltRouteName(aryRouteName);
            String[][] aryWorkPlace = this.reference().workPlace().getCodedSelectArray(date, true, null);
            vo.setAryPltWorkPlace(aryWorkPlace);
            String[][] aryEmployment = this.reference().employmentContract().getCodedSelectArray(date, true, null);
            vo.setAryPltEmployment(aryEmployment);
            String[][] arySection = this.reference().section().getCodedSelectArray(date, true, null);
            vo.setAryPltSectionMaster(arySection);
            String[][] aryPosition = this.reference().position().getCodedSelectArray(date, true, null);
            vo.setAryPltPositionMaster(aryPosition);
        }
    }
}

