/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MainMenuProperty;
import jp.mosp.framework.property.MenuProperty;
import jp.mosp.framework.property.RoleMenuProperty;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.platform.base.PlatformVo;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlatformUtility {
    public static final String NAM_UPPER_TRIANGULAR = "UpperTriangular";
    public static final String NAM_LOWER_TRIANGULAR = "LowerTriangular";

    private PlatformUtility() {
    }

    public static String getSortMark(String sortKey, MospParams mospParams) {
        PlatformVo vo = (PlatformVo)mospParams.getVo();
        if (!sortKey.equals(vo.getComparatorName())) {
            return "";
        }
        if (vo.isAscending()) {
            return mospParams.getName("UpperTriangular");
        }
        return mospParams.getName("LowerTriangular");
    }

    public static Set<String> getApproverRoleSet(MospParams mospParams) {
        HashSet<String> approverRoleSet = new HashSet<String>();
        Map map = mospParams.getProperties().getRoleProperties();
        for (Map.Entry entry : map.entrySet()) {
            if (!((RoleProperty)entry.getValue()).isApprover()) continue;
            approverRoleSet.add((String)entry.getKey());
        }
        return approverRoleSet;
    }

    public static Set<String> getPersonalIdSet(List<? extends PersonalIdDtoInterface> list) {
        HashSet<String> set = new HashSet<String>();
        for (PersonalIdDtoInterface personalIdDtoInterface : list) {
            set.add(personalIdDtoInterface.getPersonalId());
        }
        return set;
    }

    public static boolean isTheMenuValid(MospParams mospParams, String mainMenuKey, String menuKey) {
        MainMenuProperty mainMenu = (MainMenuProperty)mospParams.getProperties().getMainMenuProperties().get(mainMenuKey);
        if (mainMenu == null) {
            return false;
        }
        MenuProperty menu = (MenuProperty)mainMenu.getMenuMap().get(menuKey);
        if (menu == null) {
            return false;
        }
        return menu.isMenuValid();
    }

    public static boolean isTheMenuAvailable(MospParams mospParams, String mainMenuKey, String menuKey) {
        if (!PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)mainMenuKey, (String)menuKey)) {
            return false;
        }
        RoleProperty role = mospParams.getUserRole();
        if (role == null) {
            return false;
        }
        RoleMenuProperty roleMenu = (RoleMenuProperty)role.getRoleMenuMap().get(menuKey);
        return roleMenu != null;
    }

    public static boolean isFlagOff(int flag) {
        return flag == 0;
    }

    public static boolean isFlagOn(int flag) {
        return flag == 1;
    }

    public static boolean isForwardMatch(String condition, String value) {
        return value.startsWith(condition);
    }

    public static boolean isBackwardMatch(String condition, String value) {
        return value.endsWith(condition);
    }

    public static boolean isBroadMatch(String condition, String value) {
        return value.indexOf(condition) >= 0;
    }

    public static boolean isExactMatch(String condition, String value) {
        return value.equals(condition);
    }
}

