/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Date;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.ValidateUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputCheckUtility {
    private InputCheckUtility() {
    }

    public static void checkRequired(String targetValue, String[] targetRep, MospParams mospParams) {
        String reqValue = targetValue;
        if (reqValue == null) {
            reqValue = "";
        }
        if (!ValidateUtility.chkRequired((Object)reqValue)) {
            mospParams.addErrorMessage("PFW0102", targetRep);
        }
    }

    public static void checkNumber(String targetValue, String[] targetRep, MospParams mospParams) {
        String reqValue = targetValue;
        if (reqValue == null) {
            reqValue = "0";
        }
        if (!InputCheckUtility.chkNumber((String)reqValue)) {
            mospParams.addErrorMessage("PFW0105", targetRep);
        }
    }

    public static void checkCode(String targetValue, String[] targetRep, MospParams mospParams) {
        String reqValue = targetValue;
        if (reqValue == null) {
            reqValue = "";
        }
        if (!InputCheckUtility.chkCode((String)reqValue)) {
            mospParams.addErrorMessage("PFW0105", targetRep);
        }
    }

    public static void checkDate(int year, int month, int day, String[] targetRep, MospParams mospParams) {
        if (!ValidateUtility.chkDate((int)year, (int)(month - 1), (int)day)) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkDate(String year, String month, String day, String[] targetRep, MospParams mospParams) {
        try {
            InputCheckUtility.checkDate((int)Integer.parseInt(year), (int)Integer.parseInt(month), (int)Integer.parseInt(day), (String[])targetRep, (MospParams)mospParams);
        }
        catch (NumberFormatException e) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkTime(int hour, int minute, int second, String[] targetRep, MospParams mospParams) {
        if (!ValidateUtility.chkTime((int)hour, (int)minute, (int)second)) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkTerm(Date date, Date startDate, Date endDate, String[] targetRep, MospParams mospParams) {
        if (!ValidateUtility.chkTerm((Date)date, (Date)startDate, (Date)endDate)) {
            mospParams.addErrorMessage("PFW0104", targetRep);
        }
    }

    public static void checkLength(String value, int maxLength, String targetName, MospParams mospParams) {
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            String[] rep = new String[]{targetName, String.valueOf(maxLength)};
            mospParams.addErrorMessage("PFW0106", rep);
        }
    }

    private static boolean chkCode(String value) {
        return ValidateUtility.chkRegex((String)"\\w*", (String)value);
    }

    private static boolean chkNumber(String value) {
        return ValidateUtility.chkRegex((String)"\\d*", (String)value);
    }
}

