/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.system.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.system.NamingRegistBeanInterface;
import jp.mosp.platform.bean.system.NamingSearchBeanInterface;
import jp.mosp.platform.comparator.base.NamingItemCodeComparator;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.vo.NamingMasterVo;

public class NamingMasterAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF2620";
    public static final String CMD_SEARCH = "PF2622";
    public static final String CMD_REGIST = "PF2625";
    public static final String CMD_DELETE = "PF2627";
    public static final String CMD_SORT = "PF2628";
    public static final String CMD_PAGE = "PF2629";
    public static final String CMD_INSERT_MODE = "PF2631";
    public static final String CMD_EDIT_MODE = "PF2632";
    public static final String CMD_ADD_MODE = "PF2633";
    public static final String CMD_BATCH_UPDATE = "PF2635";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    private void show() throws MospException {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        vo.setStringNamingType(this.getCodeName(this.getTransferredType(), "NamingType"));
        vo.setCodeNamingType(this.getCodeItemCode(this.getTransferredType(), "NamingType"));
        vo.setShowCommand(this.mospParams.getCommand());
        if (vo.getShowCommand().equals(CMD_SHOW)) {
            TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)(vo.getStringNamingType() + this.mospParams.getName("Master")));
        }
        this.initPlatformSystemVoFields();
        vo.setTxtSearchNamingItemCode("");
        vo.setTxtSearchNamingItemAbbr("");
        vo.setTxtSearchNamingItemName("");
        this.insertMode();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(NamingItemCodeComparator.class.getName());
    }

    private void search() throws MospException {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        NamingSearchBeanInterface search = this.reference().namingSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setNamingType(vo.getCodeNamingType());
        search.setNamingItemCode(vo.getTxtSearchNamingItemCode());
        search.setNamingItemName(vo.getTxtSearchNamingItemName());
        search.setNamingItemAbbr(vo.getTxtSearchNamingItemAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(NamingItemCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    private void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    private void regist() throws MospException {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        NamingRegistBeanInterface regist = this.platform().namingRegist();
        NamingDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getNamingType(), dto.getNamingItemCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        NamingRegistBeanInterface regist = this.platform().namingRegist();
        NamingDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getNamingType(), dto.getNamingItemCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        NamingRegistBeanInterface regist = this.platform().namingRegist();
        NamingDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getNamingType(), dto.getNamingItemCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    private void delete() throws MospException {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.platform().namingRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.insertMode();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        this.platform().namingRegist().update(this.getIdArray(vo.getCkbSelect()), vo.getCodeNamingType(), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    private void insertMode() {
        this.setEditInsertMode();
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        vo.setTxtEditNamingItemCode("");
        vo.setTxtEditNamingItemAbbr("");
        vo.setTxtEditNamingItemName("");
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void editMode() throws MospException {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        this.setEditUpdateMode(vo.getCodeNamingType(), this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String namingType, String namingItemCode, Date activateDate) throws MospException {
        NamingDtoInterface dto = this.reference().naming().findForKey(namingType, namingItemCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(this.reference().naming().getNamingItemHistory(namingType, namingItemCode));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblNamingItemCode = new String[list.size()];
        String[] aryLblNamingItemName = new String[list.size()];
        String[] aryLblNamingItemAbbr = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            NamingDtoInterface dto = (NamingDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getPfmNamingId();
            aryLblNamingItemCode[i] = dto.getNamingItemCode();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblNamingItemName[i] = dto.getNamingItemName();
            aryLblNamingItemAbbr[i] = dto.getNamingItemAbbr();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblNamingItemCode(aryLblNamingItemCode);
        vo.setAryLblNamingItemName(aryLblNamingItemName);
        vo.setAryLblNamingItemAbbr(aryLblNamingItemAbbr);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void setDtoFields(NamingDtoInterface dto) {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        dto.setPfmNamingId(vo.getRecordId());
        dto.setNamingType(vo.getCodeNamingType());
        dto.setNamingItemCode(vo.getTxtEditNamingItemCode());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setNamingItemName(vo.getTxtEditNamingItemName());
        dto.setNamingItemAbbr(vo.getTxtEditNamingItemAbbr());
        dto.setInactivateFlag(Integer.valueOf(vo.getPltEditInactivate()).intValue());
    }

    protected void setVoFields(NamingDtoInterface dto) {
        NamingMasterVo vo = (NamingMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmNamingId());
        vo.setTxtEditNamingItemCode(dto.getNamingItemCode());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditNamingItemName(dto.getNamingItemName());
        vo.setTxtEditNamingItemAbbr(dto.getNamingItemAbbr());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }

    protected BaseVo getSpecificVo() {
        return new NamingMasterVo();
    }
}

