/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.system.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.bean.system.UserMasterSearchBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.comparator.system.SectionMasterClassRouteComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.AccountInfoDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.vo.AccountMasterVo;

public class AccountMasterAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF2400";
    public static final String CMD_SET_ACTIVATION_DATE = "PF2401";
    public static final String CMD_SEARCH = "PF2402";
    public static final String CMD_SORT = "PF2404";
    public static final String CMD_PAGE = "PF2405";
    public static final String CMD_REGIST = "PF2407";
    public static final String CMD_DELETE = "PF2409";
    public static final String CMD_INSERT_MODE = "PF2411";
    public static final String CMD_EDIT_MODE = "PF2412";
    public static final String CMD_ADD_MODE = "PF2413";
    public static final String CMD_BATCH_UPDATE = "PF2414";
    public static final String CMD_SET_UPDATE_ACTIVATION_DATE = "PF2415";
    public static final String CMD_SET_BATCH_UPDATE_TYPE = "PF2418";
    public static final String CMD_SET_EMPLOYEE = "PF2416";
    public static final String CMD_PASS_INIT = "PF2417";
    public static final String TYPE_BATCH_UPDATE_ROLE = "role";
    public static final String TYPE_BATCH_UPDATE_INACTIVATE = "inactivate";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        } else if (this.mospParams.getCommand().equals(CMD_SET_BATCH_UPDATE_TYPE)) {
            this.prepareVo();
            this.setJsScrollTo("divMoveUp");
        } else if (this.mospParams.getCommand().equals(CMD_SET_EMPLOYEE)) {
            this.prepareVo();
            this.setEmployee();
        } else if (this.mospParams.getCommand().equals(CMD_PASS_INIT)) {
            this.prepareVo();
            this.initPassword();
        }
    }

    protected BaseVo getSpecificVo() {
        return new AccountMasterVo();
    }

    protected void show() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        this.setBatchPulldown();
        vo.setComparatorName(SectionMasterClassRouteComparator.class.getName());
        this.insertMode();
        vo.setRadBatchUpdateType(TYPE_BATCH_UPDATE_ROLE);
        this.setBatchPulldown();
    }

    protected void search() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        UserMasterSearchBeanInterface search = this.reference().userMasterSearch();
        search.setUserId(vo.getTxtSearchUserId());
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getPltSearchEmployeeCode());
        search.setEmployeeName(vo.getPltSearchEmployeeName());
        search.setRoleCode("");
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void regist() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        UserMasterRegistBeanInterface userRegist = this.platform().userMasterRegist();
        UserPasswordRegistBeanInterface passwordRegist = this.platform().userPasswordRegist();
        UserMasterDtoInterface userDto = userRegist.getInitDto();
        UserPasswordDtoInterface passwordDto = passwordRegist.getInitDto();
        this.setUserDtoFields(userDto);
        this.setPasswordDtoFields(passwordDto);
        userRegist.insert(userDto);
        passwordRegist.regist(passwordDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(userDto.getUserId(), userDto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        UserMasterRegistBeanInterface userRegist = this.platform().userMasterRegist();
        UserMasterDtoInterface userDto = userRegist.getInitDto();
        this.setUserDtoFields(userDto);
        userRegist.add(userDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(userDto.getUserId(), userDto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        UserMasterRegistBeanInterface userRegist = this.platform().userMasterRegist();
        UserMasterDtoInterface userDto = userRegist.getInitDto();
        this.setUserDtoFields(userDto);
        userRegist.update(userDto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(userDto.getUserId(), userDto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void delete() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.platform().userMasterRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.insertMode();
        this.search();
    }

    protected void insertMode() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        this.setEditInsertMode();
        vo.setTxtEditUserId("");
        vo.setTxtEditEmployeeCode("");
        vo.setPltEditRoleCode("");
        this.setEditPulldown();
        vo.setModeEditEmployee("chaning");
        this.setEditEmployee();
    }

    protected void addMode() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        this.setEditAddMode();
        this.setEditPulldown();
        vo.setModeEditEmployee("chaning");
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String userId, Date activateDate) throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        UserMasterDtoInterface userDto = this.reference().user().findForKey(userId, activateDate);
        this.checkSelectedDataExist((Object)userDto);
        this.setVoFields(userDto);
        this.setEditUpdateMode(this.reference().user().getUserHistory(userId));
        this.setEditPulldown();
        vo.setModeEditEmployee("fixed");
        this.setEditEmployee();
    }

    protected void batchUpdate() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        if (vo.getRadBatchUpdateType().equals(TYPE_BATCH_UPDATE_ROLE)) {
            this.platform().userMasterRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), vo.getPltUpdateRoleCode());
        } else {
            this.platform().userMasterRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        }
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setEmployee() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        if (vo.getModeEditEmployee().equals("chaning")) {
            vo.setModeEditEmployee("fixed");
        } else {
            vo.setModeEditEmployee("chaning");
        }
        this.setEditEmployee();
        if (this.mospParams.hasErrorMessage()) {
            this.addSetEmployeeFailedMessage();
            vo.setModeEditEmployee("chaning");
        }
    }

    protected void setEditEmployee() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        if (vo.getModeEditEmployee().equals("chaning")) {
            vo.setPersonalId("");
            vo.setLblEditEmployeeName(this.mospParams.getName("InputEmployeeCode"));
            return;
        }
        HumanReferenceBeanInterface human = this.reference().human();
        vo.setPersonalId(human.getPersonalId(vo.getTxtEditEmployeeCode(), this.getEditActivateDate()));
        vo.setLblEditEmployeeName(human.getHumanName(vo.getPersonalId(), this.getEditActivateDate()));
        if (this.mospParams.hasErrorMessage()) {
            vo.setLblEditEmployeeName(this.mospParams.getName("InputEmployeeCode"));
        }
    }

    protected void initPassword() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        List userIdList = this.platform().userMasterRegist().getUserIdList(this.getIdArray(vo.getCkbSelect()));
        if (this.mospParams.hasErrorMessage()) {
            this.addInitPasswordFaildMessage();
            return;
        }
        this.platform().userPasswordRegist().initPassword(userIdList);
        if (this.mospParams.hasErrorMessage()) {
            this.addInitPasswordFaildMessage();
            return;
        }
        this.commit();
        this.addInitPasswordMessage();
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblUserId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblRole = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            AccountInfoDtoInterface dto = (AccountInfoDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getPfmUserId();
            aryLblUserId[i] = dto.getUserId();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
            aryLblRole[i] = dto.getRoleName();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblUserId(aryLblUserId);
        vo.setAryLblRoleCode(aryLblRole);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void setUserDtoFields(UserMasterDtoInterface dto) throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        dto.setPfmUserId(vo.getRecordId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setUserId(vo.getTxtEditUserId());
        dto.setRoleCode(vo.getPltEditRoleCode());
        dto.setInactivateFlag(Integer.valueOf(vo.getPltEditInactivate()).intValue());
        dto.setPersonalId(this.reference().human().getPersonalId(vo.getTxtEditEmployeeCode(), this.getEditActivateDate()));
    }

    protected void setPasswordDtoFields(UserPasswordDtoInterface dto) throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        dto.setUserId(vo.getTxtEditUserId());
        dto.setPassword(SeUtility.encrypt((String)SeUtility.encrypt((String)vo.getTxtEditUserId())));
        dto.setChangeDate(this.getEditActivateDate());
    }

    public void setVoFields(UserMasterDtoInterface dto) throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(dto.getPersonalId(), dto.getActivateDate());
        vo.setRecordId(dto.getPfmUserId());
        vo.setTxtEditUserId(dto.getUserId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setPltEditRoleCode(dto.getRoleCode());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setTxtEditEmployeeCode("");
        if (humanDto != null) {
            vo.setTxtEditEmployeeCode(humanDto.getEmployeeCode());
        }
    }

    protected void setEditPulldown() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        vo.setAryPltEditRoleCode(this.reference().role().getSelectArray(this.getEditActivateDate(), true));
    }

    protected void setBatchPulldown() throws MospException {
        AccountMasterVo vo = (AccountMasterVo)this.mospParams.getVo();
        vo.setAryPltUpdateRoleCode(this.reference().role().getSelectArray(this.getUpdateActivateDate(), true));
    }

    protected void addSetEmployeeFailedMessage() {
        String rep = this.mospParams.getName("Employee", new String[]{"Select"});
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }

    protected void addInitPasswordMessage() {
        String rep = this.mospParams.getName("Password", new String[]{"Initialization"});
        this.mospParams.addMessage("PFI0001", new String[]{rep});
    }

    protected void addInitPasswordFaildMessage() {
        String rep = this.mospParams.getName("Password", new String[]{"Initialization"});
        this.mospParams.addMessage("PFI0002", new String[]{rep});
    }
}

