/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.portal.action;

import java.util.ArrayList;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.portal.vo.PasswordChangeVo;

public class PasswordChangeAction
extends PlatformAction {
    protected static final String APP_MIN_PASSWORD = "MinPassword";
    protected static final String APP_CHAR_PASSWORD = "CharPassword";
    public static final String CMD_SHOW = "PF9110";
    public static final String CMD_SELECT = "PF9116";
    public static final String CMD_UPDATE = "PF9118";

    protected BaseVo getSpecificVo() {
        return new PasswordChangeVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        }
    }

    protected void show() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        vo.setForced(true);
        this.setNaviUrl();
        vo.setJsMinPassword(this.getMinPassword());
        vo.setJsCharPassword(this.getCharPassword());
        this.setAttentionList();
    }

    protected void select() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        vo.setForced(false);
        vo.setJsMinPassword(this.getMinPassword());
        vo.setJsCharPassword(this.getCharPassword());
        this.setAttentionList();
    }

    protected void update() throws MospException {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        String newPass = SeUtility.encrypt((String)vo.getHdnNewPassword());
        String oldPass = SeUtility.encrypt((String)vo.getHdnOldPassword());
        String confirmPass = SeUtility.encrypt((String)vo.getHdnConfirmPassword());
        PasswordCheckBeanInterface check = this.platform().passwordCheck();
        check.checkPasswordChange(this.mospParams.getUser().getUserId(), oldPass, newPass, confirmPass);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            this.setNaviUrl();
            return;
        }
        UserPasswordRegistBeanInterface regist = this.platform().userPasswordRegist();
        UserPasswordDtoInterface dto = regist.getInitDto();
        dto.setUserId(this.mospParams.getUser().getUserId());
        dto.setPassword(newPass);
        dto.setChangeDate(this.getSystemDate());
        regist.regist(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            this.setNaviUrl();
            return;
        }
        check.checkPasswordStrength(dto.getUserId());
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            this.setNaviUrl();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        if (vo.isForced()) {
            this.mospParams.setNextCommand("PF0040");
        }
    }

    protected void setNaviUrl() {
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        if (vo.isForced()) {
            this.mospParams.setNaviUrl(null);
        }
    }

    protected void setAttentionList() throws MospException {
        String charPassword;
        String minPassword;
        PasswordChangeVo vo = (PasswordChangeVo)this.mospParams.getVo();
        ArrayList<String> attentionList = new ArrayList<String>();
        vo.setAttentionList(attentionList);
        if (!this.platform().passwordCheck().isInitinalPasswordValid()) {
            attentionList.add(this.mospParams.getProperties().getMessage("PFW9117", null));
        }
        if ((minPassword = this.getMinPassword()) != null && !minPassword.isEmpty()) {
            String[] rep = new String[]{this.mospParams.getName("Password"), minPassword};
            attentionList.add(this.mospParams.getProperties().getMessage("PFW0122", rep));
        }
        if ((charPassword = this.getCharPassword()) != null && !charPassword.isEmpty()) {
            attentionList.add(this.mospParams.getProperties().getMessage("PFW9116", null));
        }
    }

    protected String getMinPassword() {
        return this.mospParams.getApplicationProperty(APP_MIN_PASSWORD);
    }

    protected String getCharPassword() {
        return this.mospParams.getApplicationProperty(APP_CHAR_PASSWORD);
    }
}

