/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.SuspensionRegistBeanInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.SuspensionCardVo;
import jp.mosp.platform.utils.InputCheckUtility;

public class SuspensionCardAction
extends PlatformHumanAction {
    public static final String CMD_SEARCH = "PF1162";
    public static final String CMD_SELECT = "PF1166";
    public static final String CMD_DELETE = "PF1167";
    public static final String CMD_UPDATE = "PF1168";
    public static final String CMD_TRANSFER = "PF1169";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new SuspensionCardVo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.setSuspensionInfo();
    }

    protected void select() throws MospException {
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setSuspensionInfo();
    }

    protected void regist() throws MospException {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        SuspensionRegistBeanInterface regist = this.platform().suspensionRegist();
        List list = regist.getInitDtoList(vo.getAryHidPfaHumanSuspension().length);
        this.setDtoFields(list);
        regist.regist(list);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setSuspensionInfo();
    }

    protected void delete() throws MospException {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(this.getIndexArray(vo.getCkbSelect()), vo.getAryHidPfaHumanSuspension());
        if (idArray.length == 0) {
            this.removeDeletedRow();
            this.addDeleteMessage();
            return;
        }
        this.platform().suspensionRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.removeDeletedRow();
    }

    protected void transfer() {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setSuspensionInfo() throws MospException {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        this.setVoFields(this.reference().suspension().getSuspentionList(vo.getPersonalId()));
    }

    protected void setDefaultValues() {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        String[] aryBlank = new String[]{""};
        vo.setAryHidPfaHumanSuspension(aryBlank);
        vo.setAryTxtSuspensionEndYear(aryBlank);
        vo.setAryTxtSuspensionEndMonth(aryBlank);
        vo.setAryTxtSuspensionEndDay(aryBlank);
        vo.setAryTxtSuspensionReason(aryBlank);
        vo.setAryTxtSuspensionScheduleEndDay(aryBlank);
        vo.setAryTxtSuspensionScheduleEndMonth(aryBlank);
        vo.setAryTxtSuspensionScheduleEndYear(aryBlank);
        vo.setAryTxtSuspensionStartDay(aryBlank);
        vo.setAryTxtSuspensionStartMonth(aryBlank);
        vo.setAryTxtSuspensionStartYear(aryBlank);
    }

    protected void setVoFields(List<SuspensionDtoInterface> list) {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        if (list.isEmpty()) {
            this.setDefaultValues();
            return;
        }
        String[] aryHidPfaHumanSuspension = new String[list.size()];
        String[] aryTxtSuspensionStartYear = new String[list.size()];
        String[] aryTxtSuspensionStartMonth = new String[list.size()];
        String[] aryTxtSuspensionStartDay = new String[list.size()];
        String[] aryTxtSuspensionScheduleEndDay = new String[list.size()];
        String[] aryTxtSuspensionScheduleEndMonth = new String[list.size()];
        String[] aryTxtSuspensionScheduleEndYear = new String[list.size()];
        String[] aryTxtSuspensionEndYear = new String[list.size()];
        String[] aryTxtSuspensionEndMonth = new String[list.size()];
        String[] aryTxtSuspensionEndDay = new String[list.size()];
        String[] aryTxtSuspensionReason = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SuspensionDtoInterface dto = list.get(i);
            aryTxtSuspensionStartYear[i] = this.getStringYear(dto.getStartDate());
            aryTxtSuspensionStartMonth[i] = this.getStringMonth(dto.getStartDate());
            aryTxtSuspensionStartDay[i] = this.getStringDay(dto.getStartDate());
            aryTxtSuspensionScheduleEndYear[i] = this.getStringYear(dto.getScheduleEndDate());
            aryTxtSuspensionScheduleEndMonth[i] = this.getStringMonth(dto.getScheduleEndDate());
            aryTxtSuspensionScheduleEndDay[i] = this.getStringDay(dto.getScheduleEndDate());
            aryTxtSuspensionEndYear[i] = this.getStringYear(dto.getEndDate());
            aryTxtSuspensionEndMonth[i] = this.getStringMonth(dto.getEndDate());
            aryTxtSuspensionEndDay[i] = this.getStringDay(dto.getEndDate());
            aryTxtSuspensionReason[i] = dto.getSuspensionReason();
            aryHidPfaHumanSuspension[i] = String.valueOf(dto.getPfaHumanSuspensionId());
        }
        vo.setAryTxtSuspensionStartYear(aryTxtSuspensionStartYear);
        vo.setAryTxtSuspensionStartMonth(aryTxtSuspensionStartMonth);
        vo.setAryTxtSuspensionStartDay(aryTxtSuspensionStartDay);
        vo.setAryTxtSuspensionScheduleEndYear(aryTxtSuspensionScheduleEndYear);
        vo.setAryTxtSuspensionScheduleEndMonth(aryTxtSuspensionScheduleEndMonth);
        vo.setAryTxtSuspensionScheduleEndDay(aryTxtSuspensionScheduleEndDay);
        vo.setAryTxtSuspensionEndYear(aryTxtSuspensionEndYear);
        vo.setAryTxtSuspensionEndMonth(aryTxtSuspensionEndMonth);
        vo.setAryTxtSuspensionEndDay(aryTxtSuspensionEndDay);
        vo.setAryTxtSuspensionReason(aryTxtSuspensionReason);
        vo.setAryHidPfaHumanSuspension(aryHidPfaHumanSuspension);
    }

    protected void setDtoFields(List<SuspensionDtoInterface> list) {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        for (int i = 0; i < list.size(); ++i) {
            SuspensionDtoInterface dto = list.get(i);
            if (vo.getAryHidPfaHumanSuspension()[i].isEmpty()) {
                dto.setPfaHumanSuspensionId(0L);
            } else {
                dto.setPfaHumanSuspensionId(this.getLong(vo.getAryHidPfaHumanSuspension()[i]));
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setStartDate(this.getSuspensionStartDate(i));
            dto.setEndDate(this.getSuspensionEndDate(i));
            dto.setScheduleEndDate(this.getSuspensionScheduleEndDate(i));
            dto.setSuspensionReason(vo.getAryTxtSuspensionReason()[i]);
            dto.setAllowanceType("");
        }
    }

    protected void removeDeletedRow() {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        int[] deletedRows = this.getIndexArray(vo.getCkbSelect());
        int length = vo.getAryHidPfaHumanSuspension().length - deletedRows.length;
        if (length <= 0) {
            this.setDefaultValues();
            return;
        }
        String[] aryHidPfaHumanSuspension = new String[length];
        String[] aryTxtSuspensionStartYear = new String[length];
        String[] aryTxtSuspensionStartMonth = new String[length];
        String[] aryTxtSuspensionStartDay = new String[length];
        String[] aryTxtSuspensionScheduleEndDay = new String[length];
        String[] aryTxtSuspensionScheduleEndMonth = new String[length];
        String[] aryTxtSuspensionScheduleEndYear = new String[length];
        String[] aryTxtSuspensionEndYear = new String[length];
        String[] aryTxtSuspensionEndMonth = new String[length];
        String[] aryTxtSuspensionEndDay = new String[length];
        String[] aryTxtSuspensionReason = new String[length];
        int idx = 0;
        for (int i = 0; i < vo.getAryHidPfaHumanSuspension().length; ++i) {
            if (this.isIndexed(i, deletedRows)) continue;
            aryTxtSuspensionStartYear[idx] = vo.getAryTxtSuspensionStartYear()[i];
            aryTxtSuspensionStartMonth[idx] = vo.getAryTxtSuspensionStartMonth()[i];
            aryTxtSuspensionStartDay[idx] = vo.getAryTxtSuspensionStartDay()[i];
            aryTxtSuspensionScheduleEndYear[idx] = vo.getAryTxtSuspensionScheduleEndYear()[i];
            aryTxtSuspensionScheduleEndMonth[idx] = vo.getAryTxtSuspensionScheduleEndMonth()[i];
            aryTxtSuspensionScheduleEndDay[idx] = vo.getAryTxtSuspensionScheduleEndDay()[i];
            aryTxtSuspensionEndYear[idx] = vo.getAryTxtSuspensionEndYear()[i];
            aryTxtSuspensionEndMonth[idx] = vo.getAryTxtSuspensionEndMonth()[i];
            aryTxtSuspensionEndDay[idx] = vo.getAryTxtSuspensionEndDay()[i];
            aryTxtSuspensionReason[idx] = vo.getAryTxtSuspensionReason()[i];
            aryHidPfaHumanSuspension[idx++] = vo.getAryHidPfaHumanSuspension()[i];
        }
        vo.setAryTxtSuspensionStartYear(aryTxtSuspensionStartYear);
        vo.setAryTxtSuspensionStartMonth(aryTxtSuspensionStartMonth);
        vo.setAryTxtSuspensionStartDay(aryTxtSuspensionStartDay);
        vo.setAryTxtSuspensionScheduleEndYear(aryTxtSuspensionScheduleEndYear);
        vo.setAryTxtSuspensionScheduleEndMonth(aryTxtSuspensionScheduleEndMonth);
        vo.setAryTxtSuspensionScheduleEndDay(aryTxtSuspensionScheduleEndDay);
        vo.setAryTxtSuspensionEndYear(aryTxtSuspensionEndYear);
        vo.setAryTxtSuspensionEndMonth(aryTxtSuspensionEndMonth);
        vo.setAryTxtSuspensionEndDay(aryTxtSuspensionEndDay);
        vo.setAryTxtSuspensionReason(aryTxtSuspensionReason);
        vo.setAryHidPfaHumanSuspension(aryHidPfaHumanSuspension);
    }

    protected void validate() throws MospException {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        String leaveStartDay = this.mospParams.getName("RetirementLeave", new String[]{"Start", "Day"});
        String[] aryLeaveStartDay = new String[]{leaveStartDay};
        String leaveEndScheduleDay = this.mospParams.getName("RetirementLeave", new String[]{"End", "Schedule", "Day"});
        String[] aryLeaveEndScheduleDay = new String[]{leaveEndScheduleDay};
        String leaveEndDay = this.mospParams.getName("RetirementLeave", new String[]{"End", "Day"});
        String[] aryLeaveEndDay = new String[]{leaveEndDay};
        for (int i = 0; i < vo.getAryTxtSuspensionStartYear().length; ++i) {
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionStartYear()[i], (String[])aryLeaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionStartMonth()[i], (String[])aryLeaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionStartDay()[i], (String[])aryLeaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionStartYear()[i], (String[])aryLeaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionStartMonth()[i], (String[])aryLeaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionStartDay()[i], (String[])aryLeaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionStartYear()[i], (int)4, (String)leaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionStartMonth()[i], (int)2, (String)leaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionStartDay()[i], (int)2, (String)leaveStartDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionScheduleEndYear()[i], (String[])aryLeaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionScheduleEndYear()[i], (String[])aryLeaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionScheduleEndDay()[i], (String[])aryLeaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionScheduleEndYear()[i], (String[])aryLeaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionScheduleEndYear()[i], (String[])aryLeaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionScheduleEndDay()[i], (String[])aryLeaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionScheduleEndYear()[i], (int)4, (String)leaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionScheduleEndMonth()[i], (int)2, (String)leaveEndScheduleDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionScheduleEndDay()[i], (int)2, (String)leaveEndScheduleDay, (MospParams)this.mospParams);
            Date endScheduleDate = this.getDate(vo.getAryTxtSuspensionScheduleEndYear()[i], vo.getAryTxtSuspensionScheduleEndMonth()[i], vo.getAryTxtSuspensionScheduleEndDay()[i]);
            Date startDate = this.getDate(vo.getAryTxtSuspensionStartYear()[i], vo.getAryTxtSuspensionStartMonth()[i], vo.getAryTxtSuspensionStartDay()[i]);
            String[] aryErrDateMessage = new String[]{leaveEndScheduleDay, leaveStartDay + this.mospParams.getName("Since")};
            InputCheckUtility.checkTerm((Date)endScheduleDate, (Date)startDate, (Date)endScheduleDate, (String[])aryErrDateMessage, (MospParams)this.mospParams);
            if (vo.getAryTxtSuspensionEndYear()[i] == null || vo.getAryTxtSuspensionEndYear()[i].isEmpty()) continue;
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionEndYear()[i], (String[])aryLeaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionEndMonth()[i], (String[])aryLeaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getAryTxtSuspensionEndDay()[i], (String[])aryLeaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionEndYear()[i], (String[])aryLeaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionEndMonth()[i], (String[])aryLeaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkNumber((String)vo.getAryTxtSuspensionEndDay()[i], (String[])aryLeaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionEndYear()[i], (int)4, (String)leaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionEndMonth()[i], (int)2, (String)leaveEndDay, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getAryTxtSuspensionEndDay()[i], (int)2, (String)leaveEndDay, (MospParams)this.mospParams);
            Date endDate = this.getDate(vo.getAryTxtSuspensionEndYear()[i], vo.getAryTxtSuspensionEndMonth()[i], vo.getAryTxtSuspensionEndDay()[i]);
            aryErrDateMessage = new String[]{leaveEndDay, leaveStartDay + this.mospParams.getName("Since")};
            InputCheckUtility.checkTerm((Date)endDate, (Date)startDate, (Date)endDate, (String[])aryErrDateMessage, (MospParams)this.mospParams);
        }
    }

    protected Date getSuspensionStartDate(int idx) {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        return this.getDate(vo.getAryTxtSuspensionStartYear()[idx], vo.getAryTxtSuspensionStartMonth()[idx], vo.getAryTxtSuspensionStartDay()[idx]);
    }

    protected Date getSuspensionScheduleEndDate(int idx) {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        return this.getDate(vo.getAryTxtSuspensionScheduleEndYear()[idx], vo.getAryTxtSuspensionScheduleEndMonth()[idx], vo.getAryTxtSuspensionScheduleEndDay()[idx]);
    }

    protected Date getSuspensionEndDate(int idx) {
        SuspensionCardVo vo = (SuspensionCardVo)this.mospParams.getVo();
        return this.getDate(vo.getAryTxtSuspensionEndYear()[idx], vo.getAryTxtSuspensionEndMonth()[idx], vo.getAryTxtSuspensionEndDay()[idx]);
    }
}

