/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryNormalDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.human.action.BasicCardAction;
import jp.mosp.platform.human.action.BasicListAction;
import jp.mosp.platform.human.action.ConcurrentCardAction;
import jp.mosp.platform.human.action.EntranceCardAction;
import jp.mosp.platform.human.action.HumanArrayCardAction;
import jp.mosp.platform.human.action.HumanBinaryArrayCardAction;
import jp.mosp.platform.human.action.HumanBinaryHistoryCardAction;
import jp.mosp.platform.human.action.HumanBinaryHistoryListAction;
import jp.mosp.platform.human.action.HumanBinaryNormalCardAction;
import jp.mosp.platform.human.action.HumanHistoryCardAction;
import jp.mosp.platform.human.action.HumanHistoryListAction;
import jp.mosp.platform.human.action.HumanNormalCardAction;
import jp.mosp.platform.human.action.RetirementCardAction;
import jp.mosp.platform.human.action.SuspensionCardAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.human.vo.HumanInfoVo;

public class HumanInfoAction
extends PlatformHumanAction {
    public static final String CMD_SELECT = "PF1121";
    public static final String CMD_SEARCH = "PF1122";
    public static final String CMD_RE_SEARCH = "PF1123";
    public static final String CMD_TRANSFER = "PF1126";
    public static final String KEY_VIEW_HUMAN_INFO = "HumanInfo";
    public static final String CODE_SECTION = "section";
    public static final String CODE_POSITION = "position";
    public static final String CODE_EMPLOYEMENT = "employment";
    public static final String CODE_WORKPLACE = "workPlace";

    public HumanInfoAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new HumanInfoVo();
    }

    protected void select() throws MospException {
        this.setPlatformHumanSettings(CMD_SEARCH, "all");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.setHumanInfo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.setHumanInfo();
    }

    protected void reSearch() throws MospException {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        this.setDefaultValues();
        this.setHumanInfo();
    }

    protected void transfer() {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(BasicListAction.class.getName())) {
            this.mospParams.setNextCommand("PF1146");
        } else if (actionName.equals(BasicCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1136");
        } else if (actionName.equals(EntranceCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1191");
        } else if (actionName.equals(ConcurrentCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1186");
        } else if (actionName.equals(SuspensionCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1166");
        } else if (actionName.equals(RetirementCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1171");
        } else if (actionName.equals(HumanNormalCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1511");
        } else if (actionName.equals(HumanHistoryListAction.class.getName())) {
            this.mospParams.setNextCommand("PF1546");
        } else if (actionName.equals(HumanHistoryCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1534");
        } else if (actionName.equals("PF1526")) {
            this.mospParams.setNextCommand("PF1526");
        } else if (actionName.equals(HumanArrayCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1524");
        } else if (actionName.equals(HumanBinaryNormalCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1551");
        } else if (actionName.equals(HumanBinaryHistoryListAction.class.getName())) {
            this.mospParams.setNextCommand("PF1586");
        } else if (actionName.equals(HumanBinaryHistoryCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1574");
        } else if (actionName.equals("PF1566")) {
            this.mospParams.setNextCommand("PF1566");
        } else if (actionName.equals(HumanBinaryArrayCardAction.class.getName())) {
            this.mospParams.setNextCommand("PF1564");
        }
    }

    public void setDefaultValues() {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        vo.setNeedPost(this.mospParams.getApplicationPropertyBool("UsePost"));
        vo.setAryDivision(this.mospParams.getApplicationProperties("HumanGeneralDivisions"));
        vo.setLblEntranceDate("");
        vo.setLblEmployment("");
        vo.setLblEmployeeKana("");
        vo.setLblWorkPlace("");
        vo.setLblSection("");
        vo.setLblPosition("");
        vo.setLblPost("");
        vo.setLblRetirementDate("");
        vo.setLblRetirementReason("");
        vo.setLblRetirementDetail("");
        vo.setArySuspensionStartDate(new String[0]);
        vo.setArySuspensionEndDate(new String[0]);
        vo.setArySuspensionsScheduleEndDate(new String[0]);
        vo.setArySuspensionReason(new String[0]);
        vo.setAryConcurrentStartDate(new String[0]);
        vo.setAryConcurrentEndDate(new String[0]);
        vo.setAryConcurrentSectionAbbr(new String[0]);
        vo.setAryConcurrentPositionAbbr(new String[0]);
        vo.setAryConcurrentRemark(new String[0]);
    }

    protected void setHumanInfo() throws MospException {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, targetDate);
        EntranceDtoInterface entranceDto = this.reference().entrance().getEntranceInfo(humanDto.getPersonalId());
        List concurrentDtoList = this.reference().concurrent().getContinuedConcurrentList(humanDto.getPersonalId(), targetDate);
        List suspensionDtoList = this.reference().suspension().getContinuedSuspentionList(humanDto.getPersonalId(), targetDate);
        RetirementDtoInterface retirementDto = this.reference().retirement().getRetireInfo(humanDto.getPersonalId());
        this.setHumanInfo(humanDto, entranceDto, retirementDto, suspensionDtoList, concurrentDtoList);
        this.setHumanGeneralValues(personalId, targetDate);
    }

    private void setHumanGeneralValues(String personalId, Date targetDate) throws MospException {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        for (String division : vo.getAryDivision()) {
            ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(division);
            String type = viewConfig.getType();
            if (type.equals("Normal")) {
                vo.putNormalItem(division, this.reference().humanNormal().getShowHumanNormalMapInfo(division, KEY_VIEW_HUMAN_INFO, personalId, targetDate, targetDate));
                continue;
            }
            if (type.equals("BinaryNormal")) {
                HumanBinaryNormalDtoInterface binaryNormal = this.reference().humanBinaryNormal().findForInfo(personalId, division);
                String[] aryFileType = new String[1];
                String[] aryFileName = new String[1];
                String[] aryFileRemark = new String[1];
                if (binaryNormal != null) {
                    aryFileType[0] = binaryNormal.getFileType();
                    aryFileName[0] = binaryNormal.getFileName();
                    aryFileRemark[0] = binaryNormal.getFileRemark();
                }
                vo.putAryBinaryFileTypeMap(division, aryFileType);
                vo.putAryBinaryFileNameMap(division, aryFileName);
                vo.putAryBinaryFileRemarkMap(division, aryFileRemark);
                continue;
            }
            if (type.equals("History")) {
                LinkedHashMap historyMap = this.reference().humanHistory().getHumanHistoryMapInfo(division, KEY_VIEW_HUMAN_INFO, personalId, targetDate, targetDate);
                if (historyMap == null) {
                    historyMap = new LinkedHashMap();
                    vo.putHistoryItem(division, historyMap);
                    continue;
                }
                ArrayList activeList = new ArrayList(historyMap.keySet());
                if (!activeList.isEmpty()) {
                    vo.putDivisionItem(division, (String)activeList.get(0));
                }
                vo.putHistoryItem(division, historyMap);
                continue;
            }
            if (type.equals("BinaryHistory")) {
                HumanBinaryHistoryDtoInterface binaryHistory = this.reference().humanBinaryHistory().findForInfo(personalId, division, targetDate);
                String[] aryActiveDate = new String[1];
                String[] aryFileType = new String[1];
                String[] aryFileName = new String[1];
                String[] aryFileRemark = new String[1];
                if (binaryHistory != null) {
                    aryActiveDate[0] = DateUtility.getStringDate((Date)binaryHistory.getActivateDate());
                    aryFileType[0] = binaryHistory.getFileType();
                    aryFileName[0] = binaryHistory.getFileName();
                    aryFileRemark[0] = binaryHistory.getFileRemark();
                }
                vo.putAryBinaryActiveDateMap(division, aryActiveDate);
                vo.putAryBinaryFileTypeMap(division, aryFileType);
                vo.putAryBinaryFileNameMap(division, aryFileName);
                vo.putAryBinaryFileRemarkMap(division, aryFileRemark);
                continue;
            }
            if (type.equals("Array")) {
                LinkedHashMap arrayMap = this.reference().humanArray().getRowIdArrayMapInfo(division, KEY_VIEW_HUMAN_INFO, personalId, targetDate);
                vo.putArrayItem(division, arrayMap);
            }
            if (!type.equals("BinaryArray")) continue;
            List binaryArrayList = this.reference().humanBinaryArray().findForItemType(personalId, division);
            String[] aryRowId = new String[binaryArrayList.size()];
            String[] aryActiveDate = new String[binaryArrayList.size()];
            String[] aryFileType = new String[binaryArrayList.size()];
            String[] aryFileName = new String[binaryArrayList.size()];
            String[] aryFileRemark = new String[binaryArrayList.size()];
            for (int i = 0; i < binaryArrayList.size(); ++i) {
                HumanBinaryArrayDtoInterface binaryArrayDto = (HumanBinaryArrayDtoInterface)binaryArrayList.get(i);
                aryRowId[i] = String.valueOf(binaryArrayDto.getHumanRowId());
                aryActiveDate[i] = this.getStringDate(binaryArrayDto.getActivateDate());
                aryFileType[i] = binaryArrayDto.getFileType();
                aryFileName[i] = binaryArrayDto.getFileName();
                aryFileRemark[i] = binaryArrayDto.getFileRemark();
            }
            vo.putAryBinaryRowIdMap(division, aryRowId);
            vo.putAryBinaryActiveDateMap(division, aryActiveDate);
            vo.putAryBinaryFileTypeMap(division, aryFileType);
            vo.putAryBinaryFileNameMap(division, aryFileName);
            vo.putAryBinaryFileRemarkMap(division, aryFileRemark);
        }
    }

    protected void setHumanInfo(HumanDtoInterface humanDto, EntranceDtoInterface entranceDto, RetirementDtoInterface retirementDto, List<SuspensionDtoInterface> suspensionDtoList, List<ConcurrentDtoInterface> concurrentDtoList) throws MospException {
        EmploymentContractDtoInterface employmentContractDto;
        PositionDtoInterface positionDto;
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        SectionReferenceBeanInterface sectionReference = this.reference().section();
        PositionReferenceBeanInterface positionReference = this.reference().position();
        HumanHistoryReferenceBeanInterface humanHistoryReference = this.reference().humanHistory();
        NamingReferenceBeanInterface namingReference = this.reference().naming();
        Date targetDate = vo.getTargetDate();
        vo.setLblEmployeeKana(MospUtility.getHumansName((String)humanDto.getFirstKana(), (String)humanDto.getLastKana()));
        List humanList = this.reference().human().getHistory(humanDto.getPersonalId());
        WorkPlaceDtoInterface workPlaceDto = this.reference().workPlace().getWorkPlaceInfo(humanDto.getWorkPlaceCode(), targetDate);
        vo.setLblWorkPlace(HumanUtility.getWorkPlaceStayMonths((HumanDtoInterface)humanDto, (List)humanList, (Date)targetDate, (WorkPlaceDtoInterface)workPlaceDto, (MospParams)this.mospParams));
        SectionDtoInterface sectionDto = sectionReference.getSectionInfo(humanDto.getSectionCode(), targetDate);
        if (sectionDto != null) {
            vo.setLblSection(HumanUtility.getSectionStayMonths((HumanDtoInterface)humanDto, (List)humanList, (Date)targetDate, (SectionDtoInterface)sectionDto, (MospParams)this.mospParams));
        }
        if ((positionDto = positionReference.getPositionInfo(humanDto.getPositionCode(), targetDate)) != null) {
            vo.setLblPosition(HumanUtility.getPositionStayMonths((HumanDtoInterface)humanDto, (List)humanList, (Date)targetDate, (PositionDtoInterface)positionDto, (MospParams)this.mospParams));
        }
        if ((employmentContractDto = this.reference().employmentContract().getContractInfo(humanDto.getEmploymentContractCode(), targetDate)) != null) {
            vo.setLblEmployment(HumanUtility.getEmploymentStayMonths((HumanDtoInterface)humanDto, (List)humanList, (Date)targetDate, (EmploymentContractDtoInterface)employmentContractDto, (MospParams)this.mospParams));
        }
        if (vo.getNeedPost()) {
            List postList = humanHistoryReference.findForHistory(humanDto.getPersonalId(), "post");
            HumanHistoryDtoInterface postDto = humanHistoryReference.findForKey(humanDto.getPersonalId(), "post", humanDto.getActivateDate());
            if (postDto != null && !postList.isEmpty()) {
                String namingItemName = namingReference.getNamingItemName("post", postDto.getHumanItemValue(), targetDate);
                vo.setLblPost(HumanUtility.getPostStayMonths((HumanDtoInterface)humanDto, (List)humanList, (Date)targetDate, (List)postList, (HumanHistoryDtoInterface)postDto, (MospParams)this.mospParams, (String)namingItemName));
            }
        }
        if (entranceDto != null) {
            vo.setLblEntranceDate(this.getStringDate(entranceDto.getEntranceDate()));
            int amountMonth = DateUtility.getMonthDifference((Date)entranceDto.getEntranceDate(), (Date)targetDate);
            vo.setLblYearsOfService(HumanUtility.getDuration((int)amountMonth, (MospParams)this.mospParams));
        }
        if (retirementDto != null) {
            vo.setLblRetirementDate(this.getStringDate(retirementDto.getRetirementDate()));
            vo.setLblRetirementReason(this.mospParams.getProperties().getCodeItemName("Retirement", retirementDto.getRetirementReason()));
            vo.setLblRetirementDetail(retirementDto.getRetirementDetail());
        }
        String[] arySuspensionStartDate = new String[suspensionDtoList.size()];
        String[] arySuspensionEndDate = new String[suspensionDtoList.size()];
        String[] arySuspensionsScheduleEndDate = new String[suspensionDtoList.size()];
        String[] arySuspensionReason = new String[suspensionDtoList.size()];
        for (int i = 0; i < suspensionDtoList.size(); ++i) {
            SuspensionDtoInterface dto = suspensionDtoList.get(i);
            arySuspensionStartDate[i] = this.getStringDate(dto.getStartDate());
            arySuspensionEndDate[i] = this.getStringDate(dto.getEndDate());
            arySuspensionsScheduleEndDate[i] = this.getStringDate(dto.getScheduleEndDate());
            arySuspensionReason[i] = dto.getSuspensionReason();
        }
        vo.setArySuspensionStartDate(arySuspensionStartDate);
        vo.setArySuspensionEndDate(arySuspensionEndDate);
        vo.setArySuspensionsScheduleEndDate(arySuspensionsScheduleEndDate);
        vo.setArySuspensionReason(arySuspensionReason);
        String[] aryConcurrentStartDate = new String[concurrentDtoList.size()];
        String[] aryConcurrentEndDate = new String[concurrentDtoList.size()];
        String[] aryConcurrentSectionAbbr = new String[concurrentDtoList.size()];
        String[] aryConcurrentPositionAbbr = new String[concurrentDtoList.size()];
        String[] aryConcurrentRemark = new String[concurrentDtoList.size()];
        for (int i = 0; i < concurrentDtoList.size(); ++i) {
            PositionDtoInterface concurrentPositionDto;
            ConcurrentDtoInterface dto = concurrentDtoList.get(i);
            aryConcurrentStartDate[i] = this.getStringDate(dto.getStartDate());
            aryConcurrentEndDate[i] = this.getStringDate(dto.getEndDate());
            aryConcurrentRemark[i] = dto.getConcurrentRemark();
            SectionDtoInterface concurrentSectionDto = sectionReference.getSectionInfo(dto.getSectionCode(), dto.getStartDate());
            if (concurrentSectionDto != null) {
                aryConcurrentSectionAbbr[i] = concurrentSectionDto.getSectionAbbr();
            }
            if ((concurrentPositionDto = positionReference.getPositionInfo(dto.getPositionCode(), dto.getStartDate())) == null) continue;
            aryConcurrentPositionAbbr[i] = concurrentPositionDto.getPositionAbbr();
        }
        vo.setAryConcurrentStartDate(aryConcurrentStartDate);
        vo.setAryConcurrentEndDate(aryConcurrentEndDate);
        vo.setAryConcurrentSectionAbbr(aryConcurrentSectionAbbr);
        vo.setAryConcurrentPositionAbbr(aryConcurrentPositionAbbr);
        vo.setAryConcurrentRemark(aryConcurrentRemark);
    }
}

