/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.exporter.ImageContents;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.HumanBinaryArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryNormalReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanBinaryArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanBinaryNormalDtoInterface;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanBinaryArrayCardVo;
import jp.mosp.platform.human.vo.HumanBinaryHistoryCardVo;
import jp.mosp.platform.human.vo.HumanBinaryHistoryListVo;
import jp.mosp.platform.human.vo.HumanBinaryNormalCardVo;
import jp.mosp.platform.human.vo.HumanInfoVo;
import jp.mosp.platform.utils.PlatformUtility;

public class HumanBinaryOutputFileAction
extends PlatformHumanAction {
    public static final String CMD_NORAML_FILE = "PF1601";
    public static final String CMD_HISTORY_FILE = "PF1602";
    public static final String CMD_HISTORY_LIST_FILE = "PF1603";
    public static final String CMD_ARRAY_FILE = "PF1604";
    public static final String CMD_NORAML_INFO_FILE = "PF1605";
    public static final String CMD_HISTORY_INFO_FILE = "PF1606";
    public static final String CMD_ARRAY_INFO_FILEE = "PF1607";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_NORAML_FILE)) {
            this.prepareVo(true, false);
            this.normal();
        } else if (this.mospParams.getCommand().equals(CMD_HISTORY_FILE)) {
            this.prepareVo(true, false);
            this.history();
        } else if (this.mospParams.getCommand().equals(CMD_HISTORY_LIST_FILE)) {
            this.prepareVo(true, false);
            this.historyList();
        } else if (this.mospParams.getCommand().equals(CMD_ARRAY_FILE)) {
            this.prepareVo(true, false);
            this.array();
        } else if (this.mospParams.getCommand().equals(CMD_NORAML_INFO_FILE)) {
            this.prepareVo(true, false);
            this.normalInfoFile();
        } else if (this.mospParams.getCommand().equals(CMD_HISTORY_INFO_FILE)) {
            this.prepareVo(true, false);
            this.historyInfoFile();
        } else if (this.mospParams.getCommand().equals(CMD_ARRAY_INFO_FILEE)) {
            this.prepareVo(true, false);
            this.arrayInfoFile();
        } else {
            this.throwInvalidCommandException();
        }
    }

    public void normal() throws MospException {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        HumanBinaryNormalReferenceBeanInterface binaryNormal = this.reference().humanBinaryNormal();
        HumanBinaryNormalDtoInterface normalDto = binaryNormal.findForInfo(vo.getPersonalId(), vo.getDivision());
        this.mospParams.setFile((Object)new ImageContents(normalDto.getFileType(), normalDto.getHumanItemBinary()));
        String fileName = normalDto.getFileName();
        String fileType = this.getCodeName(normalDto.getFileType(), "BinaryFileType");
        boolean isBroadMatch = PlatformUtility.isBroadMatch((String)fileType, (String)fileName);
        if (!isBroadMatch) {
            fileName = fileName + fileType;
        }
        this.mospParams.setFileName(fileName);
        this.mospParams.setFileName(normalDto.getFileName());
    }

    public void history() throws MospException {
        HumanBinaryHistoryCardVo vo = (HumanBinaryHistoryCardVo)this.mospParams.getVo();
        HumanBinaryHistoryReferenceBeanInterface binaryHistory = this.reference().humanBinaryHistory();
        String year = this.mospParams.getRequestParam("historyYear");
        String month = this.mospParams.getRequestParam("historyMonth");
        String day = this.mospParams.getRequestParam("historyDay");
        HumanBinaryHistoryDtoInterface historyDto = binaryHistory.findForInfo(vo.getPersonalId(), vo.getDivision(), DateUtility.getDate((String)year, (String)month, (String)day));
        if (historyDto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(historyDto.getFileType(), historyDto.getHumanItemBinary()));
        this.mospParams.setFileName(historyDto.getFileName());
    }

    public void historyList() throws MospException {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        Date activeDate = this.getDate(this.getTransferredActivateDate());
        HumanBinaryHistoryReferenceBeanInterface binaryHistory = this.reference().humanBinaryHistory();
        HumanBinaryHistoryDtoInterface historyDto = binaryHistory.findForInfo(vo.getPersonalId(), vo.getDivision(), activeDate);
        if (historyDto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(historyDto.getFileType(), historyDto.getHumanItemBinary()));
        this.mospParams.setFileName(historyDto.getFileName());
    }

    public void array() throws MospException {
        HumanBinaryArrayCardVo vo = (HumanBinaryArrayCardVo)this.mospParams.getVo();
        int rowId = this.getTransferredIndex();
        HumanBinaryArrayReferenceBeanInterface binaryArray = this.reference().humanBinaryArray();
        HumanBinaryArrayDtoInterface arrayDto = binaryArray.findForKey(vo.getPersonalId(), vo.getDivision(), rowId);
        if (arrayDto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(arrayDto.getFileType(), arrayDto.getHumanItemBinary()));
        this.mospParams.setFileName(arrayDto.getFileName());
    }

    public void normalInfoFile() throws MospException {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        HumanBinaryNormalReferenceBeanInterface binaryNormal = this.reference().humanBinaryNormal();
        String division = this.getTransferredType();
        HumanBinaryNormalDtoInterface normalDto = binaryNormal.findForInfo(vo.getPersonalId(), division);
        if (normalDto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(normalDto.getFileType(), normalDto.getHumanItemBinary()));
        this.mospParams.setFileName(normalDto.getFileName());
    }

    private void historyInfoFile() throws MospException {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        HumanBinaryHistoryReferenceBeanInterface binaryHistory = this.reference().humanBinaryHistory();
        String division = this.getTransferredType();
        Date activeDate = this.getDate(this.getTransferredActivateDate());
        HumanBinaryHistoryDtoInterface historyDto = binaryHistory.findForInfo(vo.getPersonalId(), division, activeDate);
        if (historyDto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(historyDto.getFileType(), historyDto.getHumanItemBinary()));
        this.mospParams.setFileName(historyDto.getFileName());
    }

    public void arrayInfoFile() throws MospException {
        HumanInfoVo vo = (HumanInfoVo)this.mospParams.getVo();
        String division = this.getTransferredType();
        int rowId = this.getTransferredIndex();
        HumanBinaryArrayReferenceBeanInterface binaryArray = this.reference().humanBinaryArray();
        HumanBinaryArrayDtoInterface arrayDto = binaryArray.findForKey(vo.getPersonalId(), division, rowId);
        if (arrayDto == null) {
            this.addNoSearchResultMessage();
            return;
        }
        this.mospParams.setFile((Object)new ImageContents(arrayDto.getFileType(), arrayDto.getHumanItemBinary()));
        this.mospParams.setFileName(arrayDto.getFileName());
    }

    protected BaseVo getSpecificVo() {
        if (this.mospParams.getCommand().equals(CMD_NORAML_FILE)) {
            return new HumanBinaryNormalCardVo();
        }
        if (this.mospParams.getCommand().equals(CMD_HISTORY_FILE)) {
            return new HumanBinaryHistoryCardVo();
        }
        if (this.mospParams.getCommand().equals(CMD_HISTORY_LIST_FILE)) {
            return new HumanBinaryHistoryListVo();
        }
        if (this.mospParams.getCommand().equals(CMD_ARRAY_FILE)) {
            return new HumanBinaryArrayCardVo();
        }
        return new HumanInfoVo();
    }
}

